/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.urban_decor.common.block.TowelBarTowelBlock;
import net.yirmiri.urban_decor.common.block.TowelBlock;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractDecorBlock;
import net.yirmiri.urban_decor.core.init.UDTags;

public class TowelBarBlock
extends AbstractDecorBlock {
    private static final VoxelShape SHAPE_NORTH = Stream.of(Block.box((double)0.0, (double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_WEST = Stream.of(Block.box((double)14.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)12.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_EAST = Stream.of(Block.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)2.0, (double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_SOUTH = Stream.of(Block.box((double)14.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public TowelBarBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Block block;
        ItemStack stackHand = player.getItemInHand(hand);
        Item item = stackHand.getItem();
        if (stackHand.is(UDTags.ItemT.TOWELS) && (block = Block.byItem((Item)item)) instanceof TowelBlock) {
            if (!player.isCreative()) {
                stackHand.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(pos, (BlockState)TowelBarTowelBlock.getTowelColors(block).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

