/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.yirmiri.urban_decor.common.block.TowelBarBlock;
import net.yirmiri.urban_decor.core.registry.UDBlocks;

public class TowelBarTowelBlock
extends TowelBarBlock {
    private static final Map<Block, TowelBarTowelBlock> TOWELS_TO_BAR = Maps.newHashMap();
    private final Block towel;

    public TowelBarTowelBlock(Block towel, BlockBehaviour.Properties settings) {
        super(settings);
        this.towel = towel;
        TOWELS_TO_BAR.put(towel, this);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)UDBlocks.TOWEL_BAR.get());
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool);
        TowelBarTowelBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)UDBlocks.TOWEL_BAR.get().asItem()));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack towel = new ItemStack((ItemLike)this.towel);
        if (!player.addItem(towel)) {
            player.drop(towel, false);
        }
        level.setBlock(pos, (BlockState)UDBlocks.TOWEL_BAR.get().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
        return InteractionResult.CONSUME;
    }

    public static BlockState getTowelColors(Block towel) {
        return TOWELS_TO_BAR.get(towel).defaultBlockState();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }
}

