/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block.abstracts;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractDecorBlock;

public abstract class AbstractLongBlock
extends AbstractDecorBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;

    public AbstractLongBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == AbstractLongBlock.getDirectionTowardsOtherPart((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            return neighborState.is((Block)this) && neighborState.getValue(PART) != state.getValue(PART) ? state : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.isClientSide && player.isCreative() && (bedPart = (BedPart)state.getValue(PART)) == BedPart.FOOT && (blockState = world.getBlockState(blockPos = pos.relative(AbstractLongBlock.getDirectionTowardsOtherPart(bedPart, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockState.getValue(PART) == BedPart.HEAD) {
            world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getHorizontalDirection();
        BlockPos blockPos = ctx.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(direction);
        Level world = ctx.getLevel();
        return world.getBlockState(blockPos2).canBeReplaced(ctx) && world.getWorldBorder().isWithinBounds(blockPos2) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
            world.setBlock(blockPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        }
    }

    public long getSeed(BlockState state, BlockPos pos) {
        BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING), state.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed((int)blockPos.getX(), (int)pos.getY(), (int)blockPos.getZ());
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

