/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.yirmiri.urban_decor.common.block.abstracts.AbstractFurnaceDecorBlock;
import net.yirmiri.urban_decor.core.registry.UDBlockEntities;
import net.yirmiri.urban_decor.core.registry.UDSounds;

public class FurnaceDecorBlockEntity
extends AbstractFurnaceBlockEntity {
    private final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void onOpen(Level world, BlockPos pos, BlockState state) {
            FurnaceDecorBlockEntity.this.playSound(state, UDSounds.APPLIANCE_OPEN.get());
            FurnaceDecorBlockEntity.this.setOpen(state, true);
        }

        protected void onClose(Level world, BlockPos pos, BlockState state) {
            FurnaceDecorBlockEntity.this.playSound(state, UDSounds.APPLIANCE_OPEN.get());
            if (AbstractFurnaceDecorBlock.isTrulyOpen(state)) {
                FurnaceDecorBlockEntity.this.setOpen(state, true);
            } else if (!AbstractFurnaceDecorBlock.isTrulyOpen(state)) {
                FurnaceDecorBlockEntity.this.setOpen(state, false);
            }
        }

        protected void openerCountChanged(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        }

        protected boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof ChestMenu) {
                Container inventory = ((ChestMenu)player.containerMenu).getContainer();
                return inventory == FurnaceDecorBlockEntity.this;
            }
            return false;
        }
    };

    public FurnaceDecorBlockEntity(BlockPos pos, BlockState state) {
        super(UDBlockEntities.FURNACE_DECOR.get(), pos, state, RecipeType.SMELTING);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.urban_decor.furnace");
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new FurnaceMenu(syncId, playerInventory, (Container)this, this.dataAccess);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.stateManager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.stateManager.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void setOpen(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)AbstractFurnaceDecorBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.getValue((Property)AbstractFurnaceDecorBlock.FACING)).getNormal();
        double d = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double e = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double f = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }
}

