/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.yirmiri.urban_decor.core.registry.UDBlockEntities;

public class ToasterBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final int[] cookingProgress = new int[2];
    private final int[] cookingTime = new int[2];
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);

    public ToasterBlockEntity(BlockPos pos, BlockState blockState) {
        super(UDBlockEntities.TOASTER.get(), pos, blockState);
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)blockEntity.items.get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            blockEntity.cookingProgress[n] = blockEntity.cookingProgress[n] + 1;
            if (blockEntity.cookingProgress[i] < blockEntity.cookingTime[i] || !(itemstack1 = blockEntity.quickCheck.getRecipeFor((RecipeInput)(singlerecipeinput = new SingleRecipeInput(itemstack)), level).map(p_344662_ -> ((CampfireCookingRecipe)p_344662_.value()).assemble(singlerecipeinput, (HolderLookup.Provider)level.registryAccess())).orElse(itemstack)).isItemEnabled(level.enabledFeatures())) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemstack1);
            blockEntity.items.set(i, (Object)ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (flag) {
            ToasterBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            if (blockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            blockEntity.cookingProgress[i] = Mth.clamp((int)(blockEntity.cookingProgress[i] - 2), (int)0, (int)blockEntity.cookingTime[i]);
        }
        if (flag) {
            ToasterBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity blockEntity) {
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        int[] aint1;
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (tag.contains("CookingTimes", 11)) {
            aint1 = tag.getIntArray("CookingTimes");
            System.arraycopy(aint1, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint1.length));
        }
        if (tag.contains("CookingTotalTimes", 11)) {
            aint1 = tag.getIntArray("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (boolean)true, (HolderLookup.Provider)registries);
        tag.putIntArray("CookingTimes", this.cookingProgress);
        tag.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundtag, this.items, (boolean)true, (HolderLookup.Provider)registries);
        return compoundtag;
    }

    public Optional<RecipeHolder<CampfireCookingRecipe>> getCookableRecipe(ItemStack stack) {
        return this.items.stream().noneMatch(ItemStack::isEmpty) ? Optional.empty() : this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level);
    }

    public boolean placeFood(LivingEntity entity, ItemStack food, int cookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            this.cookingTime[i] = cookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)food.consumeAndReturn(1, entity));
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("Items");
    }
}

