/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.common.util;

import java.util.function.ToIntFunction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class UDProperties {
    public static ToIntFunction<BlockState> createLightLevelFromLitBlockState(int litLevel) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? litLevel : 0;
    }

    public static class ItemP {
        public static final Item.Properties GENERIC_ITEM = new Item.Properties();
        public static final Item.Properties TOOLBOX = new Item.Properties().stacksTo(1);
    }

    public static class BlockP {
        public static final BlockBehaviour.Properties PORCELAIN = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties DARK_PORCELAIN = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.COLOR_BLACK).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties CHROMITE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRANITE).mapColor(MapColor.TERRACOTTA_CYAN);
        public static final BlockBehaviour.Properties POLISHED_CHROMITE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_GRANITE).mapColor(MapColor.TERRACOTTA_CYAN);
        public static final BlockBehaviour.Properties RIGID_GLASS = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).destroyTime(0.8f).explosionResistance(0.8f);
        public static final BlockBehaviour.Properties STAINLESS_STEEL = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties STEEL_LANTERN = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties STEEL_SOUL_LANTERN = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_LANTERN).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties STEEL_PIPE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties STEEL_BARS = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties STEEL_DOOR = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_DOOR).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties STEEL_TRAPDOOR = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_TRAPDOOR).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties TRASH_CAN = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.3f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN);
        public static final BlockBehaviour.Properties MICROWAVE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.8f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN);
        public static final BlockBehaviour.Properties SINK = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.0f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties TOILET = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.0f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties WASHING_MACHINE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.5f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties DRYER = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.5f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties TOASTER = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.5f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN).pushReaction(PushReaction.BLOCK);
        public static final BlockBehaviour.Properties DESK_FAN = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.3f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN);
        public static final BlockBehaviour.Properties OVEN = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.5f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties STOVE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.3f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN);
        public static final BlockBehaviour.Properties FRIDGE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.5f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties FREEZER = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.5f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties BATHTUB = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(2.0f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties PICTURE_FRAME = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).noCollission().strength(0.3f).sound(SoundType.WOOD);
        public static final BlockBehaviour.Properties CUPBOARD = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.0f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties FILING_CABINET = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(3.0f).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties TOILET_PAPER = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.3f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN);
        public static final BlockBehaviour.Properties FLOOR_LAMP = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).lightLevel(UDProperties.createLightLevelFromLitBlockState(15)).instabreak().mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN);
        public static final BlockBehaviour.Properties PIANO = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
        public static final BlockBehaviour.Properties NETHER_PIANO = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_PLANKS);
        public static final BlockBehaviour.Properties CHERRY_PIANO = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS);
        public static final BlockBehaviour.Properties BAMBOO_PIANO = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS);
        public static final BlockBehaviour.Properties DISHWASHER = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.5f).mapColor(MapColor.SNOW).sound(SoundType.CALCITE).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties AIR_CONDITIONER = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.0f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.LANTERN).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties TOOLBOX = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.5f).mapColor(MapColor.COLOR_RED).sound(SoundType.LANTERN);
        public static final BlockBehaviour.Properties FAUCET = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.3f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties RADIATOR = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(1.0f).mapColor(MapColor.SNOW).sound(SoundType.COPPER).requiresCorrectToolForDrops();
        public static final BlockBehaviour.Properties TURBINE = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.5f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties TOWEL_BAR = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.5f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.COPPER);
        public static final BlockBehaviour.Properties SATELLITE_DISH = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.5f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.COPPER).noCollission();
        public static final BlockBehaviour.Properties SHOWER = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.3f).mapColor(MapColor.COLOR_GRAY).sound(SoundType.COPPER);
    }
}

