/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.urban_decor.core.registry;

import java.util.HashMap;
import java.util.function.Supplier;
import net.azurune.runiclib.core.platform.Services;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.yirmiri.urban_decor.common.item.ToolboxBlockItem;
import net.yirmiri.urban_decor.common.util.UDProperties;
import net.yirmiri.urban_decor.core.registry.UDBlocks;

public class UDItems {
    public static final Supplier<Item> PORCELAIN = UDItems.register("porcelain", () -> new Item(UDProperties.ItemP.GENERIC_ITEM));
    public static final Supplier<Item> DARK_PORCELAIN = UDItems.register("dark_porcelain", () -> new Item(UDProperties.ItemP.GENERIC_ITEM));
    public static final Supplier<Item> STAINLESS_STEEL_INGOT = UDItems.register("stainless_steel_ingot", () -> new Item(UDProperties.ItemP.GENERIC_ITEM));
    public static final Supplier<Item> STAINLESS_STEEL_NUGGET = UDItems.register("stainless_steel_nugget", () -> new Item(UDProperties.ItemP.GENERIC_ITEM));
    public static final Supplier<Item> STEEL_PIPE = UDItems.register("steel_pipe", () -> new BlockItem(UDBlocks.STEEL_PIPE.get(), UDProperties.ItemP.GENERIC_ITEM));
    public static final Supplier<Item> TOOLBOX = UDItems.register("toolbox", () -> new ToolboxBlockItem(UDBlocks.TOOLBOX.get(), UDProperties.ItemP.TOOLBOX));
    public static final Supplier<Item> MICROWAVE = UDItems.register("microwave", () -> new StandingAndWallBlockItem(UDBlocks.MICROWAVE.get(), UDBlocks.WALL_MICROWAVE.get(), UDProperties.ItemP.GENERIC_ITEM, Direction.DOWN));
    public static final Supplier<Item> SATELLITE_DISH = UDItems.register("satellite_dish", () -> new StandingAndWallBlockItem(UDBlocks.SATELLITE_DISH.get(), UDBlocks.WALL_SATELLITE_DISH.get(), UDProperties.ItemP.GENERIC_ITEM, Direction.DOWN));
    public static final HashMap<DyeColor, Supplier<Item>> DYED_PICTURE_FRAMES = new HashMap();
    public static final Supplier<Item> PICTURE_FRAME = UDItems.register("picture_frame", () -> new StandingAndWallBlockItem(UDBlocks.PICTURE_FRAME.get(), UDBlocks.WALL_PICTURE_FRAME.get(), UDProperties.ItemP.GENERIC_ITEM, Direction.DOWN));

    public static Supplier<Item> getDyedPictureFrames(int colors) {
        return DYED_PICTURE_FRAMES.get(DyeColor.byId((int)colors));
    }

    public static Supplier<Item> register(String id, Supplier<Item> supplier) {
        return Services.REGISTRY.registerItem("urban_decor", id, supplier);
    }

    public static void loadItems() {
    }

    static {
        for (DyeColor colors : DyeColor.values()) {
            DYED_PICTURE_FRAMES.put(colors, UDItems.register(String.valueOf(colors) + "_picture_frame", () -> new StandingAndWallBlockItem(UDBlocks.getDyedPictureBlocks(colors.getId()).get(), UDBlocks.getDyedWallPictureBlocks(colors.getId()).get(), UDProperties.ItemP.GENERIC_ITEM, Direction.DOWN)));
        }
    }
}

