package cc.thonly.registry_modifier.api;

import cc.thonly.registry_modifier.mixin.NamedAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9248;
import net.minecraft.registry.*;
import java.util.*;


@SuppressWarnings({"unchecked", "deprecation"})
public interface DynamicRegistryManagerCallback {
    List<Builder<?>> CALLBACKS = new ArrayList<>();

    static <T> void add(Builder<T> builder) {
        CALLBACKS.add(builder);
    }

    static void start(class_2370<?> registry) {
        for (Builder<?> factory : CALLBACKS) {
            if (factory.registryKey.equals(registry.method_46765())) {
                factory.start(registry);
//                System.out.println(registry);
            }
        }

    }

    static <T> Builder<T> createBuilder(class_5321<? extends class_2378<T>> registryKey) {
        return new Builder<>(registryKey);
    }

    @Getter
    @Slf4j
    class Builder<T> {
        private final class_5321<? extends class_2378<T>> registryKey;
        private final Map<class_2960, T> registries = new Object2ObjectLinkedOpenHashMap<>();
        private final Map<class_2960, class_6880<T>> entries = new Object2ObjectLinkedOpenHashMap<>();
        private final Map<class_2960, class_9248> infos = new Object2ObjectLinkedOpenHashMap<>();
        private final List<Info<T>> registryInfos = new ObjectArrayList<>();
        private final List<TagKeyBuilder<T>> tagKeyBuilders = new ObjectArrayList<>();

        protected Builder(class_5321<? extends class_2378<T>> registryKey) {
            assert registryKey != null;
            this.registryKey = registryKey;
        }

        public T register(class_2960 key, T value) {
            return register(key, value, class_9248.field_49136);
        }

        public T register(class_2960 key, T value, class_9248 info) {
            return register(key, class_6880.method_40223(value), info);
        }

        public T register(class_2960 key, class_6880<T> value) {
            return register(key, value, class_9248.field_49136);
        }

        public T register(class_2960 key, class_6880<T> registryEntry, class_9248 info) {
            class_5321<T> registryKey = class_5321.method_29179(this.registryKey, key);
            T value = registryEntry.comp_349();
            this.registries.put(key, value);
            this.entries.put(key, registryEntry);
            this.infos.put(key, info);
            if (registryEntry instanceof class_6880.class_6883<T> reference) {
                reference.method_45917(registryKey);
            }
            this.registryInfos.add(new Info<>(registryKey, value, registryEntry, info));
            return value;
        }

        public void addTagBuilder(TagKeyBuilder<T>... tagKeyBuilder) {
            this.tagKeyBuilders.addAll(Arrays.asList(tagKeyBuilder));
        }

        public synchronized void start(class_2370<?> sr) {
            class_2370<T> registry = (class_2370<T>) sr;
            this.build(registry);
            this.buildTags(registry);
        }

        protected synchronized void build(class_2370<T> registry) {
            for (Info<T> registryInfo : this.registryInfos) {
                try {
                    class_5321<T> key = registryInfo.getKey();
                    T value = registryInfo.getValue();
                    if (       !registry.method_35842(key)
                            && !registry.method_10250(key.method_29177())
                            && !registry.field_11107.containsKey(key.method_29177())
                            && !registry.field_36461.containsKey(value)
                    ) {
                        registry.method_10272(key, value, class_9248.field_49136);
                    }
                } catch (Exception err) {
                    log.error("Can't add registry {}", registryInfo.getKey());
                }
            }
//            for (Info<T> registryInfo : this.registryInfos) {
//                if (!(registryInfo.registryEntry instanceof RegistryEntry.Reference<?>)) {
//                    var reference = RegistryEntry.Reference.intrusive(registry, registryInfo.value);
//                    registryInfo.registryEntry = reference;
//                    reference.setRegistryKey(registryInfo.key);
//                }
//                registry.keyToEntry.remove(registryInfo.key);
//                registry.idToEntry.remove(registryInfo.key.getValue());
//                registry.valueToEntry.remove(registryInfo.value);
//                registry.entryToRawId.removeInt(registryInfo.value);
//                registry.keyToEntryInfo.remove(registryInfo.key);
//            }
//            for (Info<T> registryInfo : this.registryInfos) {
//                if (!(registryInfo.value instanceof RegistryEntry.Reference<?>)) continue;
//                var reference = (RegistryEntry.Reference<T>) registryInfo.value;
//                registry.keyToEntry.put(registryInfo.key, reference);
//                registry.idToEntry.put(registryInfo.key.getValue(), reference);
//                registry.valueToEntry.put(registryInfo.value, reference);
//                int next = registry.rawIdToEntry.size();
//                registry.entryToRawId.put(registryInfo.value, next);
//                registry.keyToEntryInfo.put(registryInfo.key, registryInfo.info);
//                registry.getLifecycle().add(registryInfo.info.lifecycle());
//            }
        }

        protected void buildTags(class_2370<T> registry) {
            for (TagKeyBuilder<T> tagKeyBuilder : this.tagKeyBuilders) {
                class_6885.class_6888<T> named = registry.field_53686.computeIfAbsent(tagKeyBuilder.tagKey, x -> NamedAccessor.callNew(registry, tagKeyBuilder.tagKey));

                for (T value : tagKeyBuilder.values) {
                    class_6880<T> entry = registry.method_47983(value);
                    if (named.field_36460 != null) {
                        named.field_36460.add(entry);
                    } else {
                        named.field_36460 = new ArrayList<>();
                    }
                }
            }
        }

        public static <T> Builder<T> create(class_5321<? extends class_2378<T>> registryKey) {
            return new Builder<>(registryKey);
        }

        @Getter
        @AllArgsConstructor
        public static class Info<T> {
            class_5321<T> key;
            T value;
            class_6880<T> registryEntry;
            class_9248 info;
        }

        @Getter
        public static class TagKeyBuilder<T> {
            private final class_6862<T> tagKey;
            private final List<T> values = new ObjectArrayList<>();

            public TagKeyBuilder(class_6862<T> tagKey) {
                this.tagKey = tagKey;
            }

            public TagKeyBuilder<T> add(T... values) {
                this.values.addAll(Arrays.asList(values));
                return this;
            }
        }

    }
}
