package cc.thonly.registry_modifier.mixin;

import cc.thonly.registry_modifier.api.DynamicRegistryManagerCallback;
import com.mojang.serialization.Lifecycle;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2370;
import net.minecraft.class_2385;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;

@Slf4j
@Mixin(class_7655.class_7657.class)
public class RegistryLoaderEntryMixin {
    @Inject(method = "getLoader", at = @At("RETURN"), cancellable = true)
    private static<T> void getLoader(Lifecycle lifecycle, Map<class_5321<?>, Exception> errors, CallbackInfoReturnable<class_7655.class_9158<T>> cir) {
        class_7655.class_9158<T> loader = cir.getReturnValue();
        class_2385<T> mutableRegistry = loader.comp_2246();
        if (mutableRegistry instanceof class_2370<T> registry) {
            DynamicRegistryManagerCallback.start(registry);
        }
//        System.out.println(mutableRegistry.getKey());
    }
}
