/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.registry_modifier.api;

import cc.thonly.registry_modifier.mixin.NamedAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9248;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DynamicRegistryManagerCallback {
    public static final List<Builder<?>> CALLBACKS = new ArrayList();

    public static <T> void add(Builder<T> builder) {
        CALLBACKS.add(builder);
    }

    public static void start(class_2370<?> registry) {
        for (Builder<?> factory : CALLBACKS) {
            if (!factory.registryKey.equals(registry.method_46765())) continue;
            factory.start(registry);
        }
    }

    public static <T> Builder<T> createBuilder(class_5321<? extends class_2378<T>> registryKey) {
        return new Builder(registryKey);
    }

    public static class Builder<T> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private final class_5321<? extends class_2378<T>> registryKey;
        private final Map<class_2960, T> registries = new Object2ObjectLinkedOpenHashMap();
        private final Map<class_2960, class_6880<T>> entries = new Object2ObjectLinkedOpenHashMap();
        private final Map<class_2960, class_9248> infos = new Object2ObjectLinkedOpenHashMap();
        private final List<Info<T>> registryInfos = new ObjectArrayList();
        private final List<TagKeyBuilder<T>> tagKeyBuilders = new ObjectArrayList();

        protected Builder(class_5321<? extends class_2378<T>> registryKey) {
            assert (registryKey != null);
            this.registryKey = registryKey;
        }

        public T register(class_2960 key, T value) {
            return this.register(key, value, class_9248.field_49136);
        }

        public T register(class_2960 key, T value, class_9248 info) {
            return this.register(key, class_6880.method_40223(value), info);
        }

        public T register(class_2960 key, class_6880<T> value) {
            return this.register(key, value, class_9248.field_49136);
        }

        public T register(class_2960 key, class_6880<T> registryEntry, class_9248 info) {
            class_5321 registryKey = class_5321.method_29179(this.registryKey, (class_2960)key);
            Object value = registryEntry.comp_349();
            this.registries.put(key, value);
            this.entries.put(key, registryEntry);
            this.infos.put(key, info);
            if (registryEntry instanceof class_6880.class_6883) {
                class_6880.class_6883 reference = (class_6880.class_6883)registryEntry;
                reference.method_45917(registryKey);
            }
            this.registryInfos.add(new Info<Object>(registryKey, value, registryEntry, info));
            return (T)value;
        }

        public void addTagBuilder(TagKeyBuilder<T> ... tagKeyBuilder) {
            this.tagKeyBuilders.addAll(Arrays.asList(tagKeyBuilder));
        }

        public synchronized void start(class_2370<?> sr) {
            class_2370<?> registry = sr;
            this.build(registry);
            this.buildTags(registry);
        }

        protected synchronized void build(class_2370<T> registry) {
            for (Info<T> registryInfo : this.registryInfos) {
                try {
                    class_5321<T> key = registryInfo.getKey();
                    T value = registryInfo.getValue();
                    if (registry.method_35842(key) || registry.method_10250(key.method_29177()) || registry.field_11107.containsKey(key.method_29177()) || registry.field_36461.containsKey(value)) continue;
                    registry.method_10272(key, value, class_9248.field_49136);
                }
                catch (Exception err) {
                    log.error("Can't add registry {}", registryInfo.getKey());
                }
            }
        }

        protected void buildTags(class_2370<T> registry) {
            for (TagKeyBuilder<T> tagKeyBuilder : this.tagKeyBuilders) {
                class_6885.class_6888 named = registry.field_53686.computeIfAbsent(tagKeyBuilder.tagKey, x -> NamedAccessor.callNew(registry, tagKeyBuilder.tagKey));
                for (Object value : tagKeyBuilder.values) {
                    class_6880 entry = registry.method_47983(value);
                    if (named.field_36460 != null) {
                        named.field_36460.add(entry);
                        continue;
                    }
                    named.field_36460 = new ArrayList();
                }
            }
        }

        public static <T> Builder<T> create(class_5321<? extends class_2378<T>> registryKey) {
            return new Builder<T>(registryKey);
        }

        @Generated
        public class_5321<? extends class_2378<T>> getRegistryKey() {
            return this.registryKey;
        }

        @Generated
        public Map<class_2960, T> getRegistries() {
            return this.registries;
        }

        @Generated
        public Map<class_2960, class_6880<T>> getEntries() {
            return this.entries;
        }

        @Generated
        public Map<class_2960, class_9248> getInfos() {
            return this.infos;
        }

        @Generated
        public List<Info<T>> getRegistryInfos() {
            return this.registryInfos;
        }

        @Generated
        public List<TagKeyBuilder<T>> getTagKeyBuilders() {
            return this.tagKeyBuilders;
        }

        public static class Info<T> {
            class_5321<T> key;
            T value;
            class_6880<T> registryEntry;
            class_9248 info;

            @Generated
            public class_5321<T> getKey() {
                return this.key;
            }

            @Generated
            public T getValue() {
                return this.value;
            }

            @Generated
            public class_6880<T> getRegistryEntry() {
                return this.registryEntry;
            }

            @Generated
            public class_9248 getInfo() {
                return this.info;
            }

            @Generated
            public Info(class_5321<T> key, T value, class_6880<T> registryEntry, class_9248 info) {
                this.key = key;
                this.value = value;
                this.registryEntry = registryEntry;
                this.info = info;
            }
        }

        public static class TagKeyBuilder<T> {
            private final class_6862<T> tagKey;
            private final List<T> values = new ObjectArrayList();

            public TagKeyBuilder(class_6862<T> tagKey) {
                this.tagKey = tagKey;
            }

            public TagKeyBuilder<T> add(T ... values) {
                this.values.addAll(Arrays.asList(values));
                return this;
            }

            @Generated
            public class_6862<T> getTagKey() {
                return this.tagKey;
            }

            @Generated
            public List<T> getValues() {
                return this.values;
            }
        }
    }
}

