package cc.thonly.registry_modifier.mixin;

import cc.thonly.registry_modifier.DynamicRegistriesModifier;
import cc.thonly.registry_modifier.api.DynamicRegistryManagerCallback;
import cc.thonly.registry_modifier.util.LoadingPhase;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_2370;
import net.minecraft.class_2385;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.registry.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Mixin(class_7655.class)
public class RegistryLoaderMixin {
    @Unique
    private static final ThreadLocal<Boolean> IS_SERVER = ThreadLocal.withInitial(() -> false);

    @Inject(
            method = "loadFromResource(Lnet/minecraft/resource/ResourceManager;Ljava/util/List;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;",
            at = @At("HEAD"),
            cancellable = true
    )
    private static void loadFromResource(class_3300 resourceManager, List<class_7225.class_7226<?>> registries, List<class_7655.class_7657<?>> entries, CallbackInfoReturnable<class_5455.class_6890> cir) {
        if (entries.equals(class_7655.field_39968)) {
            DynamicRegistriesModifier.LOADING_PHASE.set(LoadingPhase.DYNAMIC_REGISTRIES);
        }
        if (entries.equals(class_7655.field_39969)) {
            DynamicRegistriesModifier.LOADING_PHASE.set(LoadingPhase.DIMENSION_REGISTRIES);
        }
    }

    @WrapOperation(method = "loadFromResource(Lnet/minecraft/resource/ResourceManager;Ljava/util/List;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/registry/RegistryLoader;load(Lnet/minecraft/registry/RegistryLoader$RegistryLoadable;Ljava/util/List;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;"))
    private static class_5455.class_6890 wrapIsServerCall(@Coerce Object registryLoadable, List<class_7225.class_7226<?>> baseRegistries, List<class_7655.class_7657<?>> entries, Operation<class_5455.class_6890> original) {
        try {
            IS_SERVER.set(true);
            return original.call(registryLoadable, baseRegistries, entries);
        } finally {
            IS_SERVER.set(false);
        }
    }

    @Inject(
            method = {"load(Lnet/minecraft/registry/RegistryLoader$RegistryLoadable;Ljava/util/List;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;"},
            at = {@At(
                    value = "INVOKE",
                    target = "Ljava/util/List;forEach(Ljava/util/function/Consumer;)V",
                    ordinal = 1
            )}
    )
    private static void load(@Coerce Object registryLoadable, List<class_7225.class_7226<?>> baseRegistries, List<class_7655.class_7657<?>> entries, CallbackInfoReturnable<class_5455.class_6890> cir, @Local(ordinal = 2) List<class_7655.class_9158<?>> registriesList) {
        if (IS_SERVER.get()) {
//            System.out.println("加载周期: " + DynamicRegistriesModifier.LOADING_PHASE.get().toString());
            Iterator<class_7655.class_9158<?>> iterator = registriesList.iterator();
            while (iterator.hasNext()) {
                class_7655.class_9158<?> next = iterator.next();
                class_2385<?> mutableRegistry = next.comp_2246();
//                if (DynamicRegistriesModifier.LOADING_PHASE.get() == LoadingPhase.NONE) {
//                    continue;
//                }

                class_2370<?> registry = (class_2370<?>) mutableRegistry;

//                System.out.println("注册表ref键: " + registry.getKey());
//                for (Map.Entry<? extends RegistryKey<?>, ?> entry : mutableRegistry.getEntrySet()) {
//                    System.out.println(entry.getKey() + "-" + entry.getValue());
//                }
                DynamicRegistryManagerCallback.Table.load(registriesList);
//                if (registry.getKey().equals(RegistryKeys.DIMENSION) && DynamicRegistriesModifier.LOADING_PHASE.get() != LoadingPhase.DIMENSION_REGISTRIES) {
//                    continue;
//                }
                DynamicRegistryManagerCallback.start(registry);

            }
        }
    }
}
