package cc.thonly.registry_modifier.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2370;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9248;

@Mixin(class_2370.class)
public abstract class SimpleRegistryMixin<T> implements class_2385<T> {
    @Shadow @Final public Map<class_2960, class_6880.class_6883<T>> idToEntry;

    @Shadow @Final public Map<T, class_6880.class_6883<T>> valueToEntry;

    @Inject(method = "add", at = @At("HEAD"), cancellable = true)
    public void add(class_5321<T> key, T value, class_9248 info, CallbackInfoReturnable<class_6880.class_6883<T>> cir) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (this.idToEntry.containsKey(key.method_29177())) {
            cir.setReturnValue(this.idToEntry.get(key.method_29177()));
            cir.cancel();
        }
        if (this.valueToEntry.containsKey(value)) {
            cir.setReturnValue(this.idToEntry.get(key.method_29177()));
            cir.cancel();
        }
    }
}
