/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.registry_modifier.api;

import cc.thonly.registry_modifier.mixin.NamedAccessor;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7655;
import net.minecraft.class_7871;
import net.minecraft.class_7876;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_9248;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DynamicRegistryManagerCallback {
    public static final Map<class_5321<? extends class_2378<?>>, Builder<?>> KEY2BUILDER = new Object2ObjectOpenHashMap();

    public static void start(class_2370<?> registry) {
        for (Builder<?> factory : KEY2BUILDER.values()) {
            if (!factory.registryKey.equals(registry.method_46765())) continue;
            factory.startBuild(registry);
        }
    }

    public static <T> Builder<T> createBuilder(class_5321<? extends class_2378<T>> registryKey) {
        return KEY2BUILDER.computeIfAbsent(registryKey, key -> new Builder(registryKey));
    }

    public static class Builder<T> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private final class_5321<? extends class_2378<T>> registryKey;
        private final DeferredRegister<T> deferRegistry;
        private DeferredRegister<T> initializerRegistry;
        private final List<RegistrableInitializer<T>> initializers = new ArrayList<RegistrableInitializer<T>>();

        protected Builder(class_5321<? extends class_2378<T>> registryKey) {
            assert (registryKey != null);
            this.registryKey = registryKey;
            this.deferRegistry = new DeferredRegister(registryKey, Lifecycle.stable());
            this.initializerRegistry = new DeferredRegister(registryKey, Lifecycle.stable());
        }

        public T register(class_2960 key, T value) {
            return this.register(key, value, class_9248.field_49136);
        }

        public T register(class_2960 key, T value, class_9248 info) {
            return this.register(key, class_6880.method_40223(value), info);
        }

        public T register(class_5321<T> key, T value) {
            return this.register(key, value, class_9248.field_49136);
        }

        public T register(class_5321<T> key, T value, class_9248 info) {
            return this.register(key.method_29177(), class_6880.method_40223(value), info);
        }

        public T register(class_2960 key, class_6880<T> value) {
            return this.register(key, value, class_9248.field_49136);
        }

        public T register(class_2960 key, class_6880<T> registryEntry, class_9248 info) {
            class_5321 registryKey = class_5321.method_29179(this.registryKey, (class_2960)key);
            Object value = registryEntry.comp_349();
            this.deferRegistry.method_10272(registryKey, value, info);
            return (T)value;
        }

        public void put(RegistrableInitializer<T> initializer) {
            this.initializers.add(initializer);
        }

        public void putTag(class_6862<T> tagKey, Consumer<List<T>> collector) {
            ArrayList temp = new ArrayList();
            collector.accept(temp);
            class_6885.class_6888 registryEntries = this.deferRegistry.field_53686.computeIfAbsent(tagKey, key -> NamedAccessor.callNew(this.deferRegistry, tagKey));
            if (registryEntries.field_36460 == null) {
                registryEntries.field_36460 = new ArrayList();
            }
            for (Object value : temp) {
                class_6880 entry = this.deferRegistry.method_47983(value);
                if (registryEntries.field_36460.contains(entry)) continue;
                registryEntries.field_36460.add(entry);
            }
        }

        public synchronized void startBuild(class_2370<?> targetRegistry) {
            class_2370<?> target = targetRegistry;
            this.build(this.deferRegistry, target);
            this.initializerRegistry = new DeferredRegister(this.registryKey, Lifecycle.stable());
            for (RegistrableInitializer<T> initializer : this.initializers) {
                initializer.bootstrap(new class_7891<T>(){

                    public class_6880.class_6883<T> method_46800(class_5321<T> key, T value, Lifecycle lifecycle) {
                        return initializerRegistry.method_10272(key, value, class_9248.field_49136);
                    }

                    public <S> class_7871<S> method_46799(class_5321<? extends class_2378<? extends S>> registryRef) {
                        return new class_7871<S>(this){
                            final EntryWrapper entryWrapper = EntryWrapper.create();

                            public Optional<class_6880.class_6883<S>> method_46746(class_5321<S> key) {
                                Map<class_5321<class_2378<?>>, class_2385<?>> wrapper = this.entryWrapper.getWrapper();
                                class_2385<?> mutableRegistry = wrapper.get(key.method_58273());
                                if (mutableRegistry == null) {
                                    return Optional.empty();
                                }
                                return mutableRegistry.method_46746(key);
                            }

                            public Optional<class_6885.class_6888<S>> method_46733(class_6862<S> tag) {
                                Map<class_5321<class_2378<?>>, class_2385<?>> wrapper = this.entryWrapper.getWrapper();
                                class_2385<?> mutableRegistry = wrapper.get(tag.comp_326());
                                if (mutableRegistry == null) {
                                    return Optional.empty();
                                }
                                return mutableRegistry.method_46733(tag);
                            }
                        };
                    }
                });
            }
            this.build(this.initializerRegistry, target);
            this.buildTags(this.deferRegistry, target);
        }

        protected synchronized void build(class_2370<T> source, class_2370<T> target) {
            for (Map.Entry entry : source.field_11107.entrySet()) {
                class_2960 key = (class_2960)entry.getKey();
                class_5321 registryKey = class_5321.method_29179((class_5321)source.method_46765(), (class_2960)key);
                Object value = ((class_6880.class_6883)entry.getValue()).comp_349();
                try {
                    if (target.method_35842(registryKey) || target.method_10250(key) || target.field_11107.containsKey(key) || target.field_36461.containsKey(value)) continue;
                    target.method_10272(registryKey, value, class_9248.field_49136);
                }
                catch (Exception err) {
                    log.error("Can't add value for registry {}", (Object)registryKey);
                }
            }
        }

        protected void buildTags(class_2370<T> sources, class_2370<T> target) {
            for (Map.Entry mapEntry : sources.field_53686.entrySet()) {
                class_6862 key = (class_6862)mapEntry.getKey();
                class_6885.class_6888 value = (class_6885.class_6888)mapEntry.getValue();
                class_6885.class_6888 named = target.field_53686.computeIfAbsent(key, x -> NamedAccessor.callNew(target, key));
                if (named.field_36460 == null) {
                    named.field_36460 = new ArrayList();
                }
                if (this.isImmutableList(named.field_36460)) {
                    named.field_36460 = new ArrayList(named.field_36460);
                }
                if (value.field_36460 == null) continue;
                named.field_36460.addAll(value.field_36460);
            }
        }

        private boolean isImmutableList(List<?> list) {
            if (list instanceof ImmutableList) {
                return true;
            }
            try {
                list.add(null);
                list.remove(null);
                return false;
            }
            catch (UnsupportedOperationException e) {
                return true;
            }
        }

        @Generated
        public class_5321<? extends class_2378<T>> getRegistryKey() {
            return this.registryKey;
        }

        @Generated
        public DeferredRegister<T> getDeferRegistry() {
            return this.deferRegistry;
        }

        @Generated
        public DeferredRegister<T> getInitializerRegistry() {
            return this.initializerRegistry;
        }

        @Generated
        public List<RegistrableInitializer<T>> getInitializers() {
            return this.initializers;
        }

        public static interface RegistrableInitializer<T> {
            public void bootstrap(class_7891<T> var1);
        }
    }

    public static class DeferredRegister<T>
    extends class_2370<T> {
        public DeferredRegister(class_5321 key, Lifecycle lifecycle) {
            super(key, lifecycle);
        }

        public DeferredRegister(class_5321 key, Lifecycle lifecycle, boolean intrusive) {
            super(key, lifecycle, intrusive);
        }
    }

    public static class EntryWrapper {
        final Map<class_5321<? extends class_2378<?>>, class_2385<?>> wrapper = this.createWrapper();

        EntryWrapper() {
        }

        public static EntryWrapper create() {
            return new EntryWrapper();
        }

        Map<class_5321<? extends class_2378<?>>, class_2385<?>> createWrapper() {
            Object2ObjectOpenHashMap wrapper = new Object2ObjectOpenHashMap();
            ObjectOpenHashSet keys = new ObjectOpenHashSet();
            keys.addAll(class_7923.field_41170.method_42021());
            keys.addAll(Table.CACHED2IMPL.keySet());
            keys.addAll(KEY2BUILDER.keySet());
            for (class_5321 key : keys) {
                DeferredRegister deferredRegister = new DeferredRegister(key, Lifecycle.stable());
                this.puts((class_2385)class_7923.field_41170.method_29107(key), deferredRegister);
                this.puts(Table.CACHED2IMPL.get(key), deferredRegister);
                if (KEY2BUILDER.containsKey(key)) {
                    this.puts((class_2385<?>)KEY2BUILDER.get(key).getDeferRegistry(), deferredRegister);
                    this.puts((class_2385<?>)KEY2BUILDER.get(key).getInitializerRegistry(), deferredRegister);
                }
                wrapper.put(key, deferredRegister);
            }
            return wrapper;
        }

        void puts(class_2385<?> source, class_2370 target) {
            if (source == null) {
                return;
            }
            for (Map.Entry entry : source.method_29722()) {
                class_5321 key = (class_5321)entry.getKey();
                Object value = entry.getValue();
                if (target.method_29107(key) == null) continue;
                target.method_10272(key, value, class_9248.field_49136);
            }
            if (source instanceof class_2370) {
                class_2370 ss = (class_2370)source;
                Set set = ss.field_53686.entrySet();
                for (Map.Entry mapEntry : set) {
                    class_6885.class_6888 named = (class_6885.class_6888)mapEntry.getValue();
                    class_7876 owner = named.field_40936;
                    class_6862 tagKey = named.field_36459;
                    List entries = named.field_36460;
                    if (owner == null || tagKey == null || entries == null) continue;
                    Map tags = target.field_53686;
                    if (!tags.containsKey(tagKey)) {
                        tags.put(tagKey, NamedAccessor.callNew(owner, tagKey));
                    }
                    class_6885.class_6888 namedList = (class_6885.class_6888)tags.get(tagKey);
                    if (namedList.field_36460 == null) {
                        namedList.field_36460 = new ArrayList();
                    }
                    namedList.field_36460.addAll(entries);
                }
            }
        }

        @Generated
        public Map<class_5321<? extends class_2378<?>>, class_2385<?>> getWrapper() {
            return this.wrapper;
        }
    }

    public static class Table {
        public static final Map<class_5321<? extends class_2378<?>>, class_2385<?>> CACHED2IMPL = new Object2ObjectLinkedOpenHashMap();

        public static void load(List<class_7655.class_9158<?>> registriesList) {
            for (class_7655.class_9158<?> loader : registriesList) {
                class_2385 mutableRegistry = loader.comp_2246();
                CACHED2IMPL.put(mutableRegistry.method_46765(), mutableRegistry);
            }
        }
    }
}

