/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.capture;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.IntConfigEntry;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.client.event.audio.capture.ClientActivationRegisteredEvent;
import su.plo.voice.api.client.event.audio.capture.ClientActivationUnregisteredEvent;
import su.plo.voice.client.audio.capture.VoiceClientActivation;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.capture.ConfigClientActivation;
import su.plo.voice.client.render.voice.VoiceIconUtil;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerActivationDistancesPacket;

public final class VoiceClientActivationManager
implements ClientActivationManager {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private ClientActivation parentActivation;
    private final List<ClientActivation> activations = new CopyOnWriteArrayList<ClientActivation>(){

        @Override
        public boolean add(ClientActivation activation) {
            int index;
            for (index = 0; index < this.size(); ++index) {
                ClientActivation activationToCompare = (ClientActivation)this.get(index);
                if (activation.getWeight() > activationToCompare.getWeight() || activation.getWeight() == activationToCompare.getWeight() && activation.getName().compareToIgnoreCase(activationToCompare.getName()) == -1) break;
            }
            super.add(index, activation);
            return true;
        }
    };
    private final Map<UUID, ClientActivation> activationById = Maps.newConcurrentMap();
    private boolean initialized = false;

    @Override
    public Optional<ClientActivation> getParentActivation() {
        return Optional.ofNullable(this.parentActivation);
    }

    @Override
    @NotNull
    public ClientActivation register(@NotNull ClientActivation activation) {
        this.unregister(activation.getId());
        this.activations.add(activation);
        this.activationById.put(activation.getId(), activation);
        if (activation.getId().equals(VoiceActivation.PROXIMITY_ID)) {
            ConfigClientActivation activationConfig = this.config.getActivations().getActivation(activation.getId(), activation);
            if (activationConfig.getConfigType().value() == ClientActivation.Type.INHERIT) {
                BaseVoice.LOGGER.warn("Proximity activation type cannot be INHERIT. Changed to PUSH_TO_TALK", new Object[0]);
                activationConfig.getConfigType().set(ClientActivation.Type.PUSH_TO_TALK);
            }
            this.parentActivation = activation;
            if (!this.initialized && ((Boolean)this.config.getAdvanced().getVisualizeVoiceDistance().value()).booleanValue() && ((Boolean)this.config.getAdvanced().getVisualizeVoiceDistanceOnJoin().value()).booleanValue()) {
                this.voiceClient.getDistanceVisualizer().render(activation.getDistance(), 40960, null);
            }
        }
        this.voiceClient.getEventBus().fire(new ClientActivationRegisteredEvent(activation));
        return activation;
    }

    @Override
    @NotNull
    public Collection<ClientActivation> register(@NotNull Collection<Activation> activations) {
        VoiceClientConfig.Server serverConfig = this.getServerConfig();
        for (Activation serverActivation : activations) {
            ConfigClientActivation activationConfig = this.config.getActivations().getActivation(serverActivation.getId(), serverActivation);
            IntConfigEntry activationDistance = serverConfig.getActivationDistance(serverActivation.getId(), serverActivation);
            activationDistance.setDefault(serverActivation.getDefaultDistance(), serverActivation.getMinDistance(), serverActivation.getMaxDistance());
            activationDistance.set(serverActivation.calculateAllowedDistance((Integer)activationDistance.value()));
            String icon = VoiceIconUtil.INSTANCE.getIcon(serverActivation.getIcon(), class_2960.method_12829((String)("plasmovoice:textures/addons/activations/" + serverActivation.getName())));
            final ClientActivation activation = this.register(new VoiceClientActivation(this.voiceClient, this.config, activationConfig, activationDistance, serverActivation, icon));
            this.voiceClient.getServerConnection().ifPresent(connection -> connection.sendPacket(new PlayerActivationDistancesPacket((Map<UUID, Integer>)new HashMap<UUID, Integer>(){
                {
                    this.put(activation.getId(), activation.getDistance());
                }
            })));
        }
        if (this.parentActivation == null) {
            this.parentActivation = this.createParentActivation(serverConfig);
        }
        this.initialized = true;
        return this.getActivations();
    }

    @Override
    public Optional<ClientActivation> getActivationById(@NotNull UUID id) {
        return Optional.ofNullable(this.activationById.get(id));
    }

    @Override
    public Optional<ClientActivation> getActivationByName(@NotNull String name) {
        return this.getActivationById(VoiceActivation.generateId(name));
    }

    @Override
    public Collection<ClientActivation> getActivations() {
        return this.activations;
    }

    @Override
    public boolean unregister(@NotNull UUID id) {
        ClientActivation activation = this.activationById.remove(id);
        if (activation != null) {
            activation.cleanup();
            if (id.equals(VoiceActivation.PROXIMITY_ID)) {
                this.parentActivation = this.createParentActivation(this.getServerConfig());
            }
            boolean removed = this.activations.remove(activation);
            this.voiceClient.getEventBus().fire(new ClientActivationUnregisteredEvent(activation));
            return removed;
        }
        return false;
    }

    @Override
    public boolean unregister(@NotNull String name) {
        return this.unregister(VoiceActivation.generateId(name));
    }

    @Override
    public boolean unregister(@NotNull ClientActivation activation) {
        return this.unregister(activation.getId());
    }

    @Override
    public void clear() {
        this.activations.forEach(ClientActivation::cleanup);
        this.activations.clear();
        this.activationById.clear();
        this.initialized = false;
    }

    private VoiceClientConfig.Server getServerConfig() {
        return this.config.getServers().getById(this.voiceClient.getServerInfo().map(ServerInfo::getServerId).orElseThrow(() -> new IllegalStateException("Not connected"))).orElseThrow(() -> new IllegalStateException("Server config is empty"));
    }

    private VoiceClientActivation createParentActivation(@NotNull VoiceClientConfig.Server serverConfig) {
        VoiceActivation serverActivation = new VoiceActivation("proximity", "pv.activation.parent", "", Collections.emptyList(), 0, false, false, true, null, 1);
        ConfigClientActivation activationConfig = this.config.getActivations().getActivation(serverActivation.getId(), serverActivation);
        IntConfigEntry activationDistance = serverConfig.getActivationDistance(serverActivation.getId(), serverActivation);
        activationDistance.setDefault(0, 0, 0);
        activationDistance.set(serverActivation.calculateAllowedDistance((Integer)activationDistance.value()));
        if (activationConfig.getConfigType().value() == ClientActivation.Type.INHERIT) {
            BaseVoice.LOGGER.warn("Proximity activation type cannot be INHERIT. Changed to PUSH_TO_TALK", new Object[0]);
            activationConfig.getConfigType().set(ClientActivation.Type.PUSH_TO_TALK);
        }
        return new VoiceClientActivation(this.voiceClient, this.config, activationConfig, activationDistance, serverActivation, "");
    }

    public VoiceClientActivationManager(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }
}

