/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.client.audio.source.JitterBuffer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsu/plo/voice/client/audio/source/StaticJitterBuffer;", "Lsu/plo/voice/client/audio/source/JitterBuffer;", "packetDelay", "", "<init>", "(I)V", "queue", "Ljava/util/Queue;", "Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "endPacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "offer", "", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "poll", "isEmpty", "", "plasmovoice-fabric-1.20.1"})
public final class StaticJitterBuffer
implements JitterBuffer {
    private final int packetDelay;
    @NotNull
    private final Queue<JitterBuffer.PacketWithSequenceNumber> queue;
    @Nullable
    private SourceAudioEndPacket endPacket;

    public StaticJitterBuffer(int packetDelay) {
        this.packetDelay = packetDelay;
        this.queue = this.packetDelay <= 1 ? (Queue)new LinkedBlockingQueue() : (Queue)new PriorityBlockingQueue(this.packetDelay * 2, new Comparator(){

            public final int compare(T a, T b) {
                JitterBuffer.PacketWithSequenceNumber it = (JitterBuffer.PacketWithSequenceNumber)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSequenceNumber());
                it = (JitterBuffer.PacketWithSequenceNumber)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getSequenceNumber());
            }
        });
    }

    @Override
    public void offer(@NotNull SourceAudioPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (this.endPacket != null) {
            long l = packet.getSequenceNumber();
            SourceAudioEndPacket sourceAudioEndPacket = this.endPacket;
            Intrinsics.checkNotNull(sourceAudioEndPacket);
            if (l > sourceAudioEndPacket.getSequenceNumber()) {
                this.endPacket = null;
            }
        }
        this.queue.offer(new JitterBuffer.SourceAudioPacketWrapper(packet));
    }

    @Override
    public void offer(@NotNull SourceAudioEndPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.endPacket = packet;
        this.queue.offer(new JitterBuffer.SourceAudioEndPacketWrapper(packet));
    }

    @Override
    @Nullable
    public JitterBuffer.PacketWithSequenceNumber poll() {
        if (this.endPacket != null || this.queue.size() >= this.packetDelay) {
            return this.queue.poll();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

