/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.api.client.audio.source.ClientSourceManager;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.client.event.audio.source.AudioSourceClosedEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.source.ClientDirectSource;
import su.plo.voice.client.audio.source.ClientEntitySource;
import su.plo.voice.client.audio.source.ClientLoopbackSource;
import su.plo.voice.client.audio.source.ClientPlayerSource;
import su.plo.voice.client.audio.source.ClientStaticSource;
import su.plo.voice.client.audio.source.VoiceClientSelfSourceInfo;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.ResultKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.coroutines.Continuation;
import su.plo.voice.libs.kotlin.coroutines.intrinsics.IntrinsicsKt;
import su.plo.voice.libs.kotlin.coroutines.jvm.internal.Boxing;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.functions.Function2;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlinx.coroutines.BuildersKt;
import su.plo.voice.libs.kotlinx.coroutines.CoroutineScope;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.data.audio.source.EntitySourceInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SelfSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.packets.tcp.serverbound.SourceInfoRequestPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 =2\u00020\u0001:\u0001=B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u001a\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0!2\u0006\u0010\"\u001a\u00020\nH\u0016J\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0!2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u001c\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000b0!2\u0006\u0010&\u001a\u00020\nH\u0016J\u001a\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0012\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0!H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020)0!H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u0013H\u0016J\u0018\u0010/\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u00100\u001a\u00020\u001bH\u0016J\u0010\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020,2\u0006\u00105\u001a\u000206H\u0007J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010.\u001a\u00020\rH\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010.\u001a\u00020\u0010H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u000b2\u0006\u0010.\u001a\u00020:H\u0002J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u000b2\u0006\u0010.\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lsu/plo/voice/client/audio/source/VoiceClientSourceManager;", "Lsu/plo/voice/api/client/audio/source/ClientSourceManager;", "voiceClient", "Lsu/plo/voice/client/BaseVoiceClient;", "config", "Lsu/plo/voice/client/config/VoiceClientConfig;", "<init>", "(Lsu/plo/voice/client/BaseVoiceClient;Lsu/plo/voice/client/config/VoiceClientConfig;)V", "sourcesByLineId", "Lcom/google/common/collect/ListMultimap;", "Ljava/util/UUID;", "Lsu/plo/voice/api/client/audio/source/ClientAudioSource;", "sourcesByPlayerId", "Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "sourcesByEntityId", "", "Lsu/plo/voice/proto/data/audio/source/EntitySourceInfo;", "sourceById", "", "Lsu/plo/voice/proto/data/audio/source/SourceInfo;", "sourceRequestById", "", "selfSourceInfoById", "Lsu/plo/voice/client/audio/source/VoiceClientSelfSourceInfo;", "createLoopbackSource", "Lsu/plo/voice/client/audio/source/ClientLoopbackSource;", "relative", "", "getSourceById", "Ljava/util/Optional;", "sourceId", "request", "getSourcesByLineId", "", "lineId", "getEntitySources", "entityId", "getPlayerSources", "playerId", "getSources", "getSelfSourceInfo", "Lsu/plo/voice/api/client/audio/source/ClientSelfSourceInfo;", "getAllSelfSourceInfos", "clear", "", "createOrUpdateSource", "sourceInfo", "sendSourceInfoRequest", "requestIfExist", "updateSelfSourceInfo", "selfSourceInfo", "Lsu/plo/voice/proto/data/audio/source/SelfSourceInfo;", "onAudioSourceClosed", "event", "Lsu/plo/voice/api/client/event/audio/source/AudioSourceClosedEvent;", "createPlayerSource", "createEntitySource", "createDirectSource", "Lsu/plo/voice/proto/data/audio/source/DirectSourceInfo;", "createStaticSource", "Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;", "Companion", "plasmovoice-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nVoiceClientSourceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceClientSourceManager.kt\nsu/plo/voice/client/audio/source/VoiceClientSourceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1#2:229\n1863#3,2:230\n*S KotlinDebug\n*F\n+ 1 VoiceClientSourceManager.kt\nsu/plo/voice/client/audio/source/VoiceClientSourceManager\n*L\n91#1:230,2\n*E\n"})
public final class VoiceClientSourceManager
implements ClientSourceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseVoiceClient voiceClient;
    @NotNull
    private final VoiceClientConfig config;
    @NotNull
    private final ListMultimap<UUID, ClientAudioSource<?>> sourcesByLineId;
    @NotNull
    private final ListMultimap<UUID, ClientAudioSource<PlayerSourceInfo>> sourcesByPlayerId;
    @NotNull
    private final ListMultimap<Integer, ClientAudioSource<EntitySourceInfo>> sourcesByEntityId;
    @NotNull
    private final Map<UUID, ClientAudioSource<? extends SourceInfo>> sourceById;
    @NotNull
    private final Map<UUID, Long> sourceRequestById;
    @NotNull
    private final Map<UUID, VoiceClientSelfSourceInfo> selfSourceInfoById;
    private static final long TIMEOUT_MS = 25000L;

    public VoiceClientSourceManager(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(config, "config");
        this.voiceClient = voiceClient;
        this.config = config;
        ListMultimap listMultimap = Multimaps.newListMultimap((Map)Maps.newConcurrentMap(), CopyOnWriteArrayList::new);
        Intrinsics.checkNotNullExpressionValue(listMultimap, "newListMultimap(...)");
        this.sourcesByLineId = listMultimap;
        ListMultimap listMultimap2 = Multimaps.newListMultimap((Map)Maps.newConcurrentMap(), CopyOnWriteArrayList::new);
        Intrinsics.checkNotNullExpressionValue(listMultimap2, "newListMultimap(...)");
        this.sourcesByPlayerId = listMultimap2;
        ListMultimap listMultimap3 = Multimaps.newListMultimap((Map)Maps.newConcurrentMap(), CopyOnWriteArrayList::new);
        Intrinsics.checkNotNullExpressionValue(listMultimap3, "newListMultimap(...)");
        this.sourcesByEntityId = listMultimap3;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.sourceById = concurrentMap;
        ConcurrentMap concurrentMap2 = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap2, "newConcurrentMap(...)");
        this.sourceRequestById = concurrentMap2;
        ConcurrentMap concurrentMap3 = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap3, "newConcurrentMap(...)");
        this.selfSourceInfoById = concurrentMap3;
    }

    @Override
    @NotNull
    public ClientLoopbackSource createLoopbackSource(boolean relative) {
        return new ClientLoopbackSource(this.voiceClient, this.config, relative);
    }

    @Override
    @NotNull
    public Optional<ClientAudioSource<?>> getSourceById(@NotNull UUID sourceId, boolean request) {
        ClientAudioSource<? extends SourceInfo> source2;
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        if (!this.voiceClient.getServerConnection().isPresent()) {
            boolean $i$a$-check-VoiceClientSourceManager$getSourceById$22 = false;
            String $i$a$-check-VoiceClientSourceManager$getSourceById$22 = "Not connected";
            throw new IllegalStateException($i$a$-check-VoiceClientSourceManager$getSourceById$22.toString());
        }
        ClientAudioSource<? extends SourceInfo> clientAudioSource = source2 = this.sourceById.get(sourceId);
        if (clientAudioSource != null) {
            Optional<ClientAudioSource<?>> optional = Optional.of(clientAudioSource);
            Intrinsics.checkNotNullExpressionValue(optional, "of(...)");
            return optional;
        }
        if (!request) {
            Optional<ClientAudioSource<?>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, "empty(...)");
            return optional;
        }
        long lastRequest = ((Number)this.sourceRequestById.getOrDefault(sourceId, 0L)).longValue();
        if (System.currentTimeMillis() - lastRequest > 1000L) {
            this.sendSourceInfoRequest(sourceId);
        }
        Optional<ClientAudioSource<?>> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, "empty(...)");
        return optional;
    }

    @Override
    @NotNull
    public Collection<ClientAudioSource<?>> getSourcesByLineId(@NotNull UUID lineId) {
        Intrinsics.checkNotNullParameter(lineId, "lineId");
        List list = this.sourcesByLineId.get((Object)lineId);
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return list;
    }

    @Override
    @NotNull
    public Collection<ClientAudioSource<EntitySourceInfo>> getEntitySources(int entityId) {
        List list = this.sourcesByEntityId.get((Object)entityId);
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return list;
    }

    @Override
    @NotNull
    public Collection<ClientAudioSource<PlayerSourceInfo>> getPlayerSources(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        List list = this.sourcesByPlayerId.get((Object)playerId);
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return list;
    }

    @Override
    @NotNull
    public Optional<ClientAudioSource<?>> getSourceById(@NotNull UUID sourceId) {
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        return this.getSourceById(sourceId, true);
    }

    @Override
    @NotNull
    public Collection<ClientAudioSource<?>> getSources() {
        return this.sourceById.values();
    }

    @Override
    @NotNull
    public Optional<ClientSelfSourceInfo> getSelfSourceInfo(@NotNull UUID sourceId) {
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        Optional<ClientSelfSourceInfo> optional = Optional.ofNullable(this.selfSourceInfoById.get(sourceId));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @NotNull
    public Collection<ClientSelfSourceInfo> getAllSelfSourceInfos() {
        return this.selfSourceInfoById.values();
    }

    @Override
    public void clear() {
        Iterable $this$forEach$iv = this.sourceById.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientAudioSource it = (ClientAudioSource)element$iv;
            boolean bl = false;
            it.closeAsync().get();
        }
        this.sourcesByLineId.clear();
        this.sourcesByPlayerId.clear();
        this.sourcesByEntityId.clear();
        this.sourceRequestById.clear();
        this.selfSourceInfoById.clear();
    }

    @Override
    public void createOrUpdateSource(@NotNull SourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter(sourceInfo, "sourceInfo");
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sourceInfo, null){
            int label;
            final /* synthetic */ VoiceClientSourceManager this$0;
            final /* synthetic */ SourceInfo $sourceInfo;
            {
                this.this$0 = $receiver;
                this.$sourceInfo = $sourceInfo;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        try {
                            if (VoiceClientSourceManager.access$getSourceById$p(this.this$0).containsKey(this.$sourceInfo.getId())) {
                                V v = VoiceClientSourceManager.access$getSourceById$p(this.this$0).get(this.$sourceInfo.getId());
                                Intrinsics.checkNotNull(v);
                                ClientAudioSource source2 = (ClientAudioSource)v;
                                if (source2.isClosed()) {
                                    VoiceClientSourceManager.access$getSourceRequestById$p(this.this$0).remove(this.$sourceInfo.getId());
                                    return Unit.INSTANCE;
                                }
                                if (((SourceInfo)source2.getSourceInfo()).getLineId() != this.$sourceInfo.getLineId()) {
                                    VoiceClientSourceManager.access$getSourcesByLineId$p(this.this$0).remove((Object)((SourceInfo)source2.getSourceInfo()).getLineId(), (Object)source2);
                                    VoiceClientSourceManager.access$getSourcesByLineId$p(this.this$0).put((Object)this.$sourceInfo.getLineId(), (Object)source2);
                                }
                                source2.updateUnchecked(this.$sourceInfo);
                                return Unit.INSTANCE;
                            }
                            SourceInfo sourceInfo = this.$sourceInfo;
                            if (sourceInfo instanceof PlayerSourceInfo) {
                                ClientAudioSource source3 = VoiceClientSourceManager.access$createPlayerSource(this.this$0, (PlayerSourceInfo)this.$sourceInfo);
                                VoiceClientSourceManager.access$getSourceById$p(this.this$0).put(this.$sourceInfo.getId(), source3);
                                VoiceClientSourceManager.access$getSourcesByLineId$p(this.this$0).put((Object)this.$sourceInfo.getLineId(), (Object)source3);
                                v1 = VoiceClientSourceManager.access$getSourcesByPlayerId$p(this.this$0).put((Object)((PlayerSourceInfo)this.$sourceInfo).getPlayerInfo().getPlayerId(), (Object)source3);
                            } else if (sourceInfo instanceof EntitySourceInfo) {
                                ClientAudioSource source4 = VoiceClientSourceManager.access$createEntitySource(this.this$0, (EntitySourceInfo)this.$sourceInfo);
                                VoiceClientSourceManager.access$getSourceById$p(this.this$0).put(this.$sourceInfo.getId(), source4);
                                VoiceClientSourceManager.access$getSourcesByLineId$p(this.this$0).put((Object)this.$sourceInfo.getLineId(), (Object)source4);
                                v1 = VoiceClientSourceManager.access$getSourcesByEntityId$p(this.this$0).put((Object)Boxing.boxInt(((EntitySourceInfo)this.$sourceInfo).getEntityId()), (Object)source4);
                            } else if (sourceInfo instanceof StaticSourceInfo) {
                                ClientAudioSource source5 = VoiceClientSourceManager.access$createStaticSource(this.this$0, (StaticSourceInfo)this.$sourceInfo);
                                VoiceClientSourceManager.access$getSourceById$p(this.this$0).put(this.$sourceInfo.getId(), source5);
                                v1 = VoiceClientSourceManager.access$getSourcesByLineId$p(this.this$0).put((Object)this.$sourceInfo.getLineId(), (Object)source5);
                            } else if (sourceInfo instanceof DirectSourceInfo) {
                                ClientAudioSource source6 = VoiceClientSourceManager.access$createDirectSource(this.this$0, (DirectSourceInfo)this.$sourceInfo);
                                VoiceClientSourceManager.access$getSourceById$p(this.this$0).put(this.$sourceInfo.getId(), source6);
                                v1 = VoiceClientSourceManager.access$getSourcesByLineId$p(this.this$0).put((Object)this.$sourceInfo.getLineId(), (Object)source6);
                            } else {
                                throw new IllegalArgumentException("Invalid source type");
                            }
                            Long cfr_ignored_0 = (Long)VoiceClientSourceManager.access$getSourceRequestById$p(this.this$0).remove(this.$sourceInfo.getId());
                        }
                        catch (DeviceException e) {
                            throw new IllegalStateException("Failed to initialize audio source", e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    @Override
    public void sendSourceInfoRequest(@NotNull UUID sourceId, boolean requestIfExist) {
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        if (!requestIfExist && this.sourceById.containsKey(sourceId)) {
            return;
        }
        ServerConnection connection = this.voiceClient.getServerConnection().orElseThrow(VoiceClientSourceManager::sendSourceInfoRequest$lambda$2);
        this.sourceRequestById.put(sourceId, System.currentTimeMillis());
        connection.sendPacket(new SourceInfoRequestPacket(sourceId));
    }

    @Override
    public void updateSelfSourceInfo(@NotNull SelfSourceInfo selfSourceInfo) {
        Intrinsics.checkNotNullParameter(selfSourceInfo, "selfSourceInfo");
        this.selfSourceInfoById.computeIfAbsent(selfSourceInfo.getSourceInfo().getId(), arg_0 -> VoiceClientSourceManager.updateSelfSourceInfo$lambda$4(VoiceClientSourceManager::updateSelfSourceInfo$lambda$3, arg_0)).setSelfSourceInfo(selfSourceInfo);
        UUID uUID = selfSourceInfo.getSourceInfo().getId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getId(...)");
        if (this.getSourceById(uUID, false).isPresent()) {
            SourceInfo sourceInfo = selfSourceInfo.getSourceInfo();
            Intrinsics.checkNotNullExpressionValue(sourceInfo, "getSourceInfo(...)");
            this.createOrUpdateSource(sourceInfo);
        }
    }

    @EventSubscribe
    public final void onAudioSourceClosed(@NotNull AudioSourceClosedEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter(event, "event");
            ClientAudioSource<?> source2 = event.getSource();
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, source2);
            this.sourceById.remove(((SourceInfo)source2.getSourceInfo()).getId());
            this.sourcesByLineId.remove((Object)((SourceInfo)source2.getSourceInfo()).getLineId(), source2);
            Object s = source2.getSourceInfo();
            PacketSerializable packetSerializable = s instanceof PlayerSourceInfo ? (PlayerSourceInfo)s : null;
            if (packetSerializable != null && (packetSerializable = ((PlayerSourceInfo)packetSerializable).getPlayerInfo()) != null) {
                PacketSerializable it = packetSerializable;
                boolean bl = false;
                this.sourcesByPlayerId.remove((Object)((VoicePlayerInfo)it).getPlayerId(), source2);
            }
            s = source2.getSourceInfo();
            EntitySourceInfo entitySourceInfo = s instanceof EntitySourceInfo ? (EntitySourceInfo)s : null;
            if (entitySourceInfo == null) break block1;
            int it = entitySourceInfo.getEntityId();
            boolean bl = false;
            this.sourcesByEntityId.remove((Object)it, source2);
        }
    }

    private final ClientAudioSource<PlayerSourceInfo> createPlayerSource(PlayerSourceInfo sourceInfo) {
        ClientPlayerSource clientPlayerSource;
        ClientPlayerSource it = clientPlayerSource = new ClientPlayerSource(this.voiceClient, this.config, sourceInfo);
        boolean bl = false;
        this.voiceClient.getEventBus().register(this.voiceClient, it);
        return clientPlayerSource;
    }

    private final ClientAudioSource<EntitySourceInfo> createEntitySource(EntitySourceInfo sourceInfo) {
        ClientEntitySource clientEntitySource;
        ClientEntitySource it = clientEntitySource = new ClientEntitySource(this.voiceClient, this.config, sourceInfo);
        boolean bl = false;
        this.voiceClient.getEventBus().register(this.voiceClient, it);
        return clientEntitySource;
    }

    private final ClientAudioSource<DirectSourceInfo> createDirectSource(DirectSourceInfo sourceInfo) {
        ClientDirectSource clientDirectSource;
        ClientDirectSource it = clientDirectSource = new ClientDirectSource(this.voiceClient, this.config, sourceInfo);
        boolean bl = false;
        this.voiceClient.getEventBus().register(this.voiceClient, it);
        return clientDirectSource;
    }

    private final ClientAudioSource<StaticSourceInfo> createStaticSource(StaticSourceInfo sourceInfo) {
        ClientStaticSource clientStaticSource;
        ClientStaticSource it = clientStaticSource = new ClientStaticSource(this.voiceClient, this.config, sourceInfo);
        boolean bl = false;
        this.voiceClient.getEventBus().register(this.voiceClient, it);
        return clientStaticSource;
    }

    private static final IllegalStateException sendSourceInfoRequest$lambda$2() {
        return new IllegalStateException("Not connected");
    }

    private static final VoiceClientSelfSourceInfo updateSelfSourceInfo$lambda$3(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new VoiceClientSelfSourceInfo();
    }

    private static final VoiceClientSelfSourceInfo updateSelfSourceInfo$lambda$4(Function1 $tmp0, Object p0) {
        return (VoiceClientSelfSourceInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getSourceById$p(VoiceClientSourceManager $this) {
        return $this.sourceById;
    }

    public static final /* synthetic */ Map access$getSourceRequestById$p(VoiceClientSourceManager $this) {
        return $this.sourceRequestById;
    }

    public static final /* synthetic */ ListMultimap access$getSourcesByLineId$p(VoiceClientSourceManager $this) {
        return $this.sourcesByLineId;
    }

    public static final /* synthetic */ ClientAudioSource access$createPlayerSource(VoiceClientSourceManager $this, PlayerSourceInfo sourceInfo) {
        return $this.createPlayerSource(sourceInfo);
    }

    public static final /* synthetic */ ListMultimap access$getSourcesByPlayerId$p(VoiceClientSourceManager $this) {
        return $this.sourcesByPlayerId;
    }

    public static final /* synthetic */ ClientAudioSource access$createEntitySource(VoiceClientSourceManager $this, EntitySourceInfo sourceInfo) {
        return $this.createEntitySource(sourceInfo);
    }

    public static final /* synthetic */ ListMultimap access$getSourcesByEntityId$p(VoiceClientSourceManager $this) {
        return $this.sourcesByEntityId;
    }

    public static final /* synthetic */ ClientAudioSource access$createStaticSource(VoiceClientSourceManager $this, StaticSourceInfo sourceInfo) {
        return $this.createStaticSource(sourceInfo);
    }

    public static final /* synthetic */ ClientAudioSource access$createDirectSource(VoiceClientSourceManager $this, DirectSourceInfo sourceInfo) {
        return $this.createDirectSource(sourceInfo);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsu/plo/voice/client/audio/source/VoiceClientSourceManager$Companion;", "", "<init>", "()V", "TIMEOUT_MS", "", "plasmovoice-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

