/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.LazyGlState;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.entity.LivingEntityRenderState;
import su.plo.lib.mod.client.render.pipeline.RenderPipeline;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.lib.mod.extensions.PoseStackKt;
import su.plo.slib.api.chat.component.McLiteralText;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.audio.source.ClientStaticSource;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.LivingEntityRenderEvent;
import su.plo.voice.client.event.render.LevelRenderEvent;
import su.plo.voice.client.extension.CameraKt;
import su.plo.voice.client.extension.MathKt;
import su.plo.voice.client.gui.PlayerVolumeAction;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.source.EntitySourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.proto.data.config.PlayerIconVisibility;
import su.plo.voice.proto.data.player.VoicePlayerInfo;

public final class SourceIconRenderer {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final PlayerVolumeAction volumeAction;
    @NotNull
    private final LazyGlState glState = new LazyGlState();

    public SourceIconRenderer(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull PlayerVolumeAction volumeAction) {
        this.voiceClient = voiceClient;
        this.config = config;
        this.volumeAction = volumeAction;
        LivingEntityRenderEvent.INSTANCE.registerListener(this::onLivingEntityRender);
    }

    @EventSubscribe
    public void onLevelRender(@NotNull LevelRenderEvent event) {
        if (this.isIconHidden() || !((Boolean)this.config.getOverlay().getShowStaticSourceIcons().value()).booleanValue()) {
            return;
        }
        for (ClientAudioSource source2 : this.voiceClient.getSourceManager().getSources()) {
            if (!(source2.getSourceInfo() instanceof StaticSourceInfo) || !((SourceInfo)source2.getSourceInfo()).isIconVisible() || !source2.isActivated()) continue;
            Optional sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source2.getSourceInfo()).getLineId());
            if (!sourceLine.isPresent()) {
                return;
            }
            ClientStaticSource staticSource = (ClientStaticSource)source2;
            Pos3d sourcePosition = ((StaticSourceInfo)staticSource.getSourceInfo()).getPosition();
            this.renderStatic(event.getStack(), event.getLightSupplier().getLight(sourcePosition), class_2960.method_12829((String)((ClientSourceLine)sourceLine.get()).getIcon()), staticSource, event.getDelta());
        }
    }

    private void onLivingEntityRender(@NotNull LivingEntityRenderState entityRenderState, @NotNull class_4587 stack, int light) {
        if (entityRenderState.getEntityType().equals((Object)class_1299.field_6097)) {
            this.renderPlayer(entityRenderState, stack, light);
        } else {
            this.renderLivingEntity(entityRenderState, stack, light);
        }
    }

    private void renderPlayer(@NotNull LivingEntityRenderState entityRenderState, @NotNull class_4587 stack, int light) {
        Optional<VoicePlayerInfo> playerInfo;
        String iconLocation;
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        if (entityRenderState.getShouldHideIcon()) {
            return;
        }
        UUID entityUUID = entityRenderState.getEntityUUID();
        boolean isFakePlayer = !class_310.method_1551().method_1562().method_31363().contains(entityUUID);
        Collection<ClientAudioSource<EntitySourceInfo>> entitySources = this.voiceClient.getSourceManager().getEntitySources(entityRenderState.getEntityId());
        if (isFakePlayer && !entitySources.isEmpty()) {
            this.renderLivingEntity(entityRenderState, stack, light);
            return;
        }
        if (this.isIconHidden() || entityUUID.equals(clientPlayer.method_5667()) || isFakePlayer || entityRenderState.isInvisibleToPlayer()) {
            return;
        }
        boolean hasPercent = this.volumeAction.isShown(entityRenderState.getEntityUUID());
        if (hasPercent) {
            this.renderPercent(entityRenderState, stack, light);
        }
        if ((iconLocation = this.getPlayerIcon((playerInfo = connection.get().getPlayerById(entityUUID)).orElse(null), entityRenderState, entityRenderState.getPlayerIconVisibility())) == null) {
            return;
        }
        this.renderEntity(entityRenderState, stack, light, class_2960.method_12829((String)iconLocation), hasPercent);
    }

    private void renderLivingEntity(@NotNull LivingEntityRenderState entityRenderState, @NotNull class_4587 stack, int light) {
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        if (entityRenderState.getShouldHideIcon()) {
            return;
        }
        if (this.isIconHidden() || entityRenderState.isInvisibleToPlayer()) {
            return;
        }
        Collection sources = this.voiceClient.getSourceManager().getEntitySources(entityRenderState.getEntityId());
        ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(sources);
        if (highestSourceLine == null) {
            return;
        }
        this.renderEntity(entityRenderState, stack, light, class_2960.method_12829((String)highestSourceLine.getIcon()), false);
    }

    private void renderEntity(@NonNull LivingEntityRenderState entityRenderState, @NonNull class_4587 stack, int light, @NonNull class_2960 iconLocation, boolean hasPercent) {
        if (entityRenderState == null) {
            throw new NullPointerException("entityRenderState is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (iconLocation == null) {
            throw new NullPointerException("iconLocation is marked non-null but is null");
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        if (entityRenderState.getDistanceToCameraSquared() > 4096.0) {
            return;
        }
        stack.method_22903();
        if (hasPercent) {
            stack.method_22904(0.0, 0.3, 0.0);
        }
        this.translateEntityMatrix(entityRenderState, camera, stack);
        if (entityRenderState.isDiscrete()) {
            this.vertices(stack, 40, light, iconLocation, false);
        } else {
            this.vertices(stack, 255, light, iconLocation, false);
            this.vertices(stack, 40, light, iconLocation, true);
        }
        stack.method_22909();
    }

    private void renderPercent(@NotNull LivingEntityRenderState entityRenderState, @NonNull class_4587 stack, int light) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        if (entityRenderState.getDistanceToCameraSquared() > 4096.0) {
            return;
        }
        stack.method_22903();
        this.translateEntityMatrix(entityRenderState, camera, stack);
        stack.method_22904(5.0, 0.0, 0.0);
        DoubleConfigEntry volume = this.config.getVoice().getVolumes().getVolume("source_" + String.valueOf(entityRenderState.getEntityUUID()));
        McLiteralText text = McTextComponent.literal((int)Math.round((Double)volume.value() * 100.0) + "%");
        int backgroundColor = 0x3F000000;
        int xOffset = -RenderUtil.getTextWidth(text) / 2;
        this.glState.withState(() -> {
            RenderUtil.fillLight(stack, RenderPipelines.TEXT_BACKGROUND, xOffset - 1, -1, xOffset + RenderUtil.getTextWidth(text) + 1, 8, backgroundColor, light);
            RenderUtil.drawStringLight(stack, text, xOffset, 0, Colors.withAlpha(Colors.WHITE, 0.5f).getRGB(), light, !entityRenderState.isDiscrete(), false);
            RenderUtil.drawStringLight(stack, text, xOffset, 0, -1, class_765.method_62228((int)light, (int)2), false, false);
        });
        stack.method_22909();
    }

    private void translateEntityMatrix(@NotNull LivingEntityRenderState entityRenderState, @NonNull class_4184 camera, @NonNull class_4587 stack) {
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        class_243 nameTagAttachment = entityRenderState.getNameTagAttachment();
        if (entityRenderState.getNameTag() != null) {
            stack.method_22904(0.0, 0.3, 0.0);
            if (entityRenderState.getHasScoreboardText() && entityRenderState.getDistanceToCameraSquared() < 100.0) {
                stack.method_22904(0.0, 0.3, 0.0);
            }
        }
        stack.method_22904(nameTagAttachment.method_10216(), nameTagAttachment.method_10214() + 0.5, nameTagAttachment.method_10215());
        PoseStackKt.rotate(stack, -camera.method_19330(), 0.0f, 1.0f, 0.0f);
        PoseStackKt.rotate(stack, camera.method_19329(), 1.0f, 0.0f, 0.0f);
        stack.method_22905(-0.025f, -0.025f, 0.025f);
        stack.method_22904(-5.0, -1.0, 0.0);
    }

    private void renderStatic(@NonNull class_4587 stack, int light, @NotNull class_2960 iconLocation, @NotNull ClientStaticSource staticSource, double delta) {
        Pos3d lastPosition;
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Pos3d position = ((StaticSourceInfo)staticSource.getSourceInfo()).getPosition();
        if (position.distanceSquared(lastPosition = staticSource.getLastRenderPosition()) > 1.0) {
            lastPosition.setX(position.getX());
            lastPosition.setY(position.getY());
            lastPosition.setZ(position.getZ());
        } else {
            lastPosition.setX(class_3532.method_16436((double)delta, (double)lastPosition.getX(), (double)position.getX()));
            lastPosition.setY(class_3532.method_16436((double)delta, (double)lastPosition.getY(), (double)position.getY()));
            lastPosition.setZ(class_3532.method_16436((double)delta, (double)lastPosition.getZ(), (double)position.getZ()));
        }
        double distanceToCamera = CameraKt.position(camera).method_1025(MathKt.toVec3(lastPosition));
        if (distanceToCamera > 4096.0) {
            return;
        }
        stack.method_22903();
        stack.method_22904(lastPosition.getX() - CameraKt.position((class_4184)camera).field_1352, lastPosition.getY() - CameraKt.position((class_4184)camera).field_1351, lastPosition.getZ() - CameraKt.position((class_4184)camera).field_1350);
        PoseStackKt.rotate(stack, -camera.method_19330(), 0.0f, 1.0f, 0.0f);
        PoseStackKt.rotate(stack, camera.method_19329(), 1.0f, 0.0f, 0.0f);
        stack.method_22905(-0.025f, -0.025f, 0.025f);
        stack.method_22904(-5.0, -5.0, 0.0);
        this.vertices(stack, 255, light, iconLocation, false);
        this.vertices(stack, 40, light, iconLocation, true);
        stack.method_22909();
    }

    private void vertices(@NonNull class_4587 stack, int alpha, int light, @NotNull class_2960 iconLocation, boolean seeThrough) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        class_1921 renderType = seeThrough ? class_1921.method_23030((class_2960)iconLocation) : class_1921.method_23028((class_2960)iconLocation);
        RenderPipeline renderPipeline = RenderPipelines.fromRenderType(seeThrough ? "text_see_through" : "text", renderType);
        class_287 buffer = RenderUtil.beginBuffer(renderPipeline);
        this.vertex(stack, buffer, 0.0f, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
        this.vertex(stack, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        renderType.method_60895(buffer.method_60794());
    }

    private void vertex(@NonNull class_4587 stack, @NonNull class_287 buffer, float x, float y, float z, float u, float v, int alpha, int light) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        VertexBuilder.create(buffer).position(stack, x, y, z).color(255, 255, 255, alpha).uv(u, v).light(light).normal(stack, 0.0f, 0.0f, -1.0f).end();
    }

    private boolean isIconHidden() {
        if (!this.voiceClient.getServerInfo().isPresent() || !this.voiceClient.getUdpClientManager().isConnected()) {
            return true;
        }
        int showIcons = (Integer)this.config.getOverlay().getShowSourceIcons().value();
        return showIcons == 2 || class_310.method_1551().field_1690.field_1842 && showIcons == 0;
    }

    @Nullable
    private String iconOrNull(@NotNull Set<PlayerIconVisibility> iconVisibility, @NotNull PlayerIconVisibility targetIconVisibility, @NotNull String iconLocation) {
        return iconVisibility.contains((Object)targetIconVisibility) ? null : iconLocation;
    }

    @Nullable
    private String getPlayerIcon(@Nullable VoicePlayerInfo playerInfo, @NotNull LivingEntityRenderState entityRenderState, @NotNull Set<PlayerIconVisibility> iconVisibility) {
        if (playerInfo == null) {
            String iconBySource = this.getPlayerIconBySource(entityRenderState, iconVisibility);
            if (iconBySource != null) {
                return iconBySource;
            }
            return this.iconOrNull(iconVisibility, PlayerIconVisibility.HIDE_NOT_INSTALLED, "plasmovoice:textures/icons/headset_not_installed.png");
        }
        if (((Boolean)this.config.getVoice().getVolumes().getMute("source_" + String.valueOf(playerInfo.getPlayerId())).value()).booleanValue()) {
            return this.iconOrNull(iconVisibility, PlayerIconVisibility.HIDE_CLIENT_MUTED, "plasmovoice:textures/icons/speaker_disabled.png");
        }
        if (playerInfo.isMuted()) {
            return this.iconOrNull(iconVisibility, PlayerIconVisibility.HIDE_SERVER_MUTED, "plasmovoice:textures/icons/speaker_muted.png");
        }
        if (playerInfo.isVoiceDisabled()) {
            return this.iconOrNull(iconVisibility, PlayerIconVisibility.HIDE_VOICE_CHAT_DISABLED, "plasmovoice:textures/icons/headset_disabled.png");
        }
        return this.getPlayerIconBySource(entityRenderState, iconVisibility);
    }

    @Nullable
    private String getPlayerIconBySource(@NotNull LivingEntityRenderState entityRenderState, @NotNull Set<PlayerIconVisibility> iconVisibility) {
        if (iconVisibility.contains((Object)PlayerIconVisibility.HIDE_SOURCE_ICON)) {
            return null;
        }
        Collection playerSources = this.voiceClient.getSourceManager().getPlayerSources(entityRenderState.getEntityUUID());
        Collection entitySources = this.voiceClient.getSourceManager().getEntitySources(entityRenderState.getEntityId());
        if (playerSources.isEmpty() && entitySources.isEmpty()) {
            return null;
        }
        ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(playerSources);
        if (highestSourceLine == null && (highestSourceLine = this.getHighestActivatedSourceLine(entitySources)) == null) {
            return null;
        }
        return highestSourceLine.getIcon();
    }

    private <T extends SourceInfo> ClientSourceLine getHighestActivatedSourceLine(@NotNull Collection<ClientAudioSource<T>> sources) {
        SourceLine highestSourceLine = null;
        for (ClientAudioSource<T> source2 : sources) {
            Optional sourceLine;
            if (!source2.isActivated() || !((SourceInfo)source2.getSourceInfo()).isIconVisible() || !(sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source2.getSourceInfo()).getLineId())).isPresent() || highestSourceLine != null && highestSourceLine.getWeight() >= ((ClientSourceLine)sourceLine.get()).getWeight()) continue;
            highestSourceLine = (ClientSourceLine)sourceLine.get();
        }
        return highestSourceLine;
    }
}

