/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.api.server.position;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.position.Pos3d;
import su.plo.slib.api.server.world.McServerWorld;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.JvmOverloads;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B?\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fB\t\b\u0016\u00a2\u0006\u0004\b\u000b\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\"\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u001d\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010-\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0013\u00a8\u0006."}, d2={"Lsu/plo/slib/api/server/position/ServerPos3d;", "", "Lsu/plo/slib/api/server/world/McServerWorld;", "world", "", "x", "y", "z", "", "yaw", "pitch", "<init>", "(Lsu/plo/slib/api/server/world/McServerWorld;DDDFF)V", "()V", "o", "distanceSquared", "(Lsu/plo/slib/api/server/position/ServerPos3d;)D", "Lsu/plo/slib/api/position/Pos3d;", "toPosition", "()Lsu/plo/slib/api/position/Pos3d;", "D", "getX", "()D", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "F", "getYaw", "()F", "setYaw", "(F)V", "getPitch", "setPitch", "Ljava/lang/ref/Reference;", "worldReference", "Ljava/lang/ref/Reference;", "value", "getWorld", "()Lsu/plo/slib/api/server/world/McServerWorld;", "setWorld", "(Lsu/plo/slib/api/server/world/McServerWorld;)V", "getLookAngle", "lookAngle", "api-server"})
@SourceDebugExtension(value={"SMAP\nServerPos3d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerPos3d.kt\nsu/plo/slib/api/server/position/ServerPos3d\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class ServerPos3d {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    @NotNull
    private Reference<McServerWorld> worldReference;

    @JvmOverloads
    public ServerPos3d(@Nullable McServerWorld world, double x, double y, double z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.worldReference = new WeakReference<McServerWorld>(world);
    }

    public /* synthetic */ ServerPos3d(McServerWorld mcServerWorld, double d, double d2, double d3, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            f = 0.0f;
        }
        if ((n & 0x20) != 0) {
            f2 = 0.0f;
        }
        this(mcServerWorld, d, d2, d3, f, f2);
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final void setYaw(float f) {
        this.yaw = f;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final void setPitch(float f) {
        this.pitch = f;
    }

    public ServerPos3d() {
        this(null, 0.0, 0.0, 0.0, 0.0f, 0.0f, 48, null);
    }

    @NotNull
    public final McServerWorld getWorld() {
        McServerWorld mcServerWorld = this.worldReference.get();
        Intrinsics.checkNotNull(mcServerWorld);
        return mcServerWorld;
    }

    public final void setWorld(@NotNull McServerWorld value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Intrinsics.areEqual(this.worldReference.get(), value)) {
            this.worldReference = new WeakReference<McServerWorld>(value);
        }
    }

    public final double distanceSquared(@NotNull ServerPos3d o) {
        Intrinsics.checkNotNullParameter(o, "o");
        if (!Intrinsics.areEqual(o.getWorld(), this.getWorld())) {
            boolean bl = false;
            String string = "Cannot measure distance between worlds";
            throw new IllegalArgumentException(string.toString());
        }
        double xDiff = this.x - o.x;
        double yDiff = this.y - o.y;
        double zDiff = this.z - o.z;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    @NotNull
    public final Pos3d toPosition() {
        return new Pos3d(this.x, this.y, this.z);
    }

    @NotNull
    public final Pos3d getLookAngle() {
        Pos3d pos = new Pos3d();
        double rotX = this.yaw;
        double rotY = this.pitch;
        pos.setY(-Math.sin(Math.toRadians(rotY)));
        double xz = Math.cos(Math.toRadians(rotY));
        pos.setX(-xz * Math.sin(Math.toRadians(rotX)));
        pos.setZ(xz * Math.cos(Math.toRadians(rotX)));
        return pos;
    }

    @JvmOverloads
    public ServerPos3d(@Nullable McServerWorld world, double x, double y, double z, float yaw) {
        this(world, x, y, z, yaw, 0.0f, 32, null);
    }

    @JvmOverloads
    public ServerPos3d(@Nullable McServerWorld world, double x, double y, double z) {
        this(world, x, y, z, 0.0f, 0.0f, 48, null);
    }
}

