/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.chat;

import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.chat.component.McTextComponent;

public final class ClientChatUtil {
    public static void setActionBar(@NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        Minecraft.getInstance().gui.setOverlayMessage(component, false);
    }

    public static void setActionBar(@NonNull McTextComponent text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        ClientChatUtil.setActionBar(RenderUtil.getTextConverter().convert(text));
    }

    public static void sendChatMessage(@NonNull McTextComponent text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        ClientChatUtil.sendChatMessage(RenderUtil.getTextConverter().convert(text));
    }

    public static void sendChatMessage(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        LocalPlayer player = Minecraft.getInstance().player;
        player.displayClientMessage(message, false);
    }

    private ClientChatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

