/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.text.event;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.libs.adventure.adventure.internal.Internals;
import su.plo.slib.libs.adventure.adventure.key.Key;
import su.plo.slib.libs.adventure.adventure.text.event.DataComponentValueConverterRegistry;
import su.plo.slib.libs.adventure.examination.ExaminableProperty;

final class DataComponentValueConversionImpl<I, O>
implements DataComponentValueConverterRegistry.Conversion<I, O> {
    private final Class<I> source;
    private final Class<O> destination;
    private final BiFunction<Key, I, O> conversion;

    DataComponentValueConversionImpl(@NotNull Class<I> source2, @NotNull Class<O> destination, @NotNull BiFunction<Key, I, O> conversion) {
        this.source = source2;
        this.destination = destination;
        this.conversion = conversion;
    }

    @Override
    @NotNull
    public Class<I> source() {
        return this.source;
    }

    @Override
    @NotNull
    public Class<O> destination() {
        return this.destination;
    }

    @Override
    @NotNull
    public O convert(@NotNull Key key, @NotNull I input) {
        return this.conversion.apply(Objects.requireNonNull(key, "key"), Objects.requireNonNull(input, "input"));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("source", this.source), ExaminableProperty.of("destination", this.destination), ExaminableProperty.of("conversion", this.conversion));
    }

    public String toString() {
        return Internals.toString(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataComponentValueConversionImpl that = (DataComponentValueConversionImpl)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.destination, that.destination) && Objects.equals(this.conversion, that.conversion);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.destination, this.conversion);
    }
}

