/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.logging.McLoggerFactory;
import su.plo.slib.mod.channel.ModChannelManager;
import su.plo.slib.mod.logging.Log4jLogger;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.device.AlInputDeviceFactory;
import su.plo.voice.client.audio.device.AlOutputDeviceFactory;
import su.plo.voice.client.audio.device.JavaxInputDeviceFactory;
import su.plo.voice.client.connection.ModClientChannelHandler;
import su.plo.voice.client.event.key.KeyPressedEvent;
import su.plo.voice.client.gui.settings.VoiceScreens;
import su.plo.voice.client.render.ModHudRenderer;
import su.plo.voice.client.render.ModLevelRenderer;
import su.plo.voice.server.ModVoiceServer;
import su.plo.voice.util.version.PlatformLoader;

public final class ModVoiceClient
extends BaseVoiceClient {
    public static ModVoiceClient INSTANCE;
    private final String modId = "plasmovoice";
    public static final KeyMapping MENU_KEY;
    private final ModHudRenderer hudRenderer;
    private final ModLevelRenderer levelRenderer;
    private final ModClientChannelHandler handler = new ModClientChannelHandler(this);

    public ModVoiceClient() {
        super(PlatformLoader.FABRIC);
        McLoggerFactory.supplier = Log4jLogger::new;
        DeviceFactoryManager factoryManager = this.getDeviceFactoryManager();
        factoryManager.registerDeviceFactory(new AlOutputDeviceFactory(this));
        factoryManager.registerDeviceFactory(new AlInputDeviceFactory(this));
        this.getDeviceFactoryManager().registerDeviceFactory(new JavaxInputDeviceFactory(this));
        this.hudRenderer = new ModHudRenderer();
        this.levelRenderer = new ModLevelRenderer(this);
        INSTANCE = this;
        RenderUtil.getTextConverter().setLanguageSupplier(this.createLanguageSupplier());
    }

    @Override
    protected void onServerDisconnect() {
        super.onServerDisconnect();
        this.handler.close();
    }

    @EventSubscribe
    public void onKeyPressed(@NotNull KeyPressedEvent event) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (MENU_KEY.consumeClick()) {
            VoiceScreens.INSTANCE.openSettings(this);
        }
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return new File("config/plasmovoice");
    }

    @Override
    public Optional<ServerConnection> getServerConnection() {
        return this.handler.getConnection();
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        ModChannelManager.Companion.registerClientHandler(ModVoiceServer.CHANNEL, this.handler);
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
    }

    @SubscribeEvent
    public void onOverlayRender(@NotNull RenderGuiLayerEvent.Post event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.CHAT)) {
            return;
        }
        this.hudRenderer.render(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        this.onServerDisconnect();
    }

    public ModHudRenderer getHudRenderer() {
        return this.hudRenderer;
    }

    public ModLevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    static {
        MENU_KEY = new KeyMapping("key.plasmovoice.settings", InputConstants.Type.KEYSYM, 86, KeyMapping.Category.register((ResourceLocation)ResourceLocationUtil.mod("name")));
    }

    @EventBusSubscriber(modid="plasmovoice", value={Dist.CLIENT})
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onKeyMappingsRegister(RegisterKeyMappingsEvent event) {
            event.register(MENU_KEY);
        }
    }
}

