/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.source.BaseClientAudioSource;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.extension.MathKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lsu/plo/voice/client/audio/source/ClientStaticSource;", "Lsu/plo/voice/client/audio/source/BaseClientAudioSource;", "Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;", "voiceClient", "Lsu/plo/voice/client/BaseVoiceClient;", "config", "Lsu/plo/voice/client/config/VoiceClientConfig;", "sourceInfo", "<init>", "(Lsu/plo/voice/client/BaseVoiceClient;Lsu/plo/voice/client/config/VoiceClientConfig;Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;)V", "lastRenderPosition", "Lsu/plo/slib/api/position/Pos3d;", "getLastRenderPosition", "()Lsu/plo/slib/api/position/Pos3d;", "getPosition", "Lnet/minecraft/world/phys/Vec3;", "getLookAngle", "shouldCalculateDirectionalGain", "", "plasmovoice-neoforge-1.21.9"})
public final class ClientStaticSource
extends BaseClientAudioSource<StaticSourceInfo> {
    @NotNull
    private final Pos3d lastRenderPosition;

    public ClientStaticSource(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull StaticSourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(sourceInfo, "sourceInfo");
        super(voiceClient, config, (SourceInfo)sourceInfo);
        this.lastRenderPosition = Pos3d.copy$default(sourceInfo.getPosition(), 0.0, 0.0, 0.0, 7, null);
    }

    @NotNull
    public final Pos3d getLastRenderPosition() {
        return this.lastRenderPosition;
    }

    @Override
    @NotNull
    protected Vec3 getPosition() {
        Pos3d pos3d = ((StaticSourceInfo)this.getSourceInfo()).getPosition();
        Intrinsics.checkNotNullExpressionValue(pos3d, "getPosition(...)");
        return MathKt.toVec3(pos3d);
    }

    @Override
    @NotNull
    protected Vec3 getLookAngle() {
        Pos3d pos3d = ((StaticSourceInfo)this.getSourceInfo()).getLookAngle();
        Intrinsics.checkNotNullExpressionValue(pos3d, "getLookAngle(...)");
        return MathKt.toVec3(pos3d);
    }

    @Override
    protected boolean shouldCalculateDirectionalGain() {
        return ((StaticSourceInfo)this.getSourceInfo()).getAngle() > 0 && super.shouldCalculateDirectionalGain();
    }
}

