/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.extensions.AABBKt;
import su.plo.lib.mod.extensions.EntityKt;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.key.MouseScrollEvent;
import su.plo.voice.client.extension.OptionsKt;

public final class PlayerVolumeAction {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private Player focusedPlayer;
    private long lastScroll;

    public PlayerVolumeAction(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
        voiceClient.getHotkeys().getHotkey("key.plasmovoice.general.action").ifPresent(key -> key.addPressListener(this::onButton));
    }

    public boolean isShown(@NotNull UUID playerId) {
        return this.focusedPlayer != null && this.focusedPlayer.getUUID().equals(playerId) && this.lastScroll != 0L && System.currentTimeMillis() - this.lastScroll < 1000L;
    }

    @EventSubscribe
    public void onScroll(@NotNull MouseScrollEvent event) {
        if (this.focusedPlayer != null && Minecraft.getInstance().screen == null) {
            this.lastScroll = System.currentTimeMillis();
            DoubleConfigEntry volume = this.config.getVoice().getVolumes().getVolume("source_" + String.valueOf(this.focusedPlayer.getUUID()));
            double value = (Double)volume.value() + (event.getVertical() > 0.0 ? 0.05 : -0.05);
            volume.set((double)(Math.round(value * volume.getMax() * 100.0 / 5.0) * 5L) / (volume.getMax() * 100.0));
            event.setCancelled(true);
        }
    }

    private void onButton(@NotNull Hotkey.Action action) {
        if (!this.voiceClient.getServerConnection().isPresent()) {
            return;
        }
        if (action == Hotkey.Action.DOWN) {
            ServerConnection serverConnection = this.voiceClient.getServerConnection().get();
            this.getPlayerBySight().filter(player -> serverConnection.getPlayerById(player.getUUID()).isPresent()).ifPresent(player -> {
                this.focusedPlayer = player;
            });
        } else if (action == Hotkey.Action.UP) {
            this.focusedPlayer = null;
            this.lastScroll = 0L;
        }
    }

    private Optional<Player> getPlayerBySight() {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (level == null || player == null) {
            return Optional.empty();
        }
        Vec3 playerPos = EntityKt.eyePosition((Entity)player);
        Vec3 rotVector = player.getLookAngle();
        for (int i = 0; i < OptionsKt.renderDistanceValue(Minecraft.getInstance().options) * 16; ++i) {
            playerPos = playerPos.add(rotVector);
            BlockPos blockPos = new BlockPos((int)Math.floor(playerPos.x), (int)Math.floor(playerPos.y), (int)Math.floor(playerPos.z));
            BlockState state = level.getBlockState(blockPos);
            boolean isSolid = state.isSolidRender();
            if (!state.isAir() && isSolid) break;
            AABB box = AABBKt.ofSize(playerPos.subtract(0.0, 1.0, 0.0), 1.0, 2.0, 1.0);
            for (Player playerEntity : level.players()) {
                if (!box.contains(playerEntity.getX(), playerEntity.getY(), playerEntity.getZ()) || playerEntity.isInvisibleTo((Player)player) || player.getUUID().equals(playerEntity.getUUID())) continue;
                return Optional.of(playerEntity);
            }
        }
        return Optional.empty();
    }
}

