/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.source.LoopbackSource;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureEvent;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureProcessedEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.gui.MicrophoneTestStartedEvent;
import su.plo.voice.client.event.gui.MicrophoneTestStoppedEvent;

public final class MicrophoneTestController {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private double highestDB = -127.0;
    private long lastUpdate = 0L;
    private double microphoneValue = 0.0;
    private double microphoneDB = 0.0;
    private LoopbackSource source;

    public void tick(double delta) {
        this.microphoneValue = Math.max(this.microphoneValue - 0.04 * delta, 0.0);
    }

    public void restart() {
        if (this.source == null) {
            return;
        }
        this.source.close();
        try {
            this.initializeLoopbackSource();
        }
        catch (DeviceException e) {
            BaseVoice.LOGGER.error("Failed to initialize source for mic test", e);
            this.source = null;
        }
    }

    public void start() {
        if (this.source != null) {
            return;
        }
        try {
            this.initializeLoopbackSource();
        }
        catch (DeviceException e) {
            BaseVoice.LOGGER.error("Failed to initialize source for mic test", e);
            this.source = null;
            return;
        }
        this.voiceClient.getEventBus().fire(new MicrophoneTestStartedEvent(this));
    }

    public void stop() {
        if (this.source != null) {
            this.source.close();
        }
        this.source = null;
        this.voiceClient.getEventBus().fire(new MicrophoneTestStoppedEvent(this));
    }

    public boolean isActive() {
        return this.source != null;
    }

    @EventSubscribe
    public void onAudioCapture(@NotNull AudioCaptureEvent event) {
        if (this.source != null) {
            event.setFlushActivations(true);
        }
    }

    @EventSubscribe
    public void onAudioCaptureProcessed(@NotNull AudioCaptureProcessedEvent event) {
        short[] samples = event.getProcessed().getSamples(this.isStereoSupported());
        this.microphoneDB = AudioUtil.calculateHighestAudioLevel(samples);
        if (this.microphoneDB > this.highestDB) {
            this.highestDB = this.microphoneDB;
            this.lastUpdate = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastUpdate > 1000L) {
            this.highestDB = this.microphoneDB;
        }
        double value = 1.0 - this.microphoneDB / -60.0;
        if (this.microphoneDB > -60.0 && value > this.microphoneValue) {
            this.microphoneValue = AudioUtil.audioLevelToDoubleRange(this.microphoneDB);
        }
        if (this.source != null) {
            this.source.write(samples);
        }
    }

    private void initializeLoopbackSource() throws DeviceException {
        this.source = this.voiceClient.getSourceManager().createLoopbackSource(true);
        try {
            this.source.initialize(this.isStereoSupported());
        }
        catch (DeviceException e) {
            this.source = null;
            throw e;
        }
    }

    private boolean isStereoSupported() {
        return (Boolean)this.config.getVoice().getStereoCapture().value() != false && (Boolean)this.config.getAdvanced().getStereoSourcesToMono().value() == false;
    }

    public MicrophoneTestController(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }

    public double getMicrophoneValue() {
        return this.microphoneValue;
    }

    public double getMicrophoneDB() {
        return this.microphoneDB;
    }
}

