/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.slib.api.event.player.McPlayerJoinEvent;
import su.plo.slib.api.event.player.McPlayerQuitEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.event.player.PlayerPermissionUpdateEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.player.VoicePlayerManager;
import su.plo.voice.proto.packets.tcp.clientbound.ConfigPlayerInfoPacket;
import su.plo.voice.server.player.BaseVoicePlayer;

public abstract class BaseVoicePlayerManager<P extends VoicePlayer>
implements VoicePlayerManager<P> {
    protected final Map<UUID, P> playerById = Maps.newConcurrentMap();
    protected final Map<String, P> playerByName = Maps.newConcurrentMap();
    protected final Set<String> synchronizedPermissions = new CopyOnWriteArraySet<String>();

    public BaseVoicePlayerManager() {
        McPlayerJoinEvent.INSTANCE.registerListener(this::onPlayerJoin);
        McPlayerQuitEvent.INSTANCE.registerListener(this::onPlayerQuit);
    }

    @Override
    public Collection<P> getPlayers() {
        return this.playerById.values();
    }

    @Override
    public void registerPermission(@NotNull String permission) {
        if (this.synchronizedPermissions.contains(permission)) {
            throw new IllegalArgumentException("Permissions is already registered");
        }
        this.synchronizedPermissions.add(permission);
    }

    @Override
    public void unregisterPermission(@NotNull String permission) {
        this.synchronizedPermissions.remove(permission);
    }

    @Override
    public Collection<String> getSynchronizedPermissions() {
        return this.synchronizedPermissions;
    }

    public void clear() {
        this.playerById.clear();
        this.playerByName.clear();
        this.synchronizedPermissions.clear();
        McPlayerJoinEvent.INSTANCE.unregisterListener(this::onPlayerJoin);
        McPlayerQuitEvent.INSTANCE.unregisterListener(this::onPlayerQuit);
    }

    @EventSubscribe
    public void onPermissionUpdate(@NotNull PlayerPermissionUpdateEvent event) {
        String permission = event.getPermission();
        if (!this.synchronizedPermissions.contains(permission)) {
            return;
        }
        VoicePlayer player = event.getPlayer();
        HashMap permissions = Maps.newHashMap();
        permissions.put(permission, player.getInstance().hasPermission(permission));
        player.sendPacket(new ConfigPlayerInfoPacket(permissions));
    }

    @EventSubscribe
    public void onClientDisconnect(@NotNull UdpClientDisconnectedEvent event) {
        BaseVoicePlayer player = (BaseVoicePlayer)event.getConnection().getPlayer();
        player.reset();
    }

    public void onPlayerJoin(@NotNull McPlayer player) {
        this.getPlayerByInstance(player.getInstance());
    }

    public void onPlayerQuit(@NotNull McPlayer player) {
        this.playerById.remove(player.getUuid());
        this.playerByName.remove(player.getName());
    }
}

