/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.LazyGlState;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.lib.mod.client.render.texture.ModPlayerSkins;
import su.plo.slib.api.chat.component.McLiteralText;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.api.client.config.overlay.OverlayPosition;
import su.plo.voice.api.client.config.overlay.OverlaySourceState;
import su.plo.voice.api.client.config.overlay.OverlayStyle;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.HudRenderEvent;
import su.plo.voice.client.render.voice.RenderSourceInfo;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.Ref;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;
import su.plo.voice.libs.kotlin.text.StringsKt;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SelfSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u001bH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lsu/plo/voice/client/render/voice/OverlayRenderer;", "Lsu/plo/voice/client/event/HudRenderEvent$Callback;", "voiceClient", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "config", "Lsu/plo/voice/client/config/VoiceClientConfig;", "<init>", "(Lsu/plo/voice/api/client/PlasmoVoiceClient;Lsu/plo/voice/client/config/VoiceClientConfig;)V", "glState", "Lsu/plo/lib/mod/client/render/LazyGlState;", "onRender", "", "context", "Lsu/plo/lib/mod/client/render/gui/GuiRenderContext;", "delta", "", "renderEntry", "sourceLine", "Lsu/plo/voice/api/client/audio/line/ClientSourceLine;", "position", "Lsu/plo/voice/api/client/config/overlay/OverlayPosition;", "index", "", "sourceInfo", "Lsu/plo/voice/client/render/voice/RenderSourceInfo;", "getSourceSenderName", "Lsu/plo/slib/api/chat/component/McTextComponent;", "Lsu/plo/voice/proto/data/audio/source/SourceInfo;", "getSourceSenderId", "Ljava/util/UUID;", "getSourcePlayer", "Lsu/plo/slib/api/entity/player/McGameProfile;", "loadSkin", "Lnet/minecraft/resources/ResourceLocation;", "gameProfile", "calcPositionX", "x", "calcPositionY", "y", "Companion", "plasmovoice-forge-1.20.4"})
@SourceDebugExtension(value={"SMAP\nOverlayRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlayRenderer.kt\nsu/plo/voice/client/render/voice/OverlayRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1053#2:345\n1#3:346\n*S KotlinDebug\n*F\n+ 1 OverlayRenderer.kt\nsu/plo/voice/client/render/voice/OverlayRenderer\n*L\n58#1:345\n*E\n"})
public final class OverlayRenderer
implements HudRenderEvent.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoVoiceClient voiceClient;
    @NotNull
    private final VoiceClientConfig config;
    @NotNull
    private final LazyGlState glState;
    private static final int ENTRY_HEIGHT = 16;
    private static final int MAX_TEXT_WIDTH = 40;

    public OverlayRenderer(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(config, "config");
        this.voiceClient = voiceClient;
        this.config = config;
        this.glState = new LazyGlState();
    }

    @Override
    public void onRender(@NotNull GuiRenderContext context, float delta) {
        Intrinsics.checkNotNullParameter(context, "context");
        if (!this.voiceClient.getServerInfo().isPresent() || !this.voiceClient.getUdpClientManager().getClient().isPresent() || Minecraft.m_91087_().f_91074_ == null || !((Boolean)this.config.getOverlay().getOverlayEnabled().value()).booleanValue() || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        OverlayPosition position = (OverlayPosition)((Object)this.config.getOverlay().getOverlayPosition().value());
        Ref.IntRef renderedIndex = new Ref.IntRef();
        for (ClientSourceLine sourceLine : this.voiceClient.getSourceLineManager().getLines()) {
            OverlaySourceState sourceState = (OverlaySourceState)((Object)this.config.getOverlay().getSourceStates().getState(sourceLine).value());
            if (sourceState == OverlaySourceState.OFF || sourceState == OverlaySourceState.NEVER) continue;
            ArrayList arrayList = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue(arrayList, "newArrayList(...)");
            List toRender = arrayList;
            if (sourceLine.hasPlayers() && sourceState == OverlaySourceState.ALWAYS) {
                boolean bl;
                Object object;
                HashMap hashMap = Maps.newHashMap();
                Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap(...)");
                Map toRenderByPlayerId = hashMap;
                Collection<McGameProfile> collection = sourceLine.getPlayers();
                Intrinsics.checkNotNull(collection);
                Iterable iterable = collection;
                boolean $i$f$sortedBy = false;
                for (McGameProfile mcGameProfile : CollectionsKt.sortedWith(iterable, new Comparator(){

                    public final int compare(T a, T b) {
                        McGameProfile it = (McGameProfile)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (McGameProfile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                    }
                })) {
                    RenderSourceInfo renderSourceInfo = new RenderSourceInfo(mcGameProfile.getId(), McTextComponent.Companion.literal(mcGameProfile.getName()), mcGameProfile, false);
                    toRenderByPlayerId.put(mcGameProfile.getId(), renderSourceInfo);
                    toRender.add(new Pair<UUID, RenderSourceInfo>(mcGameProfile.getId(), renderSourceInfo));
                }
                for (ClientSelfSourceInfo clientSelfSourceInfo : this.voiceClient.getSourceManager().getAllSelfSourceInfos()) {
                    SelfSourceInfo selfSourceInfo;
                    Intrinsics.checkNotNullExpressionValue(clientSelfSourceInfo.getSelfSourceInfo(), "getSelfSourceInfo(...)");
                    if (!Intrinsics.areEqual(selfSourceInfo.getSourceInfo().getLineId(), sourceLine.getId())) continue;
                    if ((RenderSourceInfo)toRenderByPlayerId.get(selfSourceInfo.getPlayerId()) == null) continue;
                    Object $this$onRender_u24lambda_u241 = object;
                    bl = false;
                    ClientActivation clientActivation = this.voiceClient.getActivationManager().getActivationById(selfSourceInfo.getActivationId()).orElse(null);
                    ((RenderSourceInfo)$this$onRender_u24lambda_u241).setActivated(clientActivation != null ? clientActivation.isActive() : false);
                }
                for (ClientAudioSource clientAudioSource : this.voiceClient.getSourceManager().getSourcesByLineId(sourceLine.getId())) {
                    DirectSourceInfo sourceInfo;
                    if (!clientAudioSource.canHear() || ((object = clientAudioSource.getSourceInfo()) instanceof DirectSourceInfo ? (DirectSourceInfo)object : null) == null) continue;
                    sourceInfo = sourceInfo;
                    object = toRenderByPlayerId;
                    McGameProfile mcGameProfile = sourceInfo.getSender();
                    RenderSourceInfo renderSourceInfo = (RenderSourceInfo)object.get(mcGameProfile != null ? mcGameProfile.getId() : null);
                    if (renderSourceInfo == null) continue;
                    Object $this$onRender_u24lambda_u242 = object = renderSourceInfo;
                    bl = false;
                    ((RenderSourceInfo)$this$onRender_u24lambda_u242).setActivated(true);
                }
            } else {
                for (ClientAudioSource<?> source3 : this.voiceClient.getSourceManager().getSourcesByLineId(sourceLine.getId())) {
                    if (!source3.canHear()) continue;
                    UUID uUID = this.getSourceSenderId((SourceInfo)source3.getSourceInfo());
                    UUID uUID2 = this.getSourceSenderId((SourceInfo)source3.getSourceInfo());
                    Object s = source3.getSourceInfo();
                    Intrinsics.checkNotNull(sourceLine);
                    toRender.add(new Pair<UUID, RenderSourceInfo>(uUID, new RenderSourceInfo(uUID2, this.getSourceSenderName((SourceInfo)s, sourceLine), this.getSourcePlayer((SourceInfo)source3.getSourceInfo()), true)));
                }
            }
            if (toRender.isEmpty()) continue;
            this.glState.withState(() -> OverlayRenderer.onRender$lambda$3(toRender, this, context, sourceLine, position, renderedIndex));
        }
    }

    private final void renderEntry(GuiRenderContext context, ClientSourceLine sourceLine, OverlayPosition position, int index, RenderSourceInfo sourceInfo) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        OverlayStyle overlayStyle = (OverlayStyle)((Object)this.config.getOverlay().getOverlayStyle().value());
        McTextComponent sourceName = sourceInfo.getSourceName();
        int textWidth = RenderUtil.getTextWidth(sourceName) + 8;
        int x = 0;
        x = this.calcPositionX(position.getX());
        int y = 0;
        y = this.calcPositionY(position.getY());
        y = position.isBottom() ? (y -= 17 * (index + 1)) : (y += 17 * index);
        context.getStack().m_85836_();
        context.getStack().m_85837_(0.0, 0.0, 1000.0);
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color, "BLACK");
        Color backgroundColor = Colors.withAlpha(color, 0.25f);
        if (overlayStyle.getHasSkin()) {
            McGameProfile mcGameProfile = sourceInfo.getPlayer();
            if (mcGameProfile != null) {
                McGameProfile it = mcGameProfile;
                boolean bl = false;
                if (position.isRight()) {
                    x -= 16;
                }
                ResourceLocation skinLocation = this.loadSkin(it);
                context.blit(skinLocation, x, y, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64, RenderPipelines.GUI_TEXTURE_OVERLAY);
                context.blit(skinLocation, x, y, 16, 16, 40.0f, 8.0f, 8, 8, 64, 64, RenderPipelines.GUI_TEXTURE_OVERLAY);
                if (!position.isRight()) {
                    x += 17;
                }
            }
        }
        if (overlayStyle.getHasName()) {
            String string = RenderUtil.getFormattedString(sourceName);
            Intrinsics.checkNotNullExpressionValue(string, "getFormattedString(...)");
            if (!StringsKt.isBlank(string)) {
                if (position.isRight()) {
                    x -= textWidth + 1;
                }
                context.fill(x, y, x + textWidth, y + 16, backgroundColor, RenderPipelines.GUI_COLOR_OVERLAY);
                Color color2 = Colors.WHITE;
                Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
                context.drawString(sourceName, x + 4, y + 4, color2, false);
                if (sourceInfo.getActivated() && !position.isRight()) {
                    x += textWidth + 1;
                }
            }
        }
        if (sourceInfo.getActivated()) {
            if (position.isRight()) {
                x -= 17;
            }
            String string = sourceLine.getIcon();
            Intrinsics.checkNotNullExpressionValue(string, "getIcon(...)");
            ResourceLocation iconLocation = ResourceLocationUtil.parse(string);
            context.fill(x, y, x + 16, y + 16, backgroundColor, RenderPipelines.GUI_COLOR_OVERLAY);
            context.blit(iconLocation, x, y, 0.0f, 0.0f, 16, 16, 16, 16, RenderPipelines.GUI_TEXTURE_OVERLAY);
        }
        context.getStack().m_85849_();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final McTextComponent getSourceSenderName(SourceInfo sourceInfo, ClientSourceLine sourceLine) {
        McTextComponent mcTextComponent;
        GameProfile gameProfile;
        Object object;
        ClientPacketListener clientPacketListener;
        McTextComponent mcTextComponent2;
        if (sourceInfo.getName() != null) {
            String string = sourceInfo.getName();
            Intrinsics.checkNotNull(string);
            Object sourceName = string;
            if (((String)sourceName).length() <= 40) return McTextComponent.Companion.literal((String)sourceName);
            String string2 = ((String)sourceName).substring(0, 40);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            sourceName = string2 + "...";
            return McTextComponent.Companion.literal((String)sourceName);
        }
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 instanceof DirectSourceInfo) {
            Object object2 = ((DirectSourceInfo)sourceInfo).getSender();
            if (object2 != null) {
                McGameProfile it = object2;
                boolean bl = false;
                McLiteralText mcLiteralText = McTextComponent.Companion.literal(it.getName());
                object2 = mcLiteralText;
                if (mcLiteralText != null) {
                    mcTextComponent2 = (McTextComponent)object2;
                    return mcTextComponent2;
                }
            }
            mcTextComponent2 = sourceLine.getTranslationComponent();
            return mcTextComponent2;
        }
        if (!(sourceInfo2 instanceof PlayerSourceInfo)) {
            mcTextComponent2 = sourceLine.getTranslationComponent();
            return mcTextComponent2;
        }
        VoicePlayerInfo playerInfo = ((PlayerSourceInfo)sourceInfo).getPlayerInfo();
        Optional<ServerConnection> optional = this.voiceClient.getServerConnection();
        Intrinsics.checkNotNullExpressionValue(optional, "getServerConnection(...)");
        ServerConnection serverConnection = OptionalsKt.getOrNull(optional);
        String voicePlayerNick = serverConnection != null && (clientPacketListener = serverConnection.getPlayerById(playerInfo.getPlayerId())) != null && (object = (VoicePlayerInfo)OptionalsKt.getOrNull(clientPacketListener)) != null ? ((VoicePlayerInfo)object).getPlayerNick() : null;
        clientPacketListener = Minecraft.m_91087_().m_91403_();
        String minecraftPlayerNick = clientPacketListener != null && (object = clientPacketListener.m_104949_(playerInfo.getPlayerId())) != null && (gameProfile = object.m_105312_()) != null ? gameProfile.getName() : null;
        String string = voicePlayerNick;
        if (string == null) {
            string = minecraftPlayerNick;
        }
        if ((clientPacketListener = string) != null) {
            ClientPacketListener it = clientPacketListener;
            boolean bl = false;
            object = McTextComponent.Companion.literal((String)it);
            if (object != null) {
                mcTextComponent = (McTextComponent)object;
                return mcTextComponent;
            }
        }
        mcTextComponent = sourceLine.getTranslationComponent();
        return mcTextComponent;
    }

    private final UUID getSourceSenderId(SourceInfo sourceInfo) {
        Object object;
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 instanceof DirectSourceInfo) {
            Object object2 = ((DirectSourceInfo)sourceInfo).getSender();
            if (object2 == null || (object2 = ((McGameProfile)object2).getId()) == null) {
                object2 = ((DirectSourceInfo)sourceInfo).getId();
            }
            Object object3 = object2;
            Intrinsics.checkNotNull(object3);
            object = object3;
        } else if (sourceInfo2 instanceof PlayerSourceInfo) {
            UUID uUID = ((PlayerSourceInfo)sourceInfo).getPlayerInfo().getPlayerId();
            object = uUID;
            Intrinsics.checkNotNullExpressionValue(uUID, "getPlayerId(...)");
        } else {
            UUID uUID = sourceInfo.getId();
            object = uUID;
            Intrinsics.checkNotNullExpressionValue(uUID, "getId(...)");
        }
        return object;
    }

    private final McGameProfile getSourcePlayer(SourceInfo sourceInfo) {
        McGameProfile mcGameProfile;
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 instanceof DirectSourceInfo) {
            mcGameProfile = ((DirectSourceInfo)sourceInfo).getSender();
        } else if (sourceInfo2 instanceof PlayerSourceInfo) {
            UUID uUID = ((PlayerSourceInfo)sourceInfo).getPlayerInfo().getPlayerId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getPlayerId(...)");
            String string = ((PlayerSourceInfo)sourceInfo).getPlayerInfo().getPlayerNick();
            Intrinsics.checkNotNullExpressionValue(string, "getPlayerNick(...)");
            List<McGameProfile.Property> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, "emptyList(...)");
            mcGameProfile = new McGameProfile(uUID, string, list);
        } else {
            mcGameProfile = null;
        }
        return mcGameProfile;
    }

    private final ResourceLocation loadSkin(McGameProfile gameProfile) {
        ModPlayerSkins.loadSkin(gameProfile);
        ResourceLocation resourceLocation = ModPlayerSkins.getSkin(gameProfile.getId(), gameProfile.getName());
        Intrinsics.checkNotNullExpressionValue(resourceLocation, "getSkin(...)");
        return resourceLocation;
    }

    private final int calcPositionX(int x) {
        return x < 0 ? Minecraft.m_91087_().m_91268_().m_85445_() + x : x;
    }

    private final int calcPositionY(int y) {
        return y < 0 ? Minecraft.m_91087_().m_91268_().m_85446_() + y : y;
    }

    private static final void onRender$lambda$3(List $toRender, OverlayRenderer this$0, GuiRenderContext $context, ClientSourceLine $sourceLine, OverlayPosition $position, Ref.IntRef $renderedIndex) {
        Iterator iterator2 = $toRender.iterator();
        while (iterator2.hasNext()) {
            RenderSourceInfo sourceInfo = (RenderSourceInfo)((Pair)iterator2.next()).component2();
            Intrinsics.checkNotNull($sourceLine);
            Intrinsics.checkNotNull((Object)$position);
            int n = $renderedIndex.element;
            $renderedIndex.element = n + 1;
            this$0.renderEntry($context, $sourceLine, $position, n, sourceInfo);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lsu/plo/voice/client/render/voice/OverlayRenderer$Companion;", "", "<init>", "()V", "ENTRY_HEIGHT", "", "MAX_TEXT_WIDTH", "plasmovoice-forge-1.20.4"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

