/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.mod.entity;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Scoreboard;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.slib.api.permission.PermissionTristate;
import su.plo.slib.api.server.McServerLib;
import su.plo.slib.api.server.entity.McServerEntity;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.slib.mod.channel.ByteArrayCodec;
import su.plo.slib.mod.channel.ByteArrayPayload;
import su.plo.slib.mod.channel.ModChannelManager;
import su.plo.slib.mod.chat.ComponentTextConverter;
import su.plo.slib.mod.entity.ModServerEntity;
import su.plo.slib.mod.extension.GameProfileKt;
import su.plo.slib.mod.extension.ScoreboardKt;
import su.plo.slib.permission.PermissionSupplier;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.SetsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u001f\u0010 \u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\u0004\b\"\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010(\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010-R\u0014\u00100\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0014\u00101\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010-R\"\u00102\u001a\u00020\u000e8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u0010*\"\u0004\b5\u00106R \u00108\u001a\b\u0012\u0004\u0012\u00020\u000e078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u001c\u0010=\u001a\u0004\u0018\u00010<8VX\u0096\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lsu/plo/slib/mod/entity/ModServerPlayer;", "Lsu/plo/slib/mod/entity/ModServerEntity;", "Lnet/minecraft/server/level/ServerPlayer;", "Lsu/plo/slib/api/server/entity/player/McServerPlayer;", "Lsu/plo/slib/api/server/McServerLib;", "minecraftServer", "Lsu/plo/slib/permission/PermissionSupplier;", "permissions", "player", "<init>", "(Lsu/plo/slib/api/server/McServerLib;Lsu/plo/slib/permission/PermissionSupplier;Lnet/minecraft/server/level/ServerPlayer;)V", "", "canSee", "(Lsu/plo/slib/api/server/entity/player/McServerPlayer;)Z", "", "permission", "Lsu/plo/slib/api/permission/PermissionTristate;", "getPermission", "(Ljava/lang/String;)Lsu/plo/slib/api/permission/PermissionTristate;", "hasPermission", "(Ljava/lang/String;)Z", "Lsu/plo/slib/api/chat/component/McTextComponent;", "reason", "", "kick", "(Lsu/plo/slib/api/chat/component/McTextComponent;)V", "text", "sendActionBar", "sendMessage", "channel", "", "data", "sendPacket", "(Ljava/lang/String;[B)V", "addChannel", "Lsu/plo/slib/api/server/McServerLib;", "Lsu/plo/slib/permission/PermissionSupplier;", "Lsu/plo/slib/api/entity/player/McGameProfile;", "getGameProfile", "()Lsu/plo/slib/api/entity/player/McGameProfile;", "gameProfile", "getName", "()Ljava/lang/String;", "name", "isSpectator", "()Z", "isSneaking", "getHasLabelScoreboard", "hasLabelScoreboard", "isOnline", "language", "Ljava/lang/String;", "getLanguage", "setLanguage", "(Ljava/lang/String;)V", "", "registeredChannels", "Ljava/util/Set;", "getRegisteredChannels", "()Ljava/util/Set;", "Lsu/plo/slib/api/server/entity/McServerEntity;", "spectatorTarget", "Lsu/plo/slib/api/server/entity/McServerEntity;", "getSpectatorTarget", "()Lsu/plo/slib/api/server/entity/McServerEntity;", "slib-neoforge-1.21.2"})
public final class ModServerPlayer
extends ModServerEntity<ServerPlayer>
implements McServerPlayer {
    @NotNull
    private final McServerLib minecraftServer;
    @NotNull
    private final PermissionSupplier permissions;
    @NotNull
    private String language;
    @NotNull
    private final Set<String> registeredChannels;
    @Nullable
    private final McServerEntity spectatorTarget;

    public ModServerPlayer(@NotNull McServerLib minecraftServer, @NotNull PermissionSupplier permissions, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter(minecraftServer, "minecraftServer");
        Intrinsics.checkNotNullParameter(permissions, "permissions");
        Intrinsics.checkNotNullParameter(player, "player");
        super(minecraftServer, (Entity)player);
        this.minecraftServer = minecraftServer;
        this.permissions = permissions;
        this.language = "en_us";
        CopyOnWriteArraySet copyOnWriteArraySet = Sets.newCopyOnWriteArraySet();
        Intrinsics.checkNotNullExpressionValue(copyOnWriteArraySet, "newCopyOnWriteArraySet(...)");
        this.registeredChannels = copyOnWriteArraySet;
    }

    @Override
    @NotNull
    public McGameProfile getGameProfile() {
        GameProfile gameProfile = ((ServerPlayer)this.getInstance()).getGameProfile();
        Intrinsics.checkNotNullExpressionValue(gameProfile, "getGameProfile(...)");
        return GameProfileKt.toMcGameProfile(gameProfile);
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((ServerPlayer)this.getInstance()).getGameProfile().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    public boolean isSpectator() {
        return ((ServerPlayer)this.getInstance()).isSpectator();
    }

    @Override
    public boolean isSneaking() {
        return ((ServerPlayer)this.getInstance()).isDescending();
    }

    @Override
    public boolean getHasLabelScoreboard() {
        ServerScoreboard serverScoreboard = ((ServerPlayer)this.getInstance()).serverLevel().getScoreboard();
        Intrinsics.checkNotNullExpressionValue(serverScoreboard, "getScoreboard(...)");
        return ScoreboardKt.getObjectiveBelowName((Scoreboard)serverScoreboard) != null;
    }

    @Override
    public boolean isOnline() {
        return !((ServerPlayer)this.getInstance()).hasDisconnected();
    }

    @Override
    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.language = string;
    }

    @NotNull
    public Set<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    @Override
    @Nullable
    public McServerEntity getSpectatorTarget() {
        if (((ServerPlayer)this.getInstance()).getCamera() == this.getInstance()) {
            return null;
        }
        if (this.spectatorTarget == null || !((ServerPlayer)this.getInstance()).getCamera().equals(this.spectatorTarget.getInstance())) {
            Entity entity = ((ServerPlayer)this.getInstance()).getCamera();
            Intrinsics.checkNotNullExpressionValue(entity, "getCamera(...)");
            return this.minecraftServer.getEntityByInstance(entity);
        }
        return this.spectatorTarget;
    }

    @Override
    public boolean canSee(@NotNull McServerPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ServerPlayer serverPlayer = (ServerPlayer)player.getInstance();
        return serverPlayer.isSpectator() ? ((ServerPlayer)this.getInstance()).isSpectator() : true;
    }

    @Override
    @NotNull
    public PermissionTristate getPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        return this.permissions.getPermission(this.getInstance(), permission);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        return this.permissions.hasPermission(this.getInstance(), permission);
    }

    @Override
    public void kick(@NotNull McTextComponent reason) {
        Intrinsics.checkNotNullParameter(reason, "reason");
        String json = this.minecraftServer.getTextConverter().convertToJson(this, reason);
        Component component = ComponentTextConverter.INSTANCE.convertFromJson(json);
        ((ServerPlayer)this.getInstance()).connection.disconnect(component);
    }

    @Override
    public void sendActionBar(@NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(text, "text");
        String json = this.minecraftServer.getTextConverter().convertToJson(this, text);
        Component component = ComponentTextConverter.INSTANCE.convertFromJson(json);
        ((ServerPlayer)this.getInstance()).connection.send((Packet)new ClientboundSetActionBarTextPacket(component));
    }

    @Override
    public void sendMessage(@NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(text, "text");
        String json = this.minecraftServer.getTextConverter().convertToJson(this, text);
        Component component = ComponentTextConverter.INSTANCE.convertFromJson(json);
        ((ServerPlayer)this.getInstance()).sendSystemMessage(component);
    }

    @Override
    public void sendPacket(@NotNull String channel, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(data, "data");
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)channel);
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Invalid channel key");
        }
        ResourceLocation channelKey = resourceLocation;
        ServerGamePacketListenerImpl serverGamePacketListenerImpl = ((ServerPlayer)this.getInstance()).connection;
        Intrinsics.checkNotNull(serverGamePacketListenerImpl, "null cannot be cast to non-null type net.neoforged.neoforge.common.extensions.ICommonPacketListener");
        if (!NetworkRegistry.hasChannel((ICommonPacketListener)((ICommonPacketListener)serverGamePacketListenerImpl), (ResourceLocation)channelKey)) {
            NetworkRegistry.onMinecraftRegister((Connection)((ServerPlayer)this.getInstance()).connection.getConnection(), SetsKt.setOf(channelKey));
        }
        ByteArrayCodec codec = ModChannelManager.Companion.getOrRegisterCodec(channelKey);
        ((ServerPlayer)this.getInstance()).connection.send((CustomPacketPayload)new ByteArrayPayload(codec.getType(), data));
    }

    public final boolean addChannel(@NotNull String channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        return this.getRegisteredChannels().add(channel);
    }
}

