/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.mod.world;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.server.entity.McServerEntity;
import su.plo.slib.api.server.world.McServerWorld;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00028\u0000\"\u0004\b\u0000\u0010\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lsu/plo/slib/mod/world/ModServerWorld;", "Lsu/plo/slib/api/server/world/McServerWorld;", "Lnet/minecraft/server/level/ServerLevel;", "level", "<init>", "(Lnet/minecraft/server/level/ServerLevel;)V", "Lsu/plo/slib/api/server/entity/McServerEntity;", "entity", "", "gameEvent", "", "sendGameEvent", "(Lsu/plo/slib/api/server/entity/McServerEntity;Ljava/lang/String;)V", "T", "getInstance", "()Ljava/lang/Object;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "gameEventName", "Lnet/minecraft/core/Holder$Reference;", "Lnet/minecraft/world/level/gameevent/GameEvent;", "parseGameEvent", "(Ljava/lang/String;)Lnet/minecraft/core/Holder$Reference;", "Lnet/minecraft/server/level/ServerLevel;", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "slib-neoforge-1.21.2"})
public final class ModServerWorld
implements McServerWorld {
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final String name;

    public ModServerWorld(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter(level, "level");
        this.level = level;
        String string = this.level.dimension().location().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.name = string;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void sendGameEvent(@NotNull McServerEntity entity, @NotNull String gameEvent) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(gameEvent, "gameEvent");
        Entity serverEntity = (Entity)entity.getInstance();
        this.level.getServer().execute(() -> ModServerWorld.sendGameEvent$lambda$0(this, serverEntity, gameEvent));
    }

    @Override
    public <T> T getInstance() {
        return (T)this.level;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            bl = true;
        } else if (other != null && Intrinsics.areEqual(this.getClass(), other.getClass())) {
            ModServerWorld world = (ModServerWorld)other;
            bl = this.level == world.level;
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.level};
        return Objects.hash(objectArray);
    }

    private final Holder.Reference<GameEvent> parseGameEvent(String gameEventName) {
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)gameEventName);
        Intrinsics.checkNotNull(resourceLocation);
        Object t = BuiltInRegistries.GAME_EVENT.get(resourceLocation).orElseThrow(ModServerWorld::parseGameEvent$lambda$1);
        Intrinsics.checkNotNullExpressionValue(t, "orElseThrow(...)");
        return (Holder.Reference)t;
    }

    private static final void sendGameEvent$lambda$0(ModServerWorld this$0, Entity $serverEntity, String $gameEvent) {
        this$0.level.gameEvent($serverEntity, (Holder)this$0.parseGameEvent($gameEvent), $serverEntity.position());
    }

    private static final IllegalArgumentException parseGameEvent$lambda$1() {
        return new IllegalArgumentException("Invalid game event");
    }
}

