/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.extension;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.entity.LivingEntityRenderState;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.client.ModVoiceClient;
import su.plo.voice.client.extension.CameraKt;
import su.plo.voice.client.mixin.accessor.EntityRendererAccessor;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.SetsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;
import su.plo.voice.libs.kotlin.text.StringsKt;
import su.plo.voice.proto.data.config.PlayerIconVisibility;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a\"\u0010\u0003\u001a\u00020\u0004*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"getObjectiveBelowName", "Lnet/minecraft/world/scores/Objective;", "Lnet/minecraft/world/scores/Scoreboard;", "createEntityRenderState", "Lsu/plo/lib/mod/client/render/entity/LivingEntityRenderState;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "clientPlayer", "Lnet/minecraft/client/player/LocalPlayer;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "pos3dZero", "Lsu/plo/slib/api/position/Pos3d;", "getPlayerIconOffset", "getPlayerIconVisibility", "", "Lsu/plo/voice/proto/data/config/PlayerIconVisibility;", "plasmovoice-neoforge-1.21.4"})
public final class EntityRendererKt {
    @NotNull
    private static final Pos3d pos3dZero = new Pos3d();

    private static final Objective getObjectiveBelowName(Scoreboard $this$getObjectiveBelowName) {
        return $this$getObjectiveBelowName.getDisplayObjective(DisplaySlot.BELOW_NAME);
    }

    @NotNull
    public static final LivingEntityRenderState createEntityRenderState(@NotNull EntityRenderer<?, ?> $this$createEntityRenderState, @NotNull LocalPlayer clientPlayer, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter($this$createEntityRenderState, "<this>");
        Intrinsics.checkNotNullParameter(clientPlayer, "clientPlayer");
        Intrinsics.checkNotNullParameter(entity, "entity");
        Player player = entity instanceof Player ? (Player)entity : null;
        boolean hasScoreboardText = (player != null && (player = player.level()) != null && (player = player.getScoreboard()) != null ? EntityRendererKt.getObjectiveBelowName((Scoreboard)player) : null) != null;
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Intrinsics.checkNotNull(camera);
        double distanceToCameraSquared = CameraKt.position(camera).distanceToSqr(entity.position());
        Component component = entity.getCustomName();
        String customName = component != null ? component.toString() : null;
        Set playerIconVisibility = EntityRendererKt.getPlayerIconVisibility(entity);
        String string = customName;
        boolean shouldHideIcon = string != null ? StringsKt.contains$default((CharSequence)string, "plasmo-voice.hide-all-icons", false, 2, null) : false;
        String string2 = customName;
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, "plasmo-voice.hide-not-installed-icon", false, 2, null) : false;
        if (bl) {
            playerIconVisibility = EnumSet.copyOf(SetsKt.plus(playerIconVisibility, (Iterable)SetsKt.setOf(PlayerIconVisibility.HIDE_NOT_INSTALLED)));
        }
        Pos3d playerIconOffset = EntityRendererKt.getPlayerIconOffset(entity);
        EntityRendererAccessor rendererAccessor = (EntityRendererAccessor)$this$createEntityRenderState;
        int n = entity.getId();
        UUID uUID = entity.getUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUUID(...)");
        EntityType entityType = entity.getType();
        Intrinsics.checkNotNullExpressionValue(entityType, "getType(...)");
        LivingEntityRenderState entityRenderState = new LivingEntityRenderState(n, uUID, entityType, entity.position().x(), entity.position().y(), entity.position().z(), distanceToCameraSquared, entity.isInvisibleTo((Player)clientPlayer), entity.isDiscrete(), rendererAccessor.plasmovoice_shouldShowName((Entity)entity, distanceToCameraSquared) ? entity.getDisplayName() : null, new Vec3(playerIconOffset.getX(), (double)entity.getBbHeight() + playerIconOffset.getY(), playerIconOffset.getZ()), hasScoreboardText, shouldHideIcon, playerIconVisibility);
        return entityRenderState;
    }

    private static final Pos3d getPlayerIconOffset(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return pos3dZero;
        }
        Optional<ServerInfo> optional = ModVoiceClient.INSTANCE.getServerInfo();
        Intrinsics.checkNotNullExpressionValue(optional, "getServerInfo(...)");
        ServerInfo serverInfo = OptionalsKt.getOrNull(optional);
        if (serverInfo == null) {
            return pos3dZero;
        }
        ServerInfo serverInfo2 = serverInfo;
        Pos3d pos3d = serverInfo2.getPlayerIconOffset();
        Intrinsics.checkNotNullExpressionValue(pos3d, "getPlayerIconOffset(...)");
        return pos3d;
    }

    private static final Set<PlayerIconVisibility> getPlayerIconVisibility(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return PlayerIconVisibility.Companion.none();
        }
        Optional<ServerInfo> optional = ModVoiceClient.INSTANCE.getServerInfo();
        Intrinsics.checkNotNullExpressionValue(optional, "getServerInfo(...)");
        ServerInfo serverInfo = OptionalsKt.getOrNull(optional);
        if (serverInfo == null) {
            return PlayerIconVisibility.Companion.none();
        }
        ServerInfo serverInfo2 = serverInfo;
        Set<PlayerIconVisibility> set = serverInfo2.getPlayerIconVisibility();
        Intrinsics.checkNotNullExpressionValue(set, "getPlayerIconVisibility(...)");
        return set;
    }
}

