/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import java.awt.Color;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11876;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.Inputs;
import su.plo.lib.mod.client.gui.narration.NarrationOutput;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;

public class TextFieldWidget
extends GuiAbstractWidget {
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter;
    private BiFunction<String, Integer, McTextComponent> formatter;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean editable = true;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean shiftPressed;
    private int displayPosition;
    private int cursorPosition;
    private int highlightPosition;
    private Color textColor = new Color(0xE0E0E0);
    private Color textColorUneditable = new Color(0x707070);
    @Nullable
    private String suggestion;

    public TextFieldWidget(int x, int y, int width, int height, @NotNull McTextComponent text) {
        super(x, y, width, height, text);
        this.filter = Objects::nonNull;
        this.formatter = (string, integer) -> McTextComponent.literal(string);
    }

    @Override
    public void updateNarration(@NotNull NarrationOutput narrationOutput) {
        narrationOutput.add(NarrationOutput.Type.TITLE, McTextComponent.translatable("narration.edit_box", this.getValue()));
    }

    @Override
    public boolean keyPressed(int keyCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Inputs.hasShiftDown();
        if (Inputs.isSelectAll(keyCode, modifiers)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Inputs.isCopy(keyCode, modifiers)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (Inputs.isPaste(keyCode, modifiers)) {
            if (this.isEditable()) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (Inputs.isCut(keyCode, modifiers)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (this.isEditable()) {
                this.insertText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(modifiers, -1);
                    this.shiftPressed = Inputs.hasShiftDown();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(modifiers, 1);
                    this.shiftPressed = Inputs.hasShiftDown();
                }
                return true;
            }
            case 262: {
                if (Inputs.hasControlDown(modifiers)) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Inputs.hasControlDown(modifiers)) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    @Override
    public boolean charTyped(char typedChar, int modifiers) {
        if (!this.canConsumeInput() || !TextFieldWidget.isAllowedChatCharacter(typedChar)) {
            return false;
        }
        if (this.isEditable()) {
            this.insertText(Character.toString(typedChar));
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocused(mouseOver);
        }
        if (this.isFocused() && mouseOver && this.isValidClickButton(button)) {
            int inputX = class_3532.method_15357((double)mouseX) - this.x;
            if (this.bordered) {
                inputX -= 4;
            }
            String visibileString = RenderUtil.stringToWidth(this.value.substring(this.displayPosition), this.getInnerWidth());
            this.moveCursorTo(RenderUtil.stringToWidth(visibileString, inputX, false, "").length() + this.displayPosition);
            return true;
        }
        return false;
    }

    @Override
    public boolean changeFocus(boolean lookForwards) {
        return this.visible && this.isEditable() && super.changeFocus(lookForwards);
    }

    @Override
    protected void onFocusedChanged(boolean focused) {
        if (focused) {
            this.frame = 0;
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && super.isMouseOver(mouseX, mouseY);
    }

    @Override
    public void renderButton(@NotNull GuiRenderContext context, int mouseX, int mouseY, float delta) {
        String visibleText;
        Color color;
        if (!this.isVisible()) {
            return;
        }
        if (this.isBordered()) {
            color = this.isFocused() ? Colors.WHITE : Colors.GRAY;
            GuiWidgetTexture sprite = this.isFocused() ? GuiWidgetTexture.TEXT_FIELD_ACTIVE : GuiWidgetTexture.TEXT_FIELD;
            context.blitSprite(sprite, this.x, this.y, 0, 0, this.width / 2, this.height);
            context.blitSprite(sprite, this.x + this.width / 2, this.y, sprite.getSpriteWidth() - this.width / 2, 0, this.width / 2, this.height);
        }
        color = this.isEditable() ? this.textColor : this.textColorUneditable;
        int cursorIndex = this.cursorPosition - this.displayPosition;
        int selectionEnd = this.highlightPosition - this.displayPosition;
        String text = this.isFocused() ? RenderUtil.stringToWidth(this.value.substring(this.displayPosition), this.getInnerWidth(), false, "") : RenderUtil.stringToWidth(this.value.substring(this.displayPosition), this.getInnerWidth());
        boolean isCursorVisible = cursorIndex >= 0 && cursorIndex <= text.length();
        boolean isFocused = this.isFocused() && this.frame / 6 % 2 == 0 && isCursorVisible;
        int textX = this.bordered ? this.x + 5 : this.x;
        int textY = this.bordered ? this.y + (this.height - 8) / 2 : this.y;
        int currentX = textX;
        if (selectionEnd > text.length()) {
            selectionEnd = text.length();
        }
        String string = visibleText = isCursorVisible ? text.substring(0, cursorIndex) : text;
        if (!text.isEmpty()) {
            currentX = RenderUtil.getStringX(RenderUtil.getFormattedString(this.formatter.apply(visibleText, this.displayPosition)), textX, true);
        }
        boolean shouldDrawCursor = this.cursorPosition < this.value.length() || this.value.length() >= this.maxLength;
        int selectionX = currentX;
        if (!isCursorVisible) {
            selectionX = cursorIndex > 0 ? textX + this.width : textX;
        } else if (shouldDrawCursor) {
            selectionX = currentX - 1;
            --currentX;
        }
        if (selectionEnd != cursorIndex) {
            int selectionWidth = textX + RenderUtil.getStringWidth(text.substring(0, selectionEnd));
            this.renderHighlight(context, selectionX, textY - 1, selectionWidth - 1, textY + 1 + 9);
        }
        if (!text.isEmpty()) {
            context.drawString(this.formatter.apply(visibleText, this.displayPosition), textX, textY, color);
        }
        if (!text.isEmpty() && isCursorVisible && cursorIndex < text.length()) {
            context.drawString(this.formatter.apply(text.substring(cursorIndex), this.cursorPosition), currentX, textY, color);
        }
        if (!shouldDrawCursor && this.suggestion != null) {
            context.drawString(this.suggestion, selectionX - 1, textY, new Color(0x808080));
        }
        if (text.isEmpty() && !this.isFocused()) {
            context.drawString(this.getText(), textX, textY, Colors.BLACK);
        }
        if (isFocused) {
            if (shouldDrawCursor) {
                context.fill(selectionX, textY - 1, selectionX + 1, textY + 1 + 9, new Color(0xD0D0D0));
            } else {
                context.drawString("_", selectionX, textY, color);
            }
        }
        if (this.isHovered()) {
            context.requestCursor(class_11876.field_62453);
        }
    }

    private void renderHighlight(@NotNull GuiRenderContext context, int x0, int y0, int x1, int y1) {
        if (x0 < x1) {
            int x = x0;
            x0 = x1;
            x1 = x;
        }
        if (y0 < y1) {
            int y = y0;
            y0 = y1;
            y1 = y;
        }
        if (x1 > this.x + this.width) {
            x1 = this.x + this.width;
        }
        if (x0 > this.x + this.width) {
            x0 = this.x + this.width;
        }
        context.fill(x0, y0, x1, y1, new Color(0x4B4BFF));
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.isFocused() && this.isEditable();
    }

    public void tick() {
        ++this.frame;
    }

    public void setValue(String value) {
        if (!this.filter.test(value)) {
            return;
        }
        this.value = value.length() > this.maxLength ? value.substring(0, this.maxLength) : value;
        this.moveCursorToEnd();
        this.setHighlightPos(this.cursorPosition);
        this.onValueChange(value);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.value.length() > maxLength) {
            this.value = this.value.substring(0, maxLength);
            this.onValueChange(this.value);
        }
    }

    public String getHighlighted() {
        int start2 = Math.min(this.cursorPosition, this.highlightPosition);
        int end = Math.max(this.cursorPosition, this.highlightPosition);
        return this.value.substring(start2, end);
    }

    public void insertText(String string) {
        String newValue;
        String filteredText;
        int filteredTextLength;
        int startPosition = Math.min(this.cursorPosition, this.highlightPosition);
        int endPosition = Math.max(this.cursorPosition, this.highlightPosition);
        int maxInsertLength = this.maxLength - this.value.length() - (startPosition - endPosition);
        if (maxInsertLength < (filteredTextLength = (filteredText = TextFieldWidget.filterText(string)).length())) {
            filteredText = filteredText.substring(0, maxInsertLength);
            filteredTextLength = maxInsertLength;
        }
        if (this.filter.test(newValue = new StringBuilder(this.value).replace(startPosition, endPosition, filteredText).toString())) {
            this.value = newValue;
            this.setCursorPosition(startPosition + filteredTextLength);
            this.setHighlightPos(this.cursorPosition);
            this.onValueChange(this.value);
        }
    }

    private void deleteText(int modifiers, int offset) {
        if (Inputs.hasControlDown(modifiers)) {
            this.deleteWords(offset);
        } else {
            this.deleteChars(offset);
        }
    }

    public void deleteWords(int offset) {
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPosition != this.cursorPosition) {
            this.insertText("");
        } else {
            this.deleteChars(this.getWordPosition(offset) - this.cursorPosition);
        }
    }

    public void deleteChars(int offset) {
        int endRange;
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPosition != this.cursorPosition) {
            this.insertText("");
            return;
        }
        int cursorPosition = this.getCursorPos(offset);
        int startRange = Math.min(cursorPosition, this.cursorPosition);
        if (startRange == (endRange = Math.max(cursorPosition, this.cursorPosition))) {
            return;
        }
        String newText = new StringBuilder(this.value).delete(startRange, endRange).toString();
        if (this.filter.test(newText)) {
            this.value = newText;
            this.moveCursorTo(startRange);
        }
    }

    public int getWordPosition(int offset) {
        return this.getWordPosition(offset, this.cursorPosition);
    }

    private int getWordPosition(int offset, int cursorPosition) {
        int wordPosition = cursorPosition;
        boolean toLeft = offset < 0;
        int searchLimit = Math.abs(offset);
        for (int index = 0; index < searchLimit; ++index) {
            if (toLeft) {
                while (wordPosition > 0 && this.value.charAt(wordPosition - 1) == ' ') {
                    --wordPosition;
                }
                while (wordPosition > 0 && this.value.charAt(wordPosition - 1) != ' ') {
                    --wordPosition;
                }
                continue;
            }
            int valueLength = this.value.length();
            if ((wordPosition = this.value.indexOf(32, wordPosition)) == -1) {
                wordPosition = valueLength;
                continue;
            }
            while (wordPosition < valueLength && this.value.charAt(wordPosition) == ' ') {
                ++wordPosition;
            }
        }
        return wordPosition;
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = class_3532.method_15340((int)position, (int)0, (int)this.value.length());
    }

    public void moveCursor(int offset) {
        this.moveCursorTo(this.getCursorPos(offset));
    }

    private int getCursorPos(int offset) {
        return TextFieldWidget.offsetByCodepoints(this.value, this.cursorPosition, offset);
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.width - 8 : this.width;
    }

    public int getScreenX(int x) {
        return x > this.value.length() ? this.x : this.x + RenderUtil.getStringWidth(this.value.substring(0, x));
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    public void setHighlightPos(int position) {
        int valueLength = this.value.length();
        this.highlightPosition = class_3532.method_15340((int)position, (int)0, (int)valueLength);
        if (this.displayPosition > valueLength) {
            this.displayPosition = valueLength;
        }
        int innerWidth = this.getInnerWidth();
        String string = RenderUtil.stringToWidth(this.value.substring(this.displayPosition), innerWidth);
        int l = string.length() + this.displayPosition;
        if (this.highlightPosition == this.displayPosition) {
            this.displayPosition -= RenderUtil.stringToWidth(this.value, innerWidth, true).length();
        }
        if (this.highlightPosition > l) {
            this.displayPosition += this.highlightPosition - l;
        } else if (this.highlightPosition <= this.displayPosition) {
            this.displayPosition -= this.displayPosition - this.highlightPosition;
        }
        this.displayPosition = class_3532.method_15340((int)this.displayPosition, (int)0, (int)valueLength);
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public void moveCursorTo(int i) {
        this.setCursorPosition(i);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPosition);
        }
        this.onValueChange(this.value);
    }

    private void onValueChange(String string) {
        if (this.responder != null) {
            this.responder.accept(string);
        }
    }

    @Override
    protected McTextComponent createNarrationMessage() {
        return McTextComponent.translatable("gui.narrate.editBox", this.getText(), this.value);
    }

    public static String filterText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (!TextFieldWidget.isAllowedChatCharacter(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isAllowedChatCharacter(char c) {
        return c != '\u00a7' && c >= ' ' && c != '\u007f';
    }

    public static int offsetByCodepoints(String string, int cursorPosition, int offset) {
        int stringLength = string.length();
        if (offset >= 0) {
            for (int i = 0; cursorPosition < stringLength && i < offset; ++i) {
                if (!Character.isHighSurrogate(string.charAt(cursorPosition++)) || cursorPosition >= stringLength || !Character.isLowSurrogate(string.charAt(cursorPosition))) continue;
                ++cursorPosition;
            }
        } else {
            for (int i = offset; cursorPosition > 0 && i < 0; ++i) {
                if (!Character.isLowSurrogate(string.charAt(--cursorPosition)) || cursorPosition <= 0 || !Character.isHighSurrogate(string.charAt(cursorPosition - 1))) continue;
                --cursorPosition;
            }
        }
        return cursorPosition;
    }

    public void setResponder(@Nullable Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFilter(Predicate<String> filter2) {
        this.filter = filter2;
    }

    public void setFormatter(BiFunction<String, Integer, McTextComponent> formatter) {
        this.formatter = formatter;
    }

    public String getValue() {
        return this.value;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bordered) {
        this.bordered = bordered;
    }

    public boolean isCanLoseFocus() {
        return this.canLoseFocus;
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setTextColorUneditable(Color textColorUneditable) {
        this.textColorUneditable = textColorUneditable;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }
}

