/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.client.event.audio.capture;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.audio.capture.AudioCapture;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.event.EventCancellableBase;

public final class AudioCaptureProcessedEvent
extends EventCancellableBase {
    private final AudioCapture capture;
    private final InputDevice device;
    private final short[] rawSamples;
    private final ProcessedSamples processed;

    public AudioCaptureProcessedEvent(@NotNull AudioCapture capture, @NotNull InputDevice device, short[] rawSamples, @NotNull ProcessedSamples processed) {
        this.capture = (AudioCapture)Preconditions.checkNotNull((Object)capture, (Object)"capture");
        this.device = (InputDevice)Preconditions.checkNotNull((Object)device, (Object)"device");
        this.processed = (ProcessedSamples)Preconditions.checkNotNull((Object)processed, (Object)"processed");
        this.rawSamples = (short[])Preconditions.checkNotNull((Object)rawSamples, (Object)"rawSamples");
    }

    public AudioCapture getCapture() {
        return this.capture;
    }

    public InputDevice getDevice() {
        return this.device;
    }

    public short[] getRawSamples() {
        return this.rawSamples;
    }

    public ProcessedSamples getProcessed() {
        return this.processed;
    }

    public static interface ProcessedSamples {
        default public short[] getSamples(boolean stereo) {
            if (stereo) {
                return this.getStereo();
            }
            return this.getMono();
        }

        public short[] getMono();

        public short[] getStereo();
    }
}

