/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.particle;

import java.util.Random;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_3999;
import net.minecraft.class_4587;

public abstract class Particle2D {
    private static final class_238 EMPTY_BOUNDING_BOX = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected double prevPosX;
    protected double prevPosY;
    protected double x;
    protected double y;
    protected double velocityX;
    protected double velocityY;
    private class_238 boundingBox = EMPTY_BOUNDING_BOX;
    protected boolean onGround;
    protected boolean collidesWithWorld = true;
    private boolean field_21507;
    protected boolean dead;
    protected float spacingXZ = 0.6f;
    protected float spacingY = 1.8f;
    protected final Random random = new Random();
    protected int age;
    protected int maxAge;
    protected float gravityStrength;
    protected float colorRed = 1.0f;
    protected float colorGreen = 1.0f;
    protected float colorBlue = 1.0f;
    protected float colorAlpha = 1.0f;
    protected float field_28786 = 0.98f;
    protected boolean field_28787 = false;

    protected Particle2D(double x, double y) {
        this.setBoundingBoxSpacing(0.2f, 0.2f);
        this.setPos(x, y);
        this.prevPosX = x;
        this.prevPosY = y;
        this.maxAge = (int)(4.0f / (this.random.nextFloat() * 0.9f + 0.1f));
    }

    public Particle2D(double x, double y, double velocityX, double velocityY) {
        this(x, y);
        this.velocityX = velocityX + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.velocityY = velocityY + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        double d = (Math.random() + Math.random() + 1.0) * (double)0.15f;
        double e = Math.sqrt(this.velocityX * this.velocityX + this.velocityY * this.velocityY);
        this.velocityX = this.velocityX / e * d * (double)0.4f;
        this.velocityY = this.velocityY / e * d * (double)0.4f + (double)0.1f;
    }

    public Particle2D move(float speed) {
        this.velocityX *= (double)speed;
        this.velocityY = (this.velocityY - (double)0.1f) * (double)speed + (double)0.1f;
        return this;
    }

    public void setVelocity(double velocityX, double velocityY) {
        this.velocityX = velocityX;
        this.velocityY = velocityY;
    }

    public Particle2D scale(float scale) {
        this.setBoundingBoxSpacing(0.2f * scale, 0.2f * scale);
        return this;
    }

    public void setColor(float red, float green, float blue) {
        this.colorRed = red;
        this.colorGreen = green;
        this.colorBlue = blue;
    }

    protected void setColorAlpha(float alpha) {
        this.colorAlpha = alpha;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void tick() {
        this.prevPosX = this.x;
        this.prevPosY = this.y;
        if (this.age++ >= this.maxAge) {
            this.markDead();
        } else {
            this.velocityY += 0.04 * (double)this.gravityStrength;
            this.move(this.velocityX, this.velocityY);
            if (this.field_28787 && this.y == this.prevPosY) {
                this.velocityX *= 1.1;
            }
            this.velocityX *= (double)this.field_28786;
            this.velocityY *= (double)this.field_28786;
            if (this.onGround) {
                this.velocityX *= (double)0.7f;
            }
        }
    }

    public abstract void buildGeometry(class_4587 var1, class_287 var2, float var3);

    public abstract class_3999 getType();

    public String toString() {
        String var10000 = this.getClass().getSimpleName();
        return var10000 + ", Pos (" + this.x + "," + this.y + "), RGBA (" + this.colorRed + "," + this.colorGreen + "," + this.colorBlue + "," + this.colorAlpha + "), Age " + this.age;
    }

    public void markDead() {
        this.dead = true;
    }

    protected void setBoundingBoxSpacing(float spacingXZ, float spacingY) {
        if (spacingXZ != this.spacingXZ || spacingY != this.spacingY) {
            this.spacingXZ = spacingXZ;
            this.spacingY = spacingY;
            class_238 box = this.getBoundingBox();
            double d = (box.field_1323 + box.field_1320 - (double)spacingXZ) / 2.0;
            double e = (box.field_1321 + box.field_1324 - (double)spacingXZ) / 2.0;
            this.setBoundingBox(new class_238(d, box.field_1322, e, d + (double)this.spacingXZ, box.field_1322 + (double)this.spacingY, e + (double)this.spacingXZ));
        }
    }

    public void setPos(double x, double y) {
        this.x = x;
        this.y = y;
        float f = this.spacingXZ / 2.0f;
        float g = this.spacingY;
        this.setBoundingBox(new class_238(x - (double)f, y, 0.0 - (double)f, x + (double)f, y + (double)g, 0.0 + (double)f));
    }

    public void move(double dx, double dy) {
        if (!this.field_21507) {
            if (dx != 0.0 || dy != 0.0) {
                this.setBoundingBox(this.getBoundingBox().method_989(dx, dy, 0.0));
                this.repositionFromBoundingBox();
            }
            if (Math.abs(dy) >= (double)1.0E-5f && Math.abs(dy) < (double)1.0E-5f) {
                this.field_21507 = true;
            }
        }
    }

    protected void repositionFromBoundingBox() {
        class_238 box = this.getBoundingBox();
        this.x = (box.field_1323 + box.field_1320) / 2.0;
        this.y = box.field_1322;
    }

    protected int getBrightness(float tint) {
        return 15;
    }

    public boolean isAlive() {
        return !this.dead;
    }

    public class_238 getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(class_238 boundingBox) {
        this.boundingBox = boundingBox;
    }
}

