/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.cape;

import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.render.texture.ModPlayerSkins;
import su.plo.voice.client.meta.PlasmoVoiceMeta;
import su.plo.voice.client.meta.developer.Developer;
import su.plo.voice.client.render.cape.SkinManagerAccessor;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102\u0006\u0010\r\u001a\u00020\u0006H\u0002R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lsu/plo/voice/client/render/cape/DeveloperCapeManager;", "", "<init>", "()V", "loadedCapes", "Lcom/google/common/cache/Cache;", "", "Ljava/util/function/Supplier;", "Lnet/minecraft/resources/ResourceLocation;", "clearLoadedCapes", "", "hasCape", "", "playerName", "getCapeLocation", "getCapeLocationAsync", "Ljava/util/concurrent/CompletableFuture;", "plasmovoice-fabric-1.16.5"})
@SourceDebugExtension(value={"SMAP\nDeveloperCapeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeveloperCapeManager.kt\nsu/plo/voice/client/render/cape/DeveloperCapeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1755#2,3:122\n*S KotlinDebug\n*F\n+ 1 DeveloperCapeManager.kt\nsu/plo/voice/client/render/cape/DeveloperCapeManager\n*L\n66#1:122,3\n*E\n"})
public final class DeveloperCapeManager {
    @NotNull
    public static final DeveloperCapeManager INSTANCE = new DeveloperCapeManager();
    @NotNull
    private static final Cache<String, Supplier<Supplier<class_2960>>> loadedCapes;

    private DeveloperCapeManager() {
    }

    public final void clearLoadedCapes() {
        loadedCapes.invalidateAll();
        loadedCapes.cleanUp();
    }

    public final boolean hasCape(@NotNull String playerName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(playerName, "playerName");
            Iterable $this$any$iv = PlasmoVoiceMeta.Companion.getMETA().getDevelopers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Developer developer = (Developer)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(developer.getName(), playerName) || developer.getAliases().contains(playerName))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final class_2960 getCapeLocation(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        return (class_2960)((Supplier)((Supplier)loadedCapes.get((Object)playerName, () -> DeveloperCapeManager.getCapeLocation$lambda$4(playerName))).get()).get();
    }

    private final CompletableFuture<class_2960> getCapeLocationAsync(String playerName) {
        CompletableFuture<class_2960> completableFuture = CompletableFuture.supplyAsync(() -> DeveloperCapeManager.getCapeLocationAsync$lambda$6(playerName));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    private static final class_2960 getCapeLocation$lambda$4$lambda$3$lambda$1() {
        return null;
    }

    private static final class_2960 getCapeLocation$lambda$4$lambda$3$lambda$2(CompletableFuture $capeLocation) {
        return $capeLocation.getNow(null);
    }

    private static final Supplier getCapeLocation$lambda$4$lambda$3(String $playerName) {
        if (!INSTANCE.hasCape($playerName)) {
            return DeveloperCapeManager::getCapeLocation$lambda$4$lambda$3$lambda$1;
        }
        CompletableFuture<class_2960> capeLocation = INSTANCE.getCapeLocationAsync($playerName);
        return () -> DeveloperCapeManager.getCapeLocation$lambda$4$lambda$3$lambda$2(capeLocation);
    }

    private static final Supplier getCapeLocation$lambda$4(String $playerName) {
        return (Supplier)Suppliers.memoize(() -> DeveloperCapeManager.getCapeLocation$lambda$4$lambda$3($playerName));
    }

    private static final void getCapeLocationAsync$lambda$6$lambda$5() {
    }

    private static final class_2960 getCapeLocationAsync$lambda$6(String $playerName) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("developer_capes/");
        String string2 = $playerName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        class_2960 class_29602 = ResourceLocationUtil.tryBuild("plasmovoice", stringBuilder.append(string2).toString());
        Intrinsics.checkNotNull(class_29602);
        class_2960 capeLocation = class_29602;
        URL url = new URL("https://plasmovoice.com/capes/" + $playerName + ".png");
        MinecraftProfileTexture texture = new MinecraftProfileTexture(url.toString(), (Map)new HashMap());
        String string3 = Hashing.sha1().hashUnencodedChars((CharSequence)texture.getHash()).toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        String string4 = string3;
        class_1071 class_10712 = class_310.method_1551().method_1582();
        Intrinsics.checkNotNull(class_10712, "null cannot be cast to non-null type su.plo.voice.client.render.cape.SkinManagerAccessor");
        File skinsFolder = ((SkinManagerAccessor)class_10712).getSkinsCacheFolder();
        if (string4.length() > 2) {
            String string5 = string4.substring(0, 2);
            string = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
        } else {
            string = "xx";
        }
        File hashFolder = new File(skinsFolder, string);
        File capeFile = new File(hashFolder, string4);
        if (capeFile.exists() && System.currentTimeMillis() - capeFile.lastModified() > 86400000L) {
            capeFile.delete();
        }
        class_310.method_1551().method_1531().method_4616(capeLocation, (class_1044)new class_1046(capeFile, texture.getUrl(), ModPlayerSkins.getDefaultSkin(UUID.randomUUID()), false, DeveloperCapeManager::getCapeLocationAsync$lambda$6$lambda$5));
        return capeLocation;
    }

    static {
        Cache cache2 = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue(cache2, "build(...)");
        loadedCapes = cache2;
    }
}

