/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.serverbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerStatePacket;
import su.plo.voice.proto.packets.tcp.serverbound.ServerPacketTcpHandler;

public final class PlayerInfoPacket
extends PlayerStatePacket {
    private String minecraftVersion;
    private String version;
    private byte[] publicKey;

    public PlayerInfoPacket(@NonNull String minecraftVersion, @NonNull String version, @NonNull byte[] publicKey, boolean voiceDisabled, boolean microphoneDisabled) {
        super(voiceDisabled, microphoneDisabled);
        if (minecraftVersion == null) {
            throw new NullPointerException("minecraftVersion is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.minecraftVersion = minecraftVersion;
        this.version = version;
        this.publicKey = publicKey;
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        super.read(in);
        this.minecraftVersion = in.readUTF();
        this.version = in.readUTF();
        int length = PacketUtil.readSafeInt(in, 1, 2048);
        this.publicKey = new byte[length];
        in.readFully(this.publicKey);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF((String)Preconditions.checkNotNull((Object)this.minecraftVersion));
        out.writeUTF((String)Preconditions.checkNotNull((Object)this.version));
        Preconditions.checkNotNull((Object)this.publicKey);
        out.writeInt(this.publicKey.length);
        out.write(this.publicKey);
    }

    @Override
    public void handle(ServerPacketTcpHandler handler) {
        handler.handle(this);
    }

    public PlayerInfoPacket() {
    }

    @Override
    public String toString() {
        return "PlayerInfoPacket(super=" + super.toString() + ", minecraftVersion=" + this.getMinecraftVersion() + ", version=" + this.getVersion() + ", publicKey=" + Arrays.toString(this.getPublicKey()) + ")";
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }
}

