/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.client.time.TimeSupplier;
import su.plo.voice.client.audio.source.JitterBuffer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsu/plo/voice/client/audio/source/AdaptiveJitterBuffer;", "Lsu/plo/voice/client/audio/source/JitterBuffer;", "timeSupplier", "Lsu/plo/voice/api/client/time/TimeSupplier;", "packetDelay", "", "<init>", "(Lsu/plo/voice/api/client/time/TimeSupplier;I)V", "packetDelayMillis", "", "queue", "Ljava/util/Queue;", "Lsu/plo/voice/client/audio/source/AdaptiveJitterBuffer$PacketWithArrivalTime;", "endPacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "firstPacketArrival", "Ljava/lang/Long;", "firstSequenceNumber", "lastPacketArrival", "jitterEstimate", "", "adaptiveDelayMillis", "offer", "", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "scheduledPlaybackTime", "sequenceNumber", "arrivalTime", "poll", "Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "isEmpty", "", "reset", "PacketWithArrivalTime", "plasmovoice-fabric-1.19.3"})
public final class AdaptiveJitterBuffer
implements JitterBuffer {
    @NotNull
    private final TimeSupplier timeSupplier;
    private final long packetDelayMillis;
    @NotNull
    private final Queue<PacketWithArrivalTime> queue;
    @Nullable
    private SourceAudioEndPacket endPacket;
    @Nullable
    private Long firstPacketArrival;
    @Nullable
    private Long firstSequenceNumber;
    @Nullable
    private Long lastPacketArrival;
    private double jitterEstimate;
    private long adaptiveDelayMillis;

    public AdaptiveJitterBuffer(@NotNull TimeSupplier timeSupplier, int packetDelay) {
        Intrinsics.checkNotNullParameter(timeSupplier, "timeSupplier");
        this.timeSupplier = timeSupplier;
        this.packetDelayMillis = (long)packetDelay * 20L;
        this.queue = packetDelay <= 1 ? (Queue)new LinkedBlockingQueue() : (Queue)new PriorityBlockingQueue(packetDelay * 2, new Comparator(){

            public final int compare(T a, T b) {
                PacketWithArrivalTime it = (PacketWithArrivalTime)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getPacket().getSequenceNumber());
                it = (PacketWithArrivalTime)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getPacket().getSequenceNumber());
            }
        });
        this.adaptiveDelayMillis = this.packetDelayMillis;
    }

    @Override
    public void offer(@NotNull SourceAudioPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (this.endPacket != null) {
            long l = packet.getSequenceNumber();
            SourceAudioEndPacket sourceAudioEndPacket = this.endPacket;
            Intrinsics.checkNotNull(sourceAudioEndPacket);
            if (l > sourceAudioEndPacket.getSequenceNumber()) {
                this.endPacket = null;
                this.firstPacketArrival = null;
                this.firstSequenceNumber = null;
                this.lastPacketArrival = null;
            }
        }
        long arrivalTime = this.timeSupplier.getCurrentTimeMillis();
        this.queue.offer(new PacketWithArrivalTime(new JitterBuffer.SourceAudioPacketWrapper(packet), arrivalTime, this.scheduledPlaybackTime(packet.getSequenceNumber(), arrivalTime)));
    }

    @Override
    public void offer(@NotNull SourceAudioEndPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.endPacket = packet;
        long arrivalTime = this.timeSupplier.getCurrentTimeMillis();
        this.queue.offer(new PacketWithArrivalTime(new JitterBuffer.SourceAudioEndPacketWrapper(packet), arrivalTime, this.scheduledPlaybackTime(packet.getSequenceNumber(), arrivalTime)));
    }

    private final long scheduledPlaybackTime(long sequenceNumber, long arrivalTime) {
        Long l = this.lastPacketArrival;
        if (l != null) {
            long last2 = ((Number)l).longValue();
            boolean bl = false;
            long transit = arrivalTime - last2;
            long delta = Math.abs(transit - (long)20);
            this.jitterEstimate += ((double)delta - this.jitterEstimate) / 16.0;
            this.adaptiveDelayMillis = (long)(Math.rint(this.jitterEstimate / 20.0) * (double)20);
        }
        this.lastPacketArrival = arrivalTime;
        if (this.firstSequenceNumber == null) {
            this.firstPacketArrival = arrivalTime;
            this.firstSequenceNumber = sequenceNumber;
        }
        Long l2 = this.firstSequenceNumber;
        long sequenceOffset = sequenceNumber - (l2 != null ? l2 : sequenceNumber);
        Long l3 = this.firstPacketArrival;
        long scheduledPlaybackTime = (l3 != null ? l3 : arrivalTime) + this.packetDelayMillis + sequenceOffset * (long)20;
        return scheduledPlaybackTime;
    }

    @Override
    @Nullable
    public JitterBuffer.PacketWithSequenceNumber poll() {
        PacketWithArrivalTime packetWithArrivalTime = this.queue.peek();
        if (packetWithArrivalTime == null) {
            return null;
        }
        PacketWithArrivalTime next = packetWithArrivalTime;
        if (this.timeSupplier.getCurrentTimeMillis() >= next.getScheduledPlaybackTime() + this.adaptiveDelayMillis) {
            return this.queue.poll().getPacket();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void reset() {
        this.firstSequenceNumber = null;
        this.firstPacketArrival = null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lsu/plo/voice/client/audio/source/AdaptiveJitterBuffer$PacketWithArrivalTime;", "", "packet", "Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "arrivalTime", "", "scheduledPlaybackTime", "<init>", "(Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;JJ)V", "getPacket", "()Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "getArrivalTime", "()J", "getScheduledPlaybackTime", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "plasmovoice-fabric-1.19.3"})
    public static final class PacketWithArrivalTime {
        @NotNull
        private final JitterBuffer.PacketWithSequenceNumber packet;
        private final long arrivalTime;
        private final long scheduledPlaybackTime;

        public PacketWithArrivalTime(@NotNull JitterBuffer.PacketWithSequenceNumber packet, long arrivalTime, long scheduledPlaybackTime) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this.packet = packet;
            this.arrivalTime = arrivalTime;
            this.scheduledPlaybackTime = scheduledPlaybackTime;
        }

        @NotNull
        public final JitterBuffer.PacketWithSequenceNumber getPacket() {
            return this.packet;
        }

        public final long getArrivalTime() {
            return this.arrivalTime;
        }

        public final long getScheduledPlaybackTime() {
            return this.scheduledPlaybackTime;
        }

        @NotNull
        public final JitterBuffer.PacketWithSequenceNumber component1() {
            return this.packet;
        }

        public final long component2() {
            return this.arrivalTime;
        }

        public final long component3() {
            return this.scheduledPlaybackTime;
        }

        @NotNull
        public final PacketWithArrivalTime copy(@NotNull JitterBuffer.PacketWithSequenceNumber packet, long arrivalTime, long scheduledPlaybackTime) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            return new PacketWithArrivalTime(packet, arrivalTime, scheduledPlaybackTime);
        }

        public static /* synthetic */ PacketWithArrivalTime copy$default(PacketWithArrivalTime packetWithArrivalTime, JitterBuffer.PacketWithSequenceNumber packetWithSequenceNumber, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                packetWithSequenceNumber = packetWithArrivalTime.packet;
            }
            if ((n & 2) != 0) {
                l = packetWithArrivalTime.arrivalTime;
            }
            if ((n & 4) != 0) {
                l2 = packetWithArrivalTime.scheduledPlaybackTime;
            }
            return packetWithArrivalTime.copy(packetWithSequenceNumber, l, l2);
        }

        @NotNull
        public String toString() {
            return "PacketWithArrivalTime(packet=" + this.packet + ", arrivalTime=" + this.arrivalTime + ", scheduledPlaybackTime=" + this.scheduledPlaybackTime + ")";
        }

        public int hashCode() {
            int result2 = this.packet.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.arrivalTime);
            result2 = result2 * 31 + Long.hashCode(this.scheduledPlaybackTime);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PacketWithArrivalTime)) {
                return false;
            }
            PacketWithArrivalTime packetWithArrivalTime = (PacketWithArrivalTime)other;
            if (!Intrinsics.areEqual(this.packet, packetWithArrivalTime.packet)) {
                return false;
            }
            if (this.arrivalTime != packetWithArrivalTime.arrivalTime) {
                return false;
            }
            return this.scheduledPlaybackTime == packetWithArrivalTime.scheduledPlaybackTime;
        }
    }
}

