/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.widget.DropDownWidgetList;

public final class DropDownWidget
extends GuiAbstractWidget {
    private final DropDownWidgetList list;
    private boolean open;

    public DropDownWidget(@NotNull VoiceSettingsScreen parent, int x, int y, int width, int height, @NotNull McTextComponent message, @NotNull List<McTextComponent> elements, boolean tooltip, @NotNull Consumer<Integer> onSelect) {
        super(x, y, width, height, message);
        this.list = new DropDownWidgetList(this, elements, parent, width, tooltip, index -> {
            this.text = (McTextComponent)elements.get((int)index);
            this.switchOpen();
            this.playDownSound();
            onSelect.accept((Integer)index);
        });
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.open && this.list.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.switchOpen();
            return true;
        }
        if (!this.open) {
            return false;
        }
        this.switchOpen();
        this.playDownSound();
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.open && this.list.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public void renderButton(@NotNull class_4587 stack, int mouseX, int mouseY, float delta) {
        this.renderBackground(stack, mouseX, mouseY);
        this.renderArrow(stack);
        this.renderText(stack);
        if (!this.open) {
            return;
        }
        this.list.render(stack, mouseX, mouseY, delta);
    }

    @Override
    protected void renderBackground(@NotNull class_4587 stack, int mouseX, int mouseY) {
        RenderUtil.fill(stack, this.x, this.y, this.x + this.width, this.y + this.height, -6250336);
        RenderUtil.fill(stack, this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, -16777216);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.open && this.list.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.open && this.list.isMouseOver(mouseX, mouseY) || super.isMouseOver(mouseX, mouseY);
    }

    private void switchOpen() {
        if (this.open) {
            this.open = false;
            this.list.setScrollTop(0.0);
        } else {
            this.open = true;
        }
    }

    private void renderText(@NotNull class_4587 stack) {
        RenderUtil.drawOrderedString(stack, this.getText(), this.active ? this.width - 23 : this.width - 5, this.x + 5, this.y + this.height / 2 - RenderUtil.getFontHeight() / 2, this.active ? 0xE0E0E0 : 0x707070);
    }

    private void renderArrow(@NotNull class_4587 stack) {
        if (!this.active) {
            return;
        }
        if (this.open) {
            for (int i = 0; i < 5; ++i) {
                RenderUtil.fill(stack, this.x + this.width - (9 + i), this.y + (this.height - 5) / 2 + i, this.x + this.width - (8 - i), this.y + (this.height - 5) / 2 + 2 + i, -6250336);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                RenderUtil.fill(stack, this.x + this.width - (13 - i), this.y + (this.height - 5) / 2 + (i > 0 ? 1 + i : 0), this.x + this.width - (4 + i), this.y + (this.height - 5) / 2 + 2 + i, -6250336);
            }
        }
    }
}

