/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.capture;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.slib.api.permission.PermissionManager;
import su.plo.slib.api.permission.PermissionTristate;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.event.EventPriority;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.capture.ServerActivationManager;
import su.plo.voice.api.server.connection.PacketManager;
import su.plo.voice.api.server.event.audio.capture.ServerActivationRegisterEvent;
import su.plo.voice.api.server.event.audio.capture.ServerActivationUnregisterEvent;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEndEvent;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEvent;
import su.plo.voice.api.server.event.player.PlayerPermissionUpdateEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.NoWhenBranchMatchedException;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.Regex;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.packets.tcp.clientbound.ActivationRegisterPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ActivationUnregisterPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;
import su.plo.voice.server.audio.capture.SelfActivationHelper;
import su.plo.voice.server.audio.capture.VoiceServerActivation;
import su.plo.voice.server.player.BaseVoicePlayer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u000212BP\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u00070\u0005\u0012)\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0018\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00190\u000e2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u001b\u0010\u001b\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00190\u000e2\u0006\u0010\f\u001a\u00020\nH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0016J8\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u000fH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0007J\u0010\u0010-\u001a\u00020)2\u0006\u0010+\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u00020)2\u0006\u0010+\u001a\u000200H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager;", "Lsu/plo/voice/api/server/audio/capture/ServerActivationManager;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "tcpConnections", "Lsu/plo/voice/api/server/connection/PacketManager;", "Lsu/plo/voice/proto/packets/tcp/clientbound/ClientPacketTcpHandler;", "Lsu/plo/voice/api/server/player/VoicePlayer;", "weightSupplier", "Lsu/plo/voice/libs/kotlin/Function1;", "", "Lsu/plo/voice/libs/kotlin/ParameterName;", "name", "activationName", "Ljava/util/Optional;", "", "<init>", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/api/server/connection/PacketManager;Lkotlin/jvm/functions/Function1;)V", "activationById", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "selfActivationHelper", "Lsu/plo/voice/server/audio/capture/SelfActivationHelper;", "getActivationById", "Lsu/plo/voice/libs/kotlin/jvm/internal/EnhancedNullability;", "id", "getActivationByName", "getActivations", "", "createBuilder", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Builder;", "addonObject", "", "translation", "icon", "permission", "weight", "unregister", "", "clear", "", "onPlayerSpeak", "event", "Lsu/plo/voice/api/server/event/audio/source/PlayerSpeakEvent;", "onPlayerSpeakEnd", "Lsu/plo/voice/api/server/event/audio/source/PlayerSpeakEndEvent;", "onPermissionUpdate", "Lsu/plo/voice/api/server/event/player/PlayerPermissionUpdateEvent;", "VoiceServerActivationBuilder", "Companion", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nVoiceServerActivationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerActivationManager.kt\nsu/plo/voice/server/audio/capture/VoiceServerActivationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,330:1\n1863#2,2:331\n774#2:333\n865#2,2:334\n1863#2,2:336\n1863#2,2:338\n1863#2,2:340\n1863#2,2:342\n1863#2,2:344\n2632#2,3:348\n739#2,9:351\n216#3,2:346\n37#4,2:360\n*S KotlinDebug\n*F\n+ 1 VoiceServerActivationManager.kt\nsu/plo/voice/server/audio/capture/VoiceServerActivationManager\n*L\n86#1:331,2\n95#1:333\n95#1:334,2\n96#1:336,2\n110#1:338,2\n141#1:340,2\n196#1:342,2\n200#1:344,2\n215#1:348,3\n217#1:351,9\n204#1:346,2\n217#1:360,2\n*E\n"})
public final class VoiceServerActivationManager
implements ServerActivationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final PacketManager<ClientPacketTcpHandler, ? extends VoicePlayer> tcpConnections;
    @Nullable
    private final Function1<String, Optional<Integer>> weightSupplier;
    @NotNull
    private final Map<UUID, ServerActivation> activationById;
    @NotNull
    private final SelfActivationHelper selfActivationHelper;
    @NotNull
    private static final String WILDCARD_ACTIVATION_PERMISSION = "pv.activation.*";

    public VoiceServerActivationManager(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull PacketManager<ClientPacketTcpHandler, ? extends VoicePlayer> tcpConnections, @Nullable Function1<? super String, Optional<Integer>> weightSupplier) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(tcpConnections, "tcpConnections");
        this.voiceServer = voiceServer;
        this.tcpConnections = tcpConnections;
        this.weightSupplier = weightSupplier;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.activationById = concurrentMap;
        this.selfActivationHelper = new SelfActivationHelper(this.voiceServer);
        this.voiceServer.getEventBus().register(this.voiceServer, this.selfActivationHelper);
    }

    @Override
    @NotNull
    public Optional<ServerActivation> getActivationById(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        Optional<ServerActivation> optional = Optional.ofNullable(this.activationById.get(id));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @Override
    @NotNull
    public Optional<ServerActivation> getActivationByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Optional<ServerActivation> optional = Optional.ofNullable(this.activationById.get(VoiceActivation.generateId(name)));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @Override
    @NotNull
    public Collection<ServerActivation> getActivations() {
        return this.activationById.values();
    }

    @Override
    @NotNull
    public ServerActivation.Builder createBuilder(@NotNull Object addonObject, @NotNull String name, @NotNull String translation, @NotNull String icon, @NotNull String permission, int weight) {
        Intrinsics.checkNotNullParameter(addonObject, "addonObject");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(translation, "translation");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(permission, "permission");
        AddonContainer addon = this.voiceServer.getAddonManager().getAddon(addonObject).orElseThrow(VoiceServerActivationManager::createBuilder$lambda$0);
        if (this.activationById.containsKey(VoiceActivation.generateId(name))) {
            throw new IllegalArgumentException("Activation with name " + name + " already exists");
        }
        Intrinsics.checkNotNull(addon);
        Object[] objectArray = new String[]{permission};
        HashSet hashSet = Sets.newHashSet((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue(hashSet, "newHashSet(...)");
        Function1<String, Optional<Integer>> function1 = this.weightSupplier;
        return new VoiceServerActivationBuilder(addon, name, translation, icon, hashSet, function1 != null && (function1 = function1.invoke(name)) != null && (function1 = (Integer)((Optional)((Object)function1)).orElse(null)) != null ? (Integer)((Object)function1) : weight);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean unregister(@NotNull UUID id) {
        void $this$filterTo$iv$iv;
        ServerActivationUnregisterEvent serverActivationUnregisterEvent;
        Intrinsics.checkNotNullParameter(id, "id");
        ServerActivation serverActivation = this.activationById.get(id);
        if (serverActivation == null) {
            return false;
        }
        ServerActivation activation = serverActivation;
        ServerActivationUnregisterEvent event = serverActivationUnregisterEvent = new ServerActivationUnregisterEvent(activation);
        boolean $i$a$-also-VoiceServerActivationManager$unregister$22 = false;
        if (!this.voiceServer.getEventBus().fire((Event)event)) {
            return false;
        }
        Collection<String> collection = activation.getPermissions();
        Intrinsics.checkNotNullExpressionValue(collection, "getPermissions(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String permission = (String)element$iv;
            boolean bl = false;
            PermissionManager permissionManager = this.voiceServer.getMinecraftServer().getPermissionManager();
            Intrinsics.checkNotNull(permission);
            permissionManager.unregister(permission);
        }
        this.activationById.remove(id);
        Collection<?> collection2 = this.voiceServer.getPlayerManager().getPlayers();
        Intrinsics.checkNotNullExpressionValue(collection2, "getPlayers(...)");
        Iterable $this$filter$iv = collection2;
        boolean $i$f$filter = false;
        Iterable $i$a$-also-VoiceServerActivationManager$unregister$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VoicePlayer it = (VoicePlayer)element$iv$iv;
            boolean bl = false;
            if (!it.hasVoiceChat()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VoicePlayer it = (VoicePlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type su.plo.voice.server.player.BaseVoicePlayer<*>");
            BaseVoicePlayer player = (BaseVoicePlayer)it;
            player.removeActivationDistance(activation);
            player.getActiveActivations().remove(activation);
        }
        this.tcpConnections.broadcast(new ActivationUnregisterPacket(activation.getId()), new Predicate(activation){
            final /* synthetic */ ServerActivation $activation;
            {
                this.$activation = $activation;
            }

            public final boolean test(VoicePlayer it) {
                return this.$activation.checkPermissions(it);
            }
        });
        return true;
    }

    @Override
    public void clear() {
        Iterable $this$forEach$iv = this.activationById.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerActivation p0 = (ServerActivation)element$iv;
            boolean bl = false;
            this.unregister((Activation)p0);
        }
        this.activationById.clear();
    }

    @EventSubscribe(priority=EventPriority.LOW)
    public final void onPlayerSpeak(@NotNull PlayerSpeakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        VoicePlayer voicePlayer = event.getPlayer();
        Intrinsics.checkNotNull(voicePlayer, "null cannot be cast to non-null type su.plo.voice.server.player.BaseVoicePlayer<*>");
        BaseVoicePlayer player = (BaseVoicePlayer)voicePlayer;
        PlayerAudioPacket originalPacket = event.getPacket();
        UUID uUID = originalPacket.getActivationId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getActivationId(...)");
        VoiceServerActivation voiceServerActivation = this.getActivationById(uUID).orElse(null);
        if (voiceServerActivation == null) {
            return;
        }
        VoiceServerActivation activation = voiceServerActivation;
        if (!activation.checkPermissions(player)) {
            return;
        }
        short distance = (short)activation.calculateAllowedDistance(originalPacket.getDistance());
        PlayerAudioPacket packet = new PlayerAudioPacket(originalPacket.getSequenceNumber(), originalPacket.getData(), originalPacket.getActivationId(), distance, originalPacket.isStereo());
        ServerActivation.Requirements requirements = activation.getRequirements();
        boolean bl = requirements != null ? !requirements.checkRequirements((VoicePlayer)player, originalPacket) : false;
        if (bl) {
            return;
        }
        Long lastActivationSequenceNumber = player.getLastActivationSequenceNumber().getOrDefault(activation.getId(), 0L);
        if (!player.getActiveActivations().contains(activation) && packet.getSequenceNumber() > lastActivationSequenceNumber) {
            player.getActiveActivations().add(activation);
            Iterable $this$forEach$iv = activation.getActivationStartListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerActivation.PlayerActivationStartListener it = (ServerActivation.PlayerActivationStartListener)element$iv;
                boolean bl2 = false;
                it.onActivationStart(player);
            }
        }
        for (ServerActivation.PlayerActivationListener listener : activation.getActivationListeners()) {
            ServerActivation.Result result2;
            Intrinsics.checkNotNullExpressionValue((Object)listener.onActivation(player, packet), "onActivation(...)");
            if (result2 != ServerActivation.Result.HANDLED) continue;
            event.setResult(result2);
            event.setCancelled(true);
            break;
        }
    }

    @EventSubscribe(priority=EventPriority.LOW)
    public final void onPlayerSpeakEnd(@NotNull PlayerSpeakEndEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        VoicePlayer voicePlayer = event.getPlayer();
        Intrinsics.checkNotNull(voicePlayer, "null cannot be cast to non-null type su.plo.voice.server.player.BaseVoicePlayer<*>");
        BaseVoicePlayer player = (BaseVoicePlayer)voicePlayer;
        PlayerAudioEndPacket originalPacket = event.getPacket();
        UUID uUID = originalPacket.getActivationId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getActivationId(...)");
        VoiceServerActivation voiceServerActivation = this.getActivationById(uUID).orElse(null);
        if (voiceServerActivation == null) {
            return;
        }
        VoiceServerActivation activation = voiceServerActivation;
        if (!player.getActiveActivations().contains(activation)) {
            return;
        }
        if (!activation.checkPermissions(player)) {
            return;
        }
        short distance = (short)activation.calculateAllowedDistance(originalPacket.getDistance());
        PlayerAudioEndPacket packet = new PlayerAudioEndPacket(originalPacket.getSequenceNumber(), originalPacket.getActivationId(), distance);
        if (!activation.checkDistance(packet.getDistance())) {
            return;
        }
        ServerActivation.Requirements requirements = activation.getRequirements();
        boolean bl = requirements != null ? !requirements.checkRequirements((VoicePlayer)player, packet) : false;
        if (bl) {
            return;
        }
        player.getActiveActivations().remove(activation);
        Map<UUID, Long> map2 = player.getLastActivationSequenceNumber();
        Intrinsics.checkNotNullExpressionValue(map2, "getLastActivationSequenceNumber(...)");
        Map<UUID, Long> map3 = map2;
        UUID uUID2 = activation.getId();
        Long l = packet.getSequenceNumber();
        map3.put(uUID2, l);
        for (ServerActivation.PlayerActivationEndListener listener : activation.getActivationEndListeners()) {
            ServerActivation.Result result2;
            Intrinsics.checkNotNullExpressionValue((Object)listener.onActivationEnd(player, packet), "onActivationEnd(...)");
            if (result2 != ServerActivation.Result.HANDLED) continue;
            event.setResult(result2);
            event.setCancelled(true);
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventSubscribe
    public final void onPermissionUpdate(@NotNull PlayerPermissionUpdateEvent event) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Object it;
        boolean bl;
        String permission;
        VoicePlayer player;
        block20: {
            Intrinsics.checkNotNullParameter(event, "event");
            player = event.getPlayer();
            permission = event.getPermission();
            if (Intrinsics.areEqual(permission, WILDCARD_ACTIVATION_PERMISSION)) {
                switch (WhenMappings.$EnumSwitchMapping$0[player.getInstance().getPermission(WILDCARD_ACTIVATION_PERMISSION).ordinal()]) {
                    case 1: {
                        Iterable $this$forEach$iv = this.activationById.values();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ServerActivation it2 = (ServerActivation)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull(it2, "null cannot be cast to non-null type su.plo.voice.proto.data.audio.capture.VoiceActivation");
                            player.sendPacket(new ActivationRegisterPacket((VoiceActivation)((Object)it2)));
                        }
                        break;
                    }
                    case 2: {
                        Iterable $this$forEach$iv = this.activationById.keySet();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            UUID it3 = (UUID)element$iv;
                            boolean bl3 = false;
                            player.sendPacket(new ActivationUnregisterPacket(it3));
                        }
                        break;
                    }
                    case 3: {
                        Map<UUID, ServerActivation> $this$forEach$iv = this.activationById;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<UUID, ServerActivation>> iterator2 = $this$forEach$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<UUID, ServerActivation> element$iv;
                            Map.Entry<UUID, ServerActivation> entry = element$iv = iterator2.next();
                            boolean bl4 = false;
                            UUID activationId = entry.getKey();
                            ServerActivation activation = entry.getValue();
                            if (activation.checkPermissions(player)) {
                                Intrinsics.checkNotNull(activation, "null cannot be cast to non-null type su.plo.voice.proto.data.audio.capture.VoiceActivation");
                                player.sendPacket(new ActivationRegisterPacket((VoiceActivation)((Object)activation)));
                                continue;
                            }
                            player.sendPacket(new ActivationUnregisterPacket(activationId));
                        }
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return;
            }
            Iterable $this$none$iv = this.activationById.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (ServerActivation)element$iv;
                    boolean bl5 = false;
                    if (!it.getPermissions().contains(permission)) continue;
                    bl = false;
                    break block20;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Intrinsics.checkNotNull(permission);
        Object $i$f$none = permission;
        Regex $this$forEach$iv = new Regex("\\.");
        int element$iv = 0;
        $i$f$none = $this$forEach$iv.split((CharSequence)$i$f$none, element$iv);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (String)iterator$iv.previous();
                boolean bl6 = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] permissionSplit = thisCollection$iv.toArray(new String[0]);
        ServerActivation serverActivation = this.getActivationByName(permissionSplit[permissionSplit.length - 1]).orElse(null);
        if (serverActivation == null) {
            return;
        }
        ServerActivation activation = serverActivation;
        if (activation.checkPermissions(player)) {
            player.sendPacket(new ActivationRegisterPacket((VoiceActivation)((Object)activation)));
        } else {
            player.sendPacket(new ActivationUnregisterPacket(activation.getId()));
        }
    }

    private static final IllegalArgumentException createBuilder$lambda$0() {
        return new IllegalArgumentException("addonObject is not an addon");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager$Companion;", "", "<init>", "()V", "WILDCARD_ACTIVATION_PERMISSION", "", "server-proxy-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010%\u001a\u00060\u0000R\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0016J\u0016\u0010(\u001a\u00060\u0000R\u00020&2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0016\u0010)\u001a\u00060\u0000R\u00020&2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u001a\u0010*\u001a\u00060\u0000R\u00020&2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0016J\u0014\u0010+\u001a\u00060\u0000R\u00020&2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0014\u0010,\u001a\u00060\u0000R\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010-\u001a\u00060\u0000R\u00020&2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0014\u0010.\u001a\u00060\u0000R\u00020&2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J\u0016\u0010/\u001a\u00060\u0000R\u00020&2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager$VoiceServerActivationBuilder;", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Builder;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "permissions", "", "weight", "", "<init>", "(Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager;Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;I)V", "getAddon", "()Lsu/plo/voice/api/addon/AddonContainer;", "getName", "()Ljava/lang/String;", "getTranslation", "getIcon", "getPermissions", "()Ljava/util/Set;", "getWeight", "()I", "distances", "", "defaultDistance", "transitive", "", "proximity", "stereoSupported", "permissionDefault", "Lsu/plo/slib/api/permission/PermissionDefault;", "encoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "requirements", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;", "addPermission", "Lsu/plo/voice/server/audio/capture/VoiceServerActivationManager;", "permission", "setPermissionDefault", "setRequirements", "setDistances", "setDefaultDistance", "setTransitive", "setProximity", "setStereoSupported", "setEncoderInfo", "build", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "server-proxy-common"})
    @SourceDebugExtension(value={"SMAP\nVoiceServerActivationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerActivationManager.kt\nsu/plo/voice/server/audio/capture/VoiceServerActivationManager$VoiceServerActivationBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
    public final class VoiceServerActivationBuilder
    implements ServerActivation.Builder {
        @NotNull
        private final AddonContainer addon;
        @NotNull
        private final String name;
        @NotNull
        private final String translation;
        @NotNull
        private final String icon;
        @NotNull
        private final Set<String> permissions;
        private final int weight;
        @NotNull
        private List<Integer> distances;
        private int defaultDistance;
        private boolean transitive;
        private boolean proximity;
        private boolean stereoSupported;
        @Nullable
        private PermissionDefault permissionDefault;
        @Nullable
        private CodecInfo encoderInfo;
        @Nullable
        private ServerActivation.Requirements requirements;

        public VoiceServerActivationBuilder(@NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, @NotNull String icon, Set<String> permissions, int weight) {
            Intrinsics.checkNotNullParameter(addon, "addon");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(translation, "translation");
            Intrinsics.checkNotNullParameter(icon, "icon");
            Intrinsics.checkNotNullParameter(permissions, "permissions");
            this.addon = addon;
            this.name = name;
            this.translation = translation;
            this.icon = icon;
            this.permissions = permissions;
            this.weight = weight;
            this.distances = CollectionsKt.emptyList();
            this.transitive = true;
            this.proximity = true;
        }

        @NotNull
        public final AddonContainer getAddon() {
            return this.addon;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTranslation() {
            return this.translation;
        }

        @NotNull
        public final String getIcon() {
            return this.icon;
        }

        @NotNull
        public final Set<String> getPermissions() {
            return this.permissions;
        }

        public final int getWeight() {
            return this.weight;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder addPermission(@NotNull String permission) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            Intrinsics.checkNotNullParameter(permission, "permission");
            VoiceServerActivationBuilder $this$addPermission_u24lambda_u240 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$addPermission_u24lambda_u240.permissions.add(permission);
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setPermissionDefault(@Nullable PermissionDefault permissionDefault) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setPermissionDefault_u24lambda_u241 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setPermissionDefault_u24lambda_u241.permissionDefault = permissionDefault;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setRequirements(@Nullable ServerActivation.Requirements requirements) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setRequirements_u24lambda_u242 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setRequirements_u24lambda_u242.requirements = requirements;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setDistances(@NotNull List<Integer> distances) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            Intrinsics.checkNotNullParameter(distances, "distances");
            VoiceServerActivationBuilder $this$setDistances_u24lambda_u243 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setDistances_u24lambda_u243.distances = (List)Preconditions.checkNotNull(distances);
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setDefaultDistance(int defaultDistance) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setDefaultDistance_u24lambda_u244 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setDefaultDistance_u24lambda_u244.defaultDistance = defaultDistance;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setTransitive(boolean transitive) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setTransitive_u24lambda_u245 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setTransitive_u24lambda_u245.transitive = transitive;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setProximity(boolean proximity) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setProximity_u24lambda_u246 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setProximity_u24lambda_u246.proximity = proximity;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setStereoSupported(boolean stereoSupported) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setStereoSupported_u24lambda_u247 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setStereoSupported_u24lambda_u247.stereoSupported = stereoSupported;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public VoiceServerActivationBuilder setEncoderInfo(@Nullable CodecInfo encoderInfo) {
            VoiceServerActivationBuilder voiceServerActivationBuilder;
            VoiceServerActivationBuilder $this$setEncoderInfo_u24lambda_u248 = voiceServerActivationBuilder = this;
            boolean bl = false;
            $this$setEncoderInfo_u24lambda_u248.encoderInfo = encoderInfo;
            return voiceServerActivationBuilder;
        }

        @Override
        @NotNull
        public ServerActivation build() {
            if (!(VoiceServerActivationManager.this.activationById.get(VoiceActivation.generateId(this.name)) == null)) {
                boolean bl = false;
                String string = "Activation with name " + this.name + " already exists";
                throw new IllegalStateException(string.toString());
            }
            VoiceServerActivation activation = new VoiceServerActivation(this.addon, this.name, this.translation, this.icon, this.permissions, this.distances, this.defaultDistance, this.proximity, this.transitive, this.stereoSupported, this.encoderInfo, this.weight, this.requirements);
            if (this.permissionDefault != null) {
                this.permissions.forEach(arg_0 -> VoiceServerActivationBuilder.build$lambda$10(VoiceServerActivationManager.this, this, arg_0));
            }
            ServerActivationRegisterEvent serverActivationRegisterEvent = new ServerActivationRegisterEvent(activation);
            VoiceServerActivationManager voiceServerActivationManager = VoiceServerActivationManager.this;
            ServerActivationRegisterEvent event = serverActivationRegisterEvent;
            boolean bl = false;
            if (!voiceServerActivationManager.voiceServer.getEventBus().fire((Event)event)) {
                boolean bl2 = false;
                String string = "Activation registration was cancelled";
                throw new IllegalStateException(string.toString());
            }
            VoiceServerActivationManager.this.activationById.put(activation.getId(), activation);
            VoiceServerActivationManager.this.tcpConnections.broadcast(new ActivationRegisterPacket(activation), new Predicate(activation){
                final /* synthetic */ VoiceServerActivation $activation;
                {
                    this.$activation = $activation;
                }

                public final boolean test(VoicePlayer it) {
                    return this.$activation.checkPermissions(it);
                }
            });
            return activation;
        }

        private static final void build$lambda$10(VoiceServerActivationManager this$0, VoiceServerActivationBuilder this$1, String permission) {
            PermissionManager permissionManager = this$0.voiceServer.getMinecraftServer().getPermissionManager();
            String string = permission;
            Intrinsics.checkNotNull(string);
            PermissionDefault permissionDefault = this$1.permissionDefault;
            Intrinsics.checkNotNull((Object)permissionDefault);
            permissionManager.register(string, permissionDefault);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionTristate.values().length];
            try {
                nArray[PermissionTristate.TRUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionTristate.FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionTristate.UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

