/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.UUID;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.packets.udp.PacketUdp;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.socket.NettyUdpServerConnection;
import su.plo.voice.socket.NettyPacketUdp;

public final class NettyPacketHandler
extends SimpleChannelInboundHandler<NettyPacketUdp> {
    private final BaseVoiceServer voiceServer;

    protected void channelRead0(ChannelHandlerContext ctx, NettyPacketUdp nettyPacket) throws Exception {
        PacketUdp packet = nettyPacket.getPacketUdp();
        UUID secret = packet.getSecret();
        if (this.voiceServer.getUdpConnectionManager().getConnectionBySecret(secret).map(connection -> {
            if (!connection.getRemoteAddress().equals(nettyPacket.getDatagramPacket().sender())) {
                connection.setRemoteAddress((InetSocketAddress)nettyPacket.getDatagramPacket().sender());
            }
            try {
                connection.handlePacket(packet.getPacket());
            }
            catch (IOException e) {
                BaseVoice.DEBUG_LOGGER.log("Failed to decode packet", e);
            }
            return true;
        }).orElse(false).booleanValue()) {
            return;
        }
        Optional<UUID> playerId = this.voiceServer.getUdpConnectionManager().getPlayerIdBySecret(secret);
        if (!playerId.isPresent()) {
            return;
        }
        Optional player = this.voiceServer.getPlayerManager().getPlayerById(playerId.get());
        if (!player.isPresent()) {
            return;
        }
        NettyUdpServerConnection connection2 = new NettyUdpServerConnection(this.voiceServer, (NioDatagramChannel)ctx.channel(), secret, (VoiceServerPlayer)player.get());
        connection2.setRemoteAddress((InetSocketAddress)nettyPacket.getDatagramPacket().sender());
        this.voiceServer.getUdpConnectionManager().addConnection(connection2);
        this.voiceServer.getTcpPacketManager().sendConfigInfo((VoiceServerPlayer)player.get());
        this.voiceServer.getTcpPacketManager().sendPlayerList((VoiceServerPlayer)player.get());
        this.voiceServer.getTcpPacketManager().broadcastPlayerInfoUpdate((VoiceServerPlayer)player.get());
    }

    public NettyPacketHandler(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

