/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.PlayerSkin;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McGameProfile;

public final class ModPlayerSkins {
    private static final Cache<UUID, Supplier<ResourceLocation>> SKINS = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @NotNull ScheduledExecutorService backgroundExecutor) {
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(playerId);
        if (playerInfo != null) {
            return;
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return;
        }
        backgroundExecutor.execute(() -> {
            GameProfile profile = Optional.ofNullable(Minecraft.getInstance().services().sessionService().fetchProfile(playerId, false)).map(ProfileResult::profile).orElse(new GameProfile(playerId, nick));
            SKINS.put((Object)profile.id(), ModPlayerSkins.getInsecureSkinLocation(profile));
        });
    }

    public static synchronized void loadSkin(@NotNull McGameProfile gameProfile) {
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        Supplier<ResourceLocation> skinLocation = (Supplier<ResourceLocation>)SKINS.getIfPresent((Object)gameProfile.getId());
        if (skinLocation != null) {
            return;
        }
        LinkedHashMultimap propertyMap = LinkedHashMultimap.create();
        gameProfile.getProperties().forEach(arg_0 -> ModPlayerSkins.lambda$loadSkin$1((Multimap)propertyMap, arg_0));
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName(), new PropertyMap((Multimap)propertyMap));
        skinLocation = ModPlayerSkins.getInsecureSkinLocation(profile);
        SKINS.put((Object)gameProfile.getId(), skinLocation);
    }

    private static Supplier<ResourceLocation> getInsecureSkinLocation(GameProfile gameProfile) {
        Supplier skinSupplier = Minecraft.getInstance().getSkinManager().createLookup(gameProfile, false);
        return () -> ModPlayerSkins.lambda$getInsecureSkinLocation$2((Supplier)skinSupplier);
    }

    @NotNull
    public static synchronized ResourceLocation getSkin(@NotNull UUID playerId, @NotNull String nick) {
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(playerId);
        if (playerInfo != null) {
            return playerInfo.getSkin().body().texturePath();
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return (ResourceLocation)skinLocation.get();
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static ResourceLocation getDefaultSkin(@NotNull UUID playerId) {
        return DefaultPlayerSkin.get((UUID)playerId).body().texturePath();
    }

    private ModPlayerSkins() {
    }

    private static /* synthetic */ ResourceLocation lambda$getInsecureSkinLocation$2(Supplier skinSupplier) {
        ResourceLocation skinLocation = ((PlayerSkin)skinSupplier.get()).body().texturePath();
        Minecraft.getInstance().getTextureManager().getTexture(skinLocation).setFilter(false, true);
        return skinLocation;
    }

    private static /* synthetic */ void lambda$loadSkin$1(Multimap propertyMap, McGameProfile.Property property) {
        propertyMap.put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature()));
    }
}

