/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import xaero.common.graphics.OpenGlHelper;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.misc.Misc;

public class ImprovedFramebuffer
extends TextureTarget {
    private static Field MAIN_RENDER_TARGET_FIELD = Misc.getFieldReflection(Minecraft.class, "mainRenderTarget", "field_1689", "Lnet/minecraft/class_276;", "f_91042_");
    private static RenderTarget mainRenderTargetBackup;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(null, width, height, useDepthIn);
    }

    public void bindDefaultFramebuffer(Minecraft mc) {
        ImprovedFramebuffer.restoreMainRenderTarget();
    }

    public void bindRead() {
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.colorTextureView);
    }

    public void generateMipmaps() {
        OpenGlHelper.bindTexture(0, this.colorTexture);
        OpenGlHelper.generateMipmaps();
    }

    private void forceAsMainRenderTarget() {
        if (mainRenderTargetBackup == null) {
            mainRenderTargetBackup = (RenderTarget)Misc.getReflectFieldValue(Minecraft.getInstance(), MAIN_RENDER_TARGET_FIELD);
        }
        Misc.setReflectFieldValue(Minecraft.getInstance(), MAIN_RENDER_TARGET_FIELD, this);
    }

    public static void restoreMainRenderTarget() {
        if (mainRenderTargetBackup != null) {
            Misc.setReflectFieldValue(Minecraft.getInstance(), MAIN_RENDER_TARGET_FIELD, mainRenderTargetBackup);
        }
    }

    public void bindAsMainTarget(boolean viewport) {
        this.forceAsMainRenderTarget();
    }

    public void setColorTexture(GpuTexture texture, GpuTextureView textureView) {
        this.colorTexture = texture;
        this.colorTextureView = textureView;
    }

    public void setColorTexture(XaeroIconAtlas atlas) {
        this.setColorTexture(atlas.getTextureId(), atlas.getTextureView());
    }

    public void setDepthTexture(GpuTexture depthTexture, GpuTextureView textureView) {
        this.depthTexture = depthTexture;
        this.depthTextureView = textureView;
    }

    public void closeColorTexture() {
        this.colorTextureView.close();
        this.colorTexture.close();
    }

    public void closeDepthTexture() {
        this.depthTextureView.close();
        this.depthTexture.close();
    }
}

