/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import xaero.common.IXaeroMinimap;
import xaero.common.anim.MultiplyAnimationHelper;
import xaero.common.core.IGameRenderer;
import xaero.common.core.IGuiRenderer;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.render.MinimapDepthTraceListener;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.player.tracker.synced.ClientSyncedTrackedPlayerManager;
import xaero.hud.minimap.radar.RadarSession;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.render.util.GuiDepthSkipper;
import xaero.hud.render.util.GuiDepthTracer;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private IXaeroMinimap modMain;
    private MinimapSession minimapSession;
    private MinimapWriter minimapWriter;
    private RadarSession radarSession;
    private Minimap minimap;
    private EntityRadarCategoryManager entityCategoryManager;
    private ClientSyncedTrackedPlayerManager syncedTrackedPlayerManager;
    private double minimapZoom;
    private boolean toResetImage;
    private boolean enlargedMap;
    private boolean manualCaveMode;
    private boolean noMinimapMessageReceived;
    private boolean fairPlayOnlyMessageReceived;
    private double lastMapDimensionScale = 1.0;
    private ResourceKey<Level> lastMapDimension;
    private double lastPlayerDimDiv = 1.0;
    private final MinimapDepthTraceListener depthTraceListener;
    private final GuiDepthTracer depthTracer;
    private final GuiDepthSkipper depthSkipper;

    public MinimapProcessor(IXaeroMinimap modMain, MinimapSession minimapSession, MinimapWriter minimapWriter, RadarSession radarSession, ClientSyncedTrackedPlayerManager syncedTrackedPlayerManager) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.minimapWriter = minimapWriter;
        this.radarSession = radarSession;
        this.minimapZoom = 1.0;
        this.toResetImage = true;
        this.minimap = modMain.getMinimap();
        this.syncedTrackedPlayerManager = syncedTrackedPlayerManager;
        this.depthTraceListener = new MinimapDepthTraceListener(this);
        ScreenRectangle maxRectangle = new ScreenRectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.depthTracer = new GuiDepthTracer(this.depthTraceListener, maxRectangle);
        this.depthSkipper = new GuiDepthSkipper(maxRectangle);
    }

    public int getMinimapSize() {
        return this.enlargedMap ? 500 : this.modMain.getSettings().getMinimapSize() * 2;
    }

    public int getMinimapBufferSize(int minimapSize) {
        int bufferSize = 128 * (int)Math.pow(2.0, Math.ceil(Math.log((double)minimapSize / 128.0) / Math.log(2.0)));
        if (bufferSize < 128) {
            return 128;
        }
        if (bufferSize > 512) {
            return 512;
        }
        return bufferSize;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    public boolean isCaveModeDisplayed() {
        return this.minimapWriter.getLoadedCaving() != Integer.MAX_VALUE;
    }

    public double getTargetZoom() {
        this.modMain.getSettings();
        float settingsZoom = ModSettings.zooms[this.modMain.getSettings().zoom];
        if (this.enlargedMap && this.modMain.getSettings().zoomOnEnlarged > 0) {
            settingsZoom = this.modMain.getSettings().zoomOnEnlarged;
        }
        float target = settingsZoom * (this.modMain.getSettings().caveZoom > 0 && this.isCaveModeDisplayed() ? (float)(1 + this.modMain.getSettings().caveZoom) : 1.0f);
        this.modMain.getSettings();
        this.modMain.getSettings();
        if (target > ModSettings.zooms[ModSettings.zooms.length - 1]) {
            this.modMain.getSettings();
            this.modMain.getSettings();
            target = ModSettings.zooms[ModSettings.zooms.length - 1];
        }
        return target;
    }

    public void instantZoom() {
        this.minimapZoom = this.getTargetZoom();
    }

    public void updateZoom() {
        double target = this.getTargetZoom();
        double off = target - this.minimapZoom;
        off = off > 0.01 || off < -0.01 ? (double)((float)MultiplyAnimationHelper.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public boolean canUseFrameBuffer() {
        return true;
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public void onClientTick() {
        Level world = null;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.level() instanceof ClientLevel) {
            world = player.level();
        }
        Entity renderEntity = Minecraft.getInstance().getCameraEntity();
        this.radarSession.update((ClientLevel)world, renderEntity, (Player)player);
    }

    public void onPlayerTick() {
    }

    public void checkFBO() {
        if (this.minimap.getMinimapFBORenderer().isLoadedFBO() && !this.canUseFrameBuffer()) {
            this.minimap.getMinimapFBORenderer().setLoadedFBO(false);
            this.minimap.getMinimapFBORenderer().deleteFramebuffers();
            this.toResetImage = true;
        }
        if (!(this.minimap.getMinimapFBORenderer().isLoadedFBO() || this.modMain.getSettings().mapSafeMode || this.minimap.getMinimapFBORenderer().isTriedFBO())) {
            if (Minecraft.getInstance().getOverlay() != null) {
                return;
            }
            this.minimap.getMinimapFBORenderer().loadFrameBuffer(this);
        }
    }

    public void onRender(int x, int y, int width, int height, double scale, int size, int boxSize, float partial, CustomVertexConsumers cvc, float depth) {
        MinimapRendererHelper.restoreDefaultShaderBlendState();
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
        RenderSystem.getModelViewStack().translate(0.0f, 0.0f, -11000.0f);
        try {
            if (this.enlargedMap && this.modMain.getSettings().centeredEnlarged) {
                x = (width - boxSize) / 2;
                y = (height - boxSize) / 2;
            }
            Minecraft mc = Minecraft.getInstance();
            Window window = mc.getWindow();
            IGuiRenderer guiRenderer = (IGuiRenderer)((IGameRenderer)mc.gameRenderer).xaero_mm_getGuiRenderer();
            CachedOrthoProjectionMatrixBuffer orthoProjectionCache = guiRenderer.xaero_mm_getGuiProjectionMatrixBuffer();
            RenderSystem.setProjectionMatrix((GpuBufferSlice)orthoProjectionCache.getBuffer((float)window.getWidth() / (float)window.getGuiScale(), (float)window.getHeight() / (float)window.getGuiScale()), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
            this.minimap.getMatrixStack().pushPose();
            this.minimap.getMatrixStack().translate(0.0f, 0.0f, depth);
            if (this.minimap.usingFBO()) {
                this.minimap.getMinimapFBORenderer().renderMinimap(this.minimapSession, this, x, y, width, height, scale, size, partial, cvc);
            } else {
                this.minimap.getMinimapSafeModeRenderer().renderMinimap(this.minimapSession, this, x, y, width, height, scale, size, partial, cvc);
            }
            this.minimap.getMatrixStack().popPose();
        }
        catch (Throwable e) {
            this.minimap.setCrashedWith(e);
        }
        RenderSystem.getModelViewStack().popMatrix();
        MinimapRendererHelper.restoreDefaultShaderBlendState();
    }

    public static boolean hasMinimapItem(Player player) {
        return Misc.hasItem(player, ModSettings.minimapItem);
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    public RadarSession getRadarSession() {
        return this.radarSession;
    }

    public void cleanup() {
        this.minimapWriter.cleanup();
    }

    public boolean isManualCaveMode() {
        return this.manualCaveMode || this.modMain.getSettings().usesWorldMapScreenValue(ModOptions.MANUAL_CAVE_MODE_START) && this.modMain.getSupportMods().worldmapSupport.getManualCaveStart() != Integer.MAX_VALUE;
    }

    public void toggleManualCaveMode() {
        this.manualCaveMode = !this.isManualCaveMode();
    }

    public Minimap getMinimap() {
        return this.minimap;
    }

    public boolean getNoMinimapMessageReceived() {
        return this.noMinimapMessageReceived;
    }

    public void setNoMinimapMessageReceived(boolean noMinimapMessageReceived) {
        this.noMinimapMessageReceived = noMinimapMessageReceived;
    }

    public boolean getForcedFairPlay() {
        return this.fairPlayOnlyMessageReceived;
    }

    public void setFairPlayOnlyMessageReceived(boolean fairPlayOnlyMessageReceived) {
        this.fairPlayOnlyMessageReceived = fairPlayOnlyMessageReceived;
    }

    public ClientSyncedTrackedPlayerManager getSyncedTrackedPlayerManager() {
        return this.syncedTrackedPlayerManager;
    }

    public boolean serverHasMod() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData != null && worldData.serverLevelId != null;
    }

    public void setServerModNetworkVersion(int networkVersion) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return;
        }
        worldData.setServerModNetworkVersion(networkVersion);
    }

    public int getServerModNetworkVersion() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return 0;
        }
        return worldData.getServerModNetworkVersion();
    }

    public double getLastMapDimensionScale() {
        return this.lastMapDimensionScale;
    }

    public void setLastMapDimensionScale(double lastMapDimensionScale) {
        this.lastMapDimensionScale = lastMapDimensionScale;
    }

    public ResourceKey<Level> getLastMapDimension() {
        return this.lastMapDimension;
    }

    public void setLastMapDimension(ResourceKey<Level> lastMapDimension) {
        this.lastMapDimension = lastMapDimension;
    }

    public MinimapSession getSession() {
        return this.minimapSession;
    }

    public MinimapDepthTraceListener getDepthTraceListener() {
        return this.depthTraceListener;
    }

    public GuiDepthTracer getDepthTracer() {
        return this.depthTracer;
    }

    public GuiDepthSkipper getDepthSkipper() {
        return this.depthSkipper;
    }
}

