/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.sprite;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.minimap.element.render.MinimapElementGraphics;
import xaero.hud.minimap.radar.icon.creator.RadarIconCreator;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.sprite.RadarIconSpriteForm;
import xaero.hud.render.util.ImmediateRenderUtil;

public class RadarIconSpriteFormPrerenderer
implements IRadarIconFormPrerenderer {
    private final boolean flipped;
    private final boolean outlined;

    public RadarIconSpriteFormPrerenderer(boolean flipped, boolean outlined) {
        this.flipped = flipped;
        this.outlined = outlined;
    }

    @Override
    public boolean requiresEntityModel() {
        return false;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public boolean isOutlined() {
        return this.outlined;
    }

    @Override
    public <S extends EntityRenderState> boolean prerender(MinimapElementGraphics guiGraphics, EntityRenderer<?, ? super S> entityRenderer, S entityRenderState, @Nullable EntityModel<S> entityModel, Entity entity, @Nullable List<ModelRenderTrace> traceResult, RadarIconCreator.Parameters parameters) {
        PoseStack matrixStack = guiGraphics.pose();
        RadarIconSpriteForm spriteForm = (RadarIconSpriteForm)parameters.form;
        ResourceLocation sprite = spriteForm.getSpriteLocation();
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_FLAT);
        GpuTextureView gpuTexture = Minecraft.getInstance().getTextureManager().getTexture(sprite).getTextureView();
        gpuTexture.texture().setTextureFilter(FilterMode.LINEAR, FilterMode.NEAREST, false);
        gpuTexture.texture().setAddressMode(AddressMode.CLAMP_TO_EDGE);
        int halfIcon = 32;
        matrixStack.translate((float)halfIcon, (float)halfIcon, 1.0f);
        float scale = parameters.scale;
        if (scale < 1.0f) {
            matrixStack.scale(scale, scale, 1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)gpuTexture);
        ImmediateRenderUtil.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        ImmediateRenderUtil.texturedRect(matrixStack, (float)(-halfIcon), (float)(-halfIcon), 0, 64, 64.0f, 64.0f, -64.0f, 64.0f, CustomRenderTypes.RP_POSITION_TEX_ALPHA_NO_CULL);
        return true;
    }
}

