/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints;

import de.md5lukas.waypoints.api.SQLiteManager;
import de.md5lukas.waypoints.api.Statistics;
import de.md5lukas.waypoints.api.WaypointsAPI;
import de.md5lukas.waypoints.api.WaypointsPointerManager;
import de.md5lukas.waypoints.api.base.DatabaseManager;
import de.md5lukas.waypoints.command.WaypointsCommand;
import de.md5lukas.waypoints.command.WaypointsScriptCommand;
import de.md5lukas.waypoints.config.BlockDataAdapter;
import de.md5lukas.waypoints.config.DurationAdapter;
import de.md5lukas.waypoints.config.MaterialListAdapter;
import de.md5lukas.waypoints.config.SoundAdapter;
import de.md5lukas.waypoints.config.StyleAdapter;
import de.md5lukas.waypoints.config.WaypointsConfiguration;
import de.md5lukas.waypoints.config.general.TeleportConfiguration;
import de.md5lukas.waypoints.config.general.TeleportPaymentType;
import de.md5lukas.waypoints.config.general.TypedTeleportConfiguration;
import de.md5lukas.waypoints.config.integrations.IntegrationsConfiguration;
import de.md5lukas.waypoints.events.ConfigReloadEvent;
import de.md5lukas.waypoints.events.PointerEvents;
import de.md5lukas.waypoints.events.WaypointsListener;
import de.md5lukas.waypoints.integrations.BlueMapIntegration;
import de.md5lukas.waypoints.integrations.DynMapIntegration;
import de.md5lukas.waypoints.integrations.GeyserIntegration;
import de.md5lukas.waypoints.integrations.Pl3xMapIntegration;
import de.md5lukas.waypoints.integrations.SquareMapIntegration;
import de.md5lukas.waypoints.integrations.VaultIntegration;
import de.md5lukas.waypoints.lang.Translations;
import de.md5lukas.waypoints.lang.WorldTranslations;
import de.md5lukas.waypoints.lang.YmlTranslationLoader;
import de.md5lukas.waypoints.libs.bstats.bukkit.Metrics;
import de.md5lukas.waypoints.libs.bstats.charts.SimplePie;
import de.md5lukas.waypoints.libs.bstats.charts.SingleLineChart;
import de.md5lukas.waypoints.libs.commons.paper.PluginKt;
import de.md5lukas.waypoints.libs.commons.paper.UUIDUtils;
import de.md5lukas.waypoints.libs.commons.time.DurationFormatter;
import de.md5lukas.waypoints.libs.konfig.Konfig;
import de.md5lukas.waypoints.libs.konfig.RegisteredTypeAdapter;
import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.libs.schedulers.Schedulers;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.PointerManagerHooks;
import de.md5lukas.waypoints.pointers.WaypointsPointerManagerImpl;
import de.md5lukas.waypoints.tasks.CleanDatabaseTask;
import de.md5lukas.waypoints.util.APIExtensions;
import de.md5lukas.waypoints.util.TeleportManager;
import de.md5lukas.waypoints.util.UpdateChecker;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.registrar.Registrar;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020KH\u0016J\b\u0010O\u001a\u00020KH\u0002J\u0006\u0010P\u001a\u00020KJ\b\u0010Q\u001a\u00020KH\u0002J\b\u0010R\u001a\u00020KH\u0002J\b\u0010S\u001a\u00020KH\u0002J\b\u0010T\u001a\u00020KH\u0002J\b\u0010U\u001a\u00020KH\u0002J\b\u0010V\u001a\u00020KH\u0002J\b\u0010W\u001a\u00020KH\u0002J\b\u0010X\u001a\u00020KH\u0002J\u0010\u0010Y\u001a\u00020K2\u0006\u0010Z\u001a\u00020?H\u0002J\b\u0010[\u001a\u00020KH\u0002J\b\u0010\\\u001a\u00020KH\u0002J\b\u0010]\u001a\u00020KH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u001a\u0010\u0007\u001a\u00020\bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0012@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\"@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001e\u0010'\u001a\u00020&2\u0006\u0010\r\u001a\u00020&@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001e\u0010+\u001a\u00020*2\u0006\u0010\r\u001a\u00020*@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001e\u0010/\u001a\u00020.2\u0006\u0010\r\u001a\u00020.@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001e\u00103\u001a\u0002022\u0006\u0010\r\u001a\u000202@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00108\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\"\u0010<\u001a\u0004\u0018\u00010;2\b\u0010\r\u001a\u0004\u0018\u00010;@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001e\u0010@\u001a\u00020?2\u0006\u0010\r\u001a\u00020?@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u001e\u0010C\u001a\u00020?2\u0006\u0010\r\u001a\u00020?@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010BR\u001e\u0010E\u001a\u00020?2\u0006\u0010\r\u001a\u00020?@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010BR\u000e\u0010G\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lde/md5lukas/waypoints/WaypointsPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "METRICS_PLUGIN_ID", "", "getMETRICS_PLUGIN_ID$annotations", "databaseManager", "Lde/md5lukas/waypoints/api/base/DatabaseManager;", "getDatabaseManager$waypoints", "()Lde/md5lukas/waypoints/api/base/DatabaseManager;", "setDatabaseManager$waypoints", "(Lde/md5lukas/waypoints/api/base/DatabaseManager;)V", "value", "Lde/md5lukas/waypoints/config/WaypointsConfiguration;", "waypointsConfig", "getWaypointsConfig", "()Lde/md5lukas/waypoints/config/WaypointsConfiguration;", "Lde/md5lukas/waypoints/api/WaypointsAPI;", "api", "getApi", "()Lde/md5lukas/waypoints/api/WaypointsAPI;", "apiExtensions", "Lde/md5lukas/waypoints/util/APIExtensions;", "getApiExtensions", "()Lde/md5lukas/waypoints/util/APIExtensions;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "getPointerManager", "()Lde/md5lukas/waypoints/pointers/PointerManager;", "setPointerManager", "(Lde/md5lukas/waypoints/pointers/PointerManager;)V", "translationLoader", "Lde/md5lukas/waypoints/lang/YmlTranslationLoader;", "Lde/md5lukas/waypoints/lang/Translations;", "translations", "getTranslations", "()Lde/md5lukas/waypoints/lang/Translations;", "Lde/md5lukas/waypoints/lang/WorldTranslations;", "worldTranslations", "getWorldTranslations", "()Lde/md5lukas/waypoints/lang/WorldTranslations;", "Lde/md5lukas/waypoints/util/TeleportManager;", "teleportManager", "getTeleportManager", "()Lde/md5lukas/waypoints/util/TeleportManager;", "Lde/md5lukas/waypoints/libs/commons/paper/UUIDUtils;", "uuidUtils", "getUuidUtils", "()Lde/md5lukas/commons/paper/UUIDUtils;", "Lde/md5lukas/waypoints/libs/commons/time/DurationFormatter;", "durationFormatter", "getDurationFormatter", "()Lde/md5lukas/commons/time/DurationFormatter;", "vaultIntegration0", "Lde/md5lukas/waypoints/integrations/VaultIntegration;", "vaultIntegration", "getVaultIntegration", "()Lde/md5lukas/waypoints/integrations/VaultIntegration;", "Lde/md5lukas/waypoints/integrations/GeyserIntegration;", "geyserIntegration", "getGeyserIntegration", "()Lde/md5lukas/waypoints/integrations/GeyserIntegration;", "", "dynMapIntegrationAvailable", "getDynMapIntegrationAvailable", "()Z", "squareMapIntegrationAvailable", "getSquareMapIntegrationAvailable", "pl3xMapIntegrationAvailable", "getPl3xMapIntegrationAvailable", "blueMapIntegrationAvailable", "metrics", "Lde/md5lukas/waypoints/libs/bstats/bukkit/Metrics;", "onLoad", "", "onEnable", "konfig", "Lde/md5lukas/waypoints/libs/konfig/Konfig;", "loadConfiguration", "reloadConfiguration", "initDatabase", "initApiServiceProvider", "initTranslations", "initTeleportManager", "initCommons", "initIntegrations", "registerCommands", "registerEvents", "registerCustomizablePermissions", "clearPrevious", "startMetrics", "startBackgroundTasks", "onDisable", "waypoints"})
@SourceDebugExtension(value={"SMAP\nWaypointsPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaypointsPlugin.kt\nde/md5lukas/waypoints/WaypointsPlugin\n+ 2 Konfig.kt\nde/md5lukas/konfig/Konfig$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,370:1\n48#2:371\n1869#3,2:372\n1634#3,3:374\n1634#3,3:377\n1#4:380\n12637#5,2:381\n*S KotlinDebug\n*F\n+ 1 WaypointsPlugin.kt\nde/md5lukas/waypoints/WaypointsPlugin\n*L\n102#1:371\n262#1:372,2\n272#1:374,3\n275#1:377,3\n304#1:381,2\n*E\n"})
public final class WaypointsPlugin
extends JavaPlugin {
    private final int METRICS_PLUGIN_ID;
    public DatabaseManager databaseManager;
    private WaypointsConfiguration waypointsConfig;
    private WaypointsAPI api;
    @NotNull
    private final APIExtensions apiExtensions = new APIExtensions(this);
    public PointerManager pointerManager;
    private YmlTranslationLoader translationLoader;
    private Translations translations;
    private WorldTranslations worldTranslations;
    private TeleportManager teleportManager;
    private UUIDUtils uuidUtils;
    private DurationFormatter durationFormatter;
    @Nullable
    private VaultIntegration vaultIntegration0;
    @Nullable
    private GeyserIntegration geyserIntegration;
    private boolean dynMapIntegrationAvailable;
    private boolean squareMapIntegrationAvailable;
    private boolean pl3xMapIntegrationAvailable;
    private boolean blueMapIntegrationAvailable;
    private Metrics metrics;
    @NotNull
    private final Konfig konfig;

    public WaypointsPlugin() {
        this.METRICS_PLUGIN_ID = 6864;
        Object[] objectArray = new RegisteredTypeAdapter[]{MaterialListAdapter.INSTANCE, BlockDataAdapter.INSTANCE, DurationAdapter.INSTANCE, StyleAdapter.INSTANCE, SoundAdapter.INSTANCE};
        this.konfig = new Konfig(CollectionsKt.listOf((Object[])objectArray));
    }

    private static /* synthetic */ void getMETRICS_PLUGIN_ID$annotations() {
    }

    @NotNull
    public final DatabaseManager getDatabaseManager$waypoints() {
        DatabaseManager databaseManager = this.databaseManager;
        if (databaseManager != null) {
            return databaseManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"databaseManager");
        return null;
    }

    public final void setDatabaseManager$waypoints(@NotNull DatabaseManager databaseManager) {
        Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"<set-?>");
        this.databaseManager = databaseManager;
    }

    @NotNull
    public final WaypointsConfiguration getWaypointsConfig() {
        WaypointsConfiguration waypointsConfiguration = this.waypointsConfig;
        if (waypointsConfiguration != null) {
            return waypointsConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"waypointsConfig");
        return null;
    }

    @NotNull
    public final WaypointsAPI getApi() {
        WaypointsAPI waypointsAPI = this.api;
        if (waypointsAPI != null) {
            return waypointsAPI;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        return null;
    }

    @NotNull
    public final APIExtensions getApiExtensions() {
        return this.apiExtensions;
    }

    @NotNull
    public final PointerManager getPointerManager() {
        PointerManager pointerManager = this.pointerManager;
        if (pointerManager != null) {
            return pointerManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pointerManager");
        return null;
    }

    public final void setPointerManager(@NotNull PointerManager pointerManager) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"<set-?>");
        this.pointerManager = pointerManager;
    }

    @NotNull
    public final Translations getTranslations() {
        Translations translations = this.translations;
        if (translations != null) {
            return translations;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"translations");
        return null;
    }

    @NotNull
    public final WorldTranslations getWorldTranslations() {
        WorldTranslations worldTranslations = this.worldTranslations;
        if (worldTranslations != null) {
            return worldTranslations;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"worldTranslations");
        return null;
    }

    @NotNull
    public final TeleportManager getTeleportManager() {
        TeleportManager teleportManager = this.teleportManager;
        if (teleportManager != null) {
            return teleportManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"teleportManager");
        return null;
    }

    @NotNull
    public final UUIDUtils getUuidUtils() {
        UUIDUtils uUIDUtils = this.uuidUtils;
        if (uUIDUtils != null) {
            return uUIDUtils;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"uuidUtils");
        return null;
    }

    @NotNull
    public final DurationFormatter getDurationFormatter() {
        DurationFormatter durationFormatter = this.durationFormatter;
        if (durationFormatter != null) {
            return durationFormatter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"durationFormatter");
        return null;
    }

    @NotNull
    public final VaultIntegration getVaultIntegration() {
        VaultIntegration vaultIntegration = this.vaultIntegration0;
        if (vaultIntegration == null) {
            throw new IllegalStateException("The vault integration is configured to be used, but no vault compatible plugin is installed");
        }
        return vaultIntegration;
    }

    @Nullable
    public final GeyserIntegration getGeyserIntegration() {
        return this.geyserIntegration;
    }

    public final boolean getDynMapIntegrationAvailable() {
        return this.dynMapIntegrationAvailable;
    }

    public final boolean getSquareMapIntegrationAvailable() {
        return this.squareMapIntegrationAvailable;
    }

    public final boolean getPl3xMapIntegrationAvailable() {
        return this.pl3xMapIntegrationAvailable;
    }

    public void onLoad() {
        Konfig.Companion this_$iv = Konfig.Companion;
        boolean $i$f$preloadClasses = false;
        this_$iv.preloadClasses(Reflection.getOrCreateKotlinClass(WaypointsConfiguration.class));
    }

    public void onEnable() {
        try {
            Class.forName("io.papermc.paper.configuration.Configuration");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getLogger().log(Level.SEVERE, "Waypoints requires the Paper server implementation");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadConfiguration();
        this.initDatabase();
        this.initApiServiceProvider();
        this.initTranslations();
        this.initTeleportManager();
        this.initCommons();
        this.initIntegrations();
        this.registerCommands();
        this.registerEvents();
        this.registerCustomizablePermissions(false);
        this.startMetrics();
        this.startBackgroundTasks();
    }

    private final void loadConfiguration() {
        this.saveDefaultConfig();
        this.waypointsConfig = new WaypointsConfiguration();
        FileConfiguration fileConfiguration = this.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)fileConfiguration, (String)"getConfig(...)");
        this.konfig.deserializeInto((ConfigurationSection)fileConfiguration, this.getWaypointsConfig());
    }

    public final void reloadConfiguration() {
        this.saveDefaultConfig();
        this.reloadConfig();
        FileConfiguration fileConfiguration = this.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)fileConfiguration, (String)"getConfig(...)");
        this.konfig.deserializeInto((ConfigurationSection)fileConfiguration, this.getWaypointsConfig());
        new ConfigReloadEvent(this.getWaypointsConfig()).callEvent();
        this.registerCustomizablePermissions(true);
    }

    private final void initDatabase() {
        this.setDatabaseManager$waypoints(new SQLiteManager((Plugin)this, this.getWaypointsConfig().getDatabase(), new File(this.getDataFolder(), "waypoints.db"), false, 8, null));
        this.getDatabaseManager$waypoints().initDatabase();
        this.api = this.getDatabaseManager$waypoints().getApi();
        this.setPointerManager(new PointerManager((Plugin)this, new PointerManagerHooks(this), this.getWaypointsConfig().getPointers()));
    }

    private final void initApiServiceProvider() {
        this.getServer().getServicesManager().register(WaypointsAPI.class, (Object)this.getApi(), (Plugin)this, ServicePriority.Normal);
        this.getServer().getServicesManager().register(WaypointsPointerManager.class, (Object)new WaypointsPointerManagerImpl(this), (Plugin)this, ServicePriority.Normal);
        this.getServer().getServicesManager().register(PointerManager.class, (Object)this.getPointerManager(), (Plugin)this, ServicePriority.Normal);
    }

    private final void initTranslations() {
        this.translationLoader = new YmlTranslationLoader(this);
        YmlTranslationLoader ymlTranslationLoader = this.translationLoader;
        if (ymlTranslationLoader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"translationLoader");
            ymlTranslationLoader = null;
        }
        ymlTranslationLoader.loadLanguage(this.getWaypointsConfig().getGeneral().getLanguage());
        YmlTranslationLoader ymlTranslationLoader2 = this.translationLoader;
        if (ymlTranslationLoader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"translationLoader");
            ymlTranslationLoader2 = null;
        }
        this.translations = new Translations(ymlTranslationLoader2);
        YmlTranslationLoader ymlTranslationLoader3 = this.translationLoader;
        if (ymlTranslationLoader3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"translationLoader");
            ymlTranslationLoader3 = null;
        }
        this.worldTranslations = new WorldTranslations(ymlTranslationLoader3);
    }

    private final void initTeleportManager() {
        this.teleportManager = new TeleportManager(this);
    }

    private final void initCommons() {
        this.uuidUtils = new UUIDUtils(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault()));
        this.durationFormatter = new DurationFormatter((Function2<? super TimeUnit, ? super Boolean, String>)((Function2)(arg_0, arg_1) -> WaypointsPlugin.initCommons$lambda$1(this, arg_0, arg_1)));
    }

    private final void initIntegrations() {
        VaultIntegration vault = new VaultIntegration(this);
        if (vault.setupEconomy()) {
            this.vaultIntegration0 = vault;
        }
        if (this.getWaypointsConfig().getIntegrations().getGeyser().getEnabled()) {
            GeyserIntegration geyser = new GeyserIntegration(this);
            if (geyser.setupGeyser()) {
                this.geyserIntegration = geyser;
            } else {
                this.getSLF4JLogger().warn("The geyser integration is enabled in the config but geyser is not installed on this server");
            }
        }
        if (this.getWaypointsConfig().getGeneral().getFeatures().getGlobalWaypoints()) {
            IntegrationsConfiguration $this$initIntegrations_u24lambda_u242 = this.getWaypointsConfig().getIntegrations();
            boolean bl = false;
            if ($this$initIntegrations_u24lambda_u242.getDynmap().getEnabled()) {
                this.dynMapIntegrationAvailable = new DynMapIntegration(this).setupDynMap();
            }
            if ($this$initIntegrations_u24lambda_u242.getSquaremap().getEnabled()) {
                this.squareMapIntegrationAvailable = new SquareMapIntegration(this).setupSquareMap();
            }
            if ($this$initIntegrations_u24lambda_u242.getBluemap().getEnabled()) {
                this.blueMapIntegrationAvailable = new BlueMapIntegration(this).setupBlueMap();
            }
            if ($this$initIntegrations_u24lambda_u242.getPl3xmap().getEnabled()) {
                this.pl3xMapIntegrationAvailable = new Pl3xMapIntegration(this).setupPl3xMap();
            }
        }
    }

    private final void registerCommands() {
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, new LifecycleEventHandler(this){
            final /* synthetic */ WaypointsPlugin this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run(ReloadableRegistrarEvent<Commands> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Registrar registrar = it.registrar();
                Intrinsics.checkNotNullExpressionValue((Object)registrar, (String)"registrar(...)");
                Commands registrar2 = (Commands)registrar;
                registrar2.register(new WaypointsCommand(this.this$0).buildCommand(), (Collection)this.this$0.getWaypointsConfig().getGeneral().getCommands().getWaypointsAliases());
                registrar2.register(new WaypointsScriptCommand(this.this$0).buildCommand(), (Collection)this.this$0.getWaypointsConfig().getGeneral().getCommands().getWaypointsScriptAliases());
            }
        });
    }

    private final void registerEvents() {
        PluginKt.registerEvents((Plugin)this, new WaypointsListener(this));
        PluginKt.registerEvents((Plugin)this, new PointerEvents(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void registerCustomizablePermissions(boolean clearPrevious) {
        Collection collection;
        Iterable $this$mapTo$iv;
        PluginManager pluginManager = this.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"getPluginManager(...)");
        PluginManager pm = pluginManager;
        if (clearPrevious) {
            Set set2 = pm.getPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getPermissions(...)");
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name;
                Permission it = (Permission)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)name, (String)"waypoints.limit.waypoints.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"waypoints.limit.folders.", (boolean)false, (int)2, null)) continue;
                pm.removePermission(name);
            }
        }
        List permissions = new ArrayList();
        Iterable $i$f$forEach = this.getWaypointsConfig().getGeneral().getWaypoints().getPermissionLimits();
        Collection destination$iv = permissions;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            int name = ((Number)item$iv).intValue();
            collection = destination$iv;
            boolean bl = false;
            collection.add(new Permission("waypoints.limit.waypoints." + (int)it));
        }
        $this$mapTo$iv = this.getWaypointsConfig().getGeneral().getFolders().getPermissionLimits();
        destination$iv = permissions;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            int it = ((Number)item$iv).intValue();
            collection = destination$iv;
            boolean bl = false;
            collection.add(new Permission("waypoints.limit.folders." + it));
        }
        pm.addPermissions(permissions);
    }

    private final void startMetrics() {
        this.metrics = new Metrics((Plugin)this, this.METRICS_PLUGIN_ID);
        Statistics $this$startMetrics_u24lambda_u248 = this.getApi().getStatistics();
        boolean bl = false;
        Metrics metrics = this.metrics;
        if (metrics == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics = null;
        }
        metrics.addCustomChart(new SingleLineChart("total_waypoints", () -> WaypointsPlugin.startMetrics$lambda$8$lambda$6($this$startMetrics_u24lambda_u248)));
        Metrics metrics2 = this.metrics;
        if (metrics2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics2 = null;
        }
        metrics2.addCustomChart(new SingleLineChart("total_folders", () -> WaypointsPlugin.startMetrics$lambda$8$lambda$7($this$startMetrics_u24lambda_u248)));
        Metrics metrics3 = this.metrics;
        if (metrics3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics3 = null;
        }
        metrics3.addCustomChart(new SimplePie("web_map", () -> WaypointsPlugin.startMetrics$lambda$9(this)));
        Metrics metrics4 = this.metrics;
        if (metrics4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics4 = null;
        }
        metrics4.addCustomChart(new SimplePie("actually_uses_vault", () -> WaypointsPlugin.startMetrics$lambda$12(this)));
        Metrics metrics5 = this.metrics;
        if (metrics5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics5 = null;
        }
        metrics5.addCustomChart(new SimplePie("global_waypoints_enabled", () -> WaypointsPlugin.startMetrics$lambda$13(this)));
        Metrics metrics6 = this.metrics;
        if (metrics6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics6 = null;
        }
        metrics6.addCustomChart(new SimplePie("death_waypoints_enabled", () -> WaypointsPlugin.startMetrics$lambda$14(this)));
        Metrics metrics7 = this.metrics;
        if (metrics7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics7 = null;
        }
        metrics7.addCustomChart(new SimplePie("player_tracking_enabled", () -> WaypointsPlugin.startMetrics$lambda$15(this)));
        Metrics metrics8 = this.metrics;
        if (metrics8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics8 = null;
        }
        metrics8.addCustomChart(new SimplePie("protocollib_available", () -> WaypointsPlugin.startMetrics$lambda$16(this)));
        Metrics metrics9 = this.metrics;
        if (metrics9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics9 = null;
        }
        metrics9.addCustomChart(new SimplePie("actionbar_pointer_enabled", () -> WaypointsPlugin.startMetrics$lambda$17(this)));
        Metrics metrics10 = this.metrics;
        if (metrics10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics10 = null;
        }
        metrics10.addCustomChart(new SimplePie("bossbar_pointer_enabled", () -> WaypointsPlugin.startMetrics$lambda$18(this)));
        Metrics metrics11 = this.metrics;
        if (metrics11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics11 = null;
        }
        metrics11.addCustomChart(new SimplePie("beacon_pointer_enabled", () -> WaypointsPlugin.startMetrics$lambda$19(this)));
        Metrics metrics12 = this.metrics;
        if (metrics12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics12 = null;
        }
        metrics12.addCustomChart(new SimplePie("blinking_block_pointer_enabled", () -> WaypointsPlugin.startMetrics$lambda$20(this)));
        Metrics metrics13 = this.metrics;
        if (metrics13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics13 = null;
        }
        metrics13.addCustomChart(new SimplePie("compass_pointer_enabled", () -> WaypointsPlugin.startMetrics$lambda$21(this)));
        Metrics metrics14 = this.metrics;
        if (metrics14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics14 = null;
        }
        metrics14.addCustomChart(new SimplePie("particle_pointer_enabled", () -> WaypointsPlugin.startMetrics$lambda$22(this)));
        Metrics metrics15 = this.metrics;
        if (metrics15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
            metrics15 = null;
        }
        metrics15.addCustomChart(new SimplePie("trails_pointer_enabled", () -> WaypointsPlugin.startMetrics$lambda$23(this)));
    }

    private final void startBackgroundTasks() {
        AbstractScheduler scheduler = Schedulers.INSTANCE.global((Plugin)this);
        scheduler.scheduleAtFixedRateAsync(1728000L, 1728000L, new CleanDatabaseTask(this));
        if (this.getWaypointsConfig().getGeneral().getUpdateChecker()) {
            scheduler.scheduleAsync(new UpdateChecker(this, "Sytm", "waypoints"));
        }
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.getDatabaseManager$waypoints().close();
        }
        if (this.metrics != null) {
            Metrics metrics = this.metrics;
            if (metrics == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"metrics");
                metrics = null;
            }
            metrics.shutdown();
        }
    }

    private static final String initCommons$lambda$1(WaypointsPlugin this$0, TimeUnit timeUnit, boolean isPlural) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Translations $this$initCommons_u24lambda_u241_u24lambda_u240 = this$0.getTranslations();
        boolean bl = false;
        return (switch (WhenMappings.$EnumSwitchMapping$0[timeUnit.ordinal()]) {
            case 1 -> {
                if (isPlural) {
                    yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_SECONDS();
                }
                yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_SECOND();
            }
            case 2 -> {
                if (isPlural) {
                    yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_MINUTES();
                }
                yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_MINUTE();
            }
            case 3 -> {
                if (isPlural) {
                    yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_HOURS();
                }
                yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_HOUR();
            }
            case 4 -> {
                if (isPlural) {
                    yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_DAYS();
                }
                yield $this$initCommons_u24lambda_u241_u24lambda_u240.getTEXT_DURATION_DAY();
            }
            default -> throw new UnsupportedOperationException("The TimeUnit " + timeUnit + " is not supported");
        }).getRawText();
    }

    private static final Integer startMetrics$lambda$8$lambda$6(Statistics $this_with) {
        return $this_with.getTotalWaypoints();
    }

    private static final Integer startMetrics$lambda$8$lambda$7(Statistics $this_with) {
        return $this_with.getTotalFolders();
    }

    private static final String startMetrics$lambda$9(WaypointsPlugin this$0) {
        return this$0.dynMapIntegrationAvailable ? "DynMap" : (this$0.squareMapIntegrationAvailable ? "squaremap" : (this$0.blueMapIntegrationAvailable ? "BlueMap" : (this$0.pl3xMapIntegrationAvailable ? "Pl3xMap" : "none")));
    }

    private static final String startMetrics$lambda$12(WaypointsPlugin this$0) {
        boolean bl;
        block3: {
            if (this$0.vaultIntegration0 != null) {
                TeleportConfiguration it = this$0.getWaypointsConfig().getGeneral().getTeleport();
                boolean bl2 = false;
                TypedTeleportConfiguration[] typedTeleportConfigurationArray = new TypedTeleportConfiguration[]{it.getPrivate(), it.getDeath(), it.getPublic(), it.getPermission()};
                Object[] $this$any$iv = typedTeleportConfigurationArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    TypedTeleportConfiguration it2 = (TypedTeleportConfiguration)element$iv;
                    boolean bl3 = false;
                    if (!(it2.getPaymentType() == TeleportPaymentType.VAULT)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return String.valueOf(bl);
    }

    private static final String startMetrics$lambda$13(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getGeneral().getFeatures().getGlobalWaypoints());
    }

    private static final String startMetrics$lambda$14(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getGeneral().getFeatures().getDeathWaypoints());
    }

    private static final String startMetrics$lambda$15(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPlayerTracking().getEnabled());
    }

    private static final String startMetrics$lambda$16(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getServer().getPluginManager().getPlugin("ProtocolLib") != null);
    }

    private static final String startMetrics$lambda$17(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPointers().getActionBar().getEnabled());
    }

    private static final String startMetrics$lambda$18(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPointers().getBossBar().getEnabled());
    }

    private static final String startMetrics$lambda$19(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPointers().getBeacon().getEnabled());
    }

    private static final String startMetrics$lambda$20(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPointers().getBlinkingBlock().getEnabled());
    }

    private static final String startMetrics$lambda$21(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPointers().getCompass().getEnabled());
    }

    private static final String startMetrics$lambda$22(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPointers().getParticle().getEnabled());
    }

    private static final String startMetrics$lambda$23(WaypointsPlugin this$0) {
        return String.valueOf(this$0.getWaypointsConfig().getPointers().getTrail().getEnabled());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimeUnit.values().length];
            try {
                nArray[TimeUnit.SECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeUnit.MINUTES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeUnit.HOURS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeUnit.DAYS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

