/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.api;

import de.md5lukas.waypoints.api.WaypointsAPI;
import de.md5lukas.waypoints.api.base.DatabaseConfiguration;
import de.md5lukas.waypoints.api.base.DatabaseManager;
import de.md5lukas.waypoints.api.sqlite.WaypointsAPIImpl;
import de.md5lukas.waypoints.api.sqlite.jdbc.ExtensionsKt;
import de.md5lukas.waypoints.api.sqlite.jdbc.SQLiteHelper;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0014J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020\u001dH\u0014J\b\u0010&\u001a\u00020\u001dH\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bRL\u0010 \u001a@\u0012\u0004\u0012\u00020\u000f\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001d0\"\u00a2\u0006\u0002\b#0!j\u001f\u0012\u0004\u0012\u00020\u000f\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001d0\"\u00a2\u0006\u0002\b#`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/md5lukas/waypoints/api/SQLiteManager;", "Lde/md5lukas/waypoints/api/base/DatabaseManager;", "plugin", "Lorg/bukkit/plugin/Plugin;", "databaseConfiguration", "Lde/md5lukas/waypoints/api/base/DatabaseConfiguration;", "file", "Ljava/io/File;", "testing", "", "<init>", "(Lorg/bukkit/plugin/Plugin;Lde/md5lukas/waypoints/api/base/DatabaseConfiguration;Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "schemaVersion", "", "sqliteHelper", "Lde/md5lukas/waypoints/api/sqlite/jdbc/SQLiteHelper;", "api", "Lde/md5lukas/waypoints/api/WaypointsAPI;", "getApi", "()Lde/md5lukas/waypoints/api/WaypointsAPI;", "api$delegate", "Lkotlin/Lazy;", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "initConnection", "", "createTables", "cleanDatabase", "databaseUpgrades", "Ljava/util/LinkedHashMap;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Lkotlin/collections/LinkedHashMap;", "upgradeDatabase", "close", "api-sqlite"})
@SourceDebugExtension(value={"SMAP\nSQLiteManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteManager.kt\nde/md5lukas/waypoints/api/SQLiteManager\n+ 2 Extensions.kt\nde/md5lukas/jdbc/ExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,292:1\n12#2,7:293\n25#2,9:302\n216#3,2:300\n216#3,2:311\n*S KotlinDebug\n*F\n+ 1 SQLiteManager.kt\nde/md5lukas/waypoints/api/SQLiteManager\n*L\n261#1:293,7\n214#1:302,9\n275#1:300,2\n246#1:311,2\n*E\n"})
public final class SQLiteManager
extends DatabaseManager {
    @Nullable
    private final File file;
    private final int schemaVersion;
    @NotNull
    private final SQLiteHelper sqliteHelper;
    @NotNull
    private final Lazy api$delegate;
    @NotNull
    private final LinkedHashMap<Integer, Function1<Connection, Unit>> databaseUpgrades;

    /*
     * WARNING - void declaration
     */
    public SQLiteManager(@NotNull Plugin plugin, @NotNull DatabaseConfiguration databaseConfiguration, @Nullable File file, boolean testing) {
        void it;
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)databaseConfiguration, (String)"databaseConfiguration");
        super(plugin, databaseConfiguration, testing);
        this.file = file;
        this.schemaVersion = 7;
        this.sqliteHelper = this.file == null ? new SQLiteHelper() : new SQLiteHelper(this.file);
        this.api$delegate = LazyKt.lazy(() -> SQLiteManager.api_delegate$lambda$0(this));
        LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
        SQLiteManager sQLiteManager = this;
        boolean bl = false;
        ((Map)it).put(1, SQLiteManager::databaseUpgrades$lambda$11$lambda$2);
        ((Map)it).put(2, SQLiteManager::databaseUpgrades$lambda$11$lambda$3);
        ((Map)it).put(3, SQLiteManager::databaseUpgrades$lambda$11$lambda$5);
        ((Map)it).put(4, SQLiteManager::databaseUpgrades$lambda$11$lambda$6);
        ((Map)it).put(5, SQLiteManager::databaseUpgrades$lambda$11$lambda$8);
        ((Map)it).put(6, SQLiteManager::databaseUpgrades$lambda$11$lambda$9);
        ((Map)it).put(7, SQLiteManager::databaseUpgrades$lambda$11$lambda$10);
        sQLiteManager.databaseUpgrades = linkedHashMap;
    }

    public /* synthetic */ SQLiteManager(Plugin plugin, DatabaseConfiguration databaseConfiguration, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(plugin, databaseConfiguration, file, bl);
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public WaypointsAPI getApi() {
        Lazy lazy = this.api$delegate;
        return (WaypointsAPI)lazy.getValue();
    }

    @Override
    @NotNull
    public Connection getConnection() {
        return this.sqliteHelper.getConnection();
    }

    @Override
    protected void initConnection() {
        ExtensionsKt.update(this.getConnection(), "PRAGMA foreign_keys = ON;", new Object[0]);
    }

    @Override
    protected void createTables() {
        Connection $this$createTables_u24lambda_u241 = this.getConnection();
        boolean bl = false;
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS database_meta (\n                  id INTEGER NOT NULL PRIMARY KEY,\n                  schemaVersion INTEGER NOT NULL\n                );\n            ", new Object[0]);
        Object[] objectArray = new Object[]{0, this.schemaVersion};
        ExtensionsKt.update($this$createTables_u24lambda_u241, "INSERT OR IGNORE INTO database_meta(id, schemaVersion) VALUES (?, ?);", objectArray);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS player_data (\n                  id TEXT NOT NULL PRIMARY KEY,\n                  \n                  showGlobals BOOLEAN NOT NULL DEFAULT 1,\n                  sortBy TEXT NOT NULL DEFAULT 'TYPE_ASCENDING',\n                  canBeTracked BOOLEAN NOT NULL DEFAULT 0,\n                  canReceiveTemporaryWaypoints BOOLEAN NOT NULL DEFAULT 1,\n                  enabledPointers TEXT\n                );\n            ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS player_data_typed (\n                  playerId TEXT NOT NULL,\n                  type TEXT NOT NULL,\n                  \n                  cooldownUntil TEXT,\n                  teleportations INTEGER NOT NULL DEFAULT 0,\n                  \n                  PRIMARY KEY (playerId, type),\n                  FOREIGN KEY (playerId) REFERENCES player_data(id) ON DELETE CASCADE\n                );\n                ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS folders (\n                  id TEXT NOT NULL PRIMARY KEY,\n                  \n                  createdAt DATE NOT NULL,\n                  \n                  type TEXT NOT NULL,\n                  owner TEXT,\n                  \n                  name TEXT NOT NULL,\n                  description TEXT,\n                  material TEXT,\n                  \n                  FOREIGN KEY (owner) REFERENCES player_data(id) ON DELETE CASCADE \n                );\n            ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS waypoints (\n                  id TEXT NOT NULL PRIMARY KEY,\n                  \n                  createdAt DATE NOT NULL,\n                  \n                  type TEXT NOT NULL,\n                  owner TEXT,\n                  folder TEXT,\n                  \n                  name TEXT NOT NULL,\n                  description TEXT,\n                  permission TEXT,\n                  material TEXT,\n                  beaconColor TEXT,\n                  \n                  world TEXT NOT NULL,\n                  x REAL NOT NULL,\n                  y REAL NOT NULL,\n                  z REAL NOT NULL,\n                  \n                  FOREIGN KEY (owner) REFERENCES player_data(id) ON DELETE CASCADE,\n                  FOREIGN KEY (folder) REFERENCES folders(id) ON DELETE SET NULL\n                );\n            ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS waypoint_meta (\n                  waypointId TEXT NOT NULL,\n                  playerId TEXT NOT NULL,\n                  \n                  teleportations INTEGER NOT NULL DEFAULT 0,\n                  visited BOOLEAN NOT NULL DEFAULT 0,\n                  \n                  PRIMARY KEY (waypointId, playerId),\n                  FOREIGN KEY (waypointId) REFERENCES waypoints(id) ON DELETE CASCADE,\n                  FOREIGN KEY (playerId) REFERENCES player_data(id) ON DELETE CASCADE\n                );\n            ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS selected_waypoints (\n                  playerId TEXT NOT NULL,\n                  waypointId TEXT NOT NULL,\n                  'index' INTEGER NOT NULL,\n                  \n                  PRIMARY KEY (playerId, waypointId),\n                  FOREIGN KEY (playerId) REFERENCES player_data(id) ON DELETE CASCADE,\n                  FOREIGN KEY (waypointId) REFERENCES waypoints(id) ON DELETE CASCADE\n                );\n            ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n                CREATE TABLE IF NOT EXISTS waypoint_custom_data (\n                  waypointId TEXT NOT NULL,\n                  key TEXT NOT NULL,\n                  \n                  data TEXT NOT NULL,\n                  \n                  PRIMARY KEY (waypointId, key),\n                  FOREIGN KEY (waypointId) REFERENCES waypoints(id) ON DELETE CASCADE\n                );\n                ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n               CREATE TABLE IF NOT EXISTS compass_storage (\n                 playerId TEXT NOT NULL PRIMARY KEY,\n                 \n                 world TEXT NOT NULL,\n                 x REAL NOT NULL,\n                 y REAL NOT NULL,\n                 z REAL NOT NULL,\n                 \n                 FOREIGN KEY (playerId) REFERENCES player_data(id) ON DELETE CASCADE\n               );\n            ", new Object[0]);
        ExtensionsKt.update($this$createTables_u24lambda_u241, "\n               CREATE TABLE IF NOT EXISTS waypoint_shares (\n                 owner TEXT NOT NULL,\n                 sharedWith TEXT NOT NULL,\n                 shareId TEXT NOT NULL,\n                 expires DATE,\n                 \n                 PRIMARY KEY (owner, sharedWith, shareId),\n                 FOREIGN KEY (owner) REFERENCES player_data(id) ON DELETE CASCADE,\n                 FOREIGN KEY (sharedWith) REFERENCES player_data(id) ON DELETE CASCADE,\n                 FOREIGN KEY (shareId) REFERENCES waypoints(id) ON DELETE CASCADE\n               );\n      ", new Object[0]);
    }

    @Override
    public void cleanDatabase() {
        if (!this.getDatabaseConfiguration().getDeathWaypointRetentionPeriod().isZero()) {
            Object[] objectArray = new Object[]{"DEATH", OffsetDateTime.now().minus(this.getDatabaseConfiguration().getDeathWaypointRetentionPeriod()).toString()};
            ExtensionsKt.update(this.getConnection(), "DELETE FROM waypoints WHERE type = ? AND datetime(createdAt) <= datetime(?);", objectArray);
            objectArray = new Object[]{OffsetDateTime.now()};
            ExtensionsKt.update(this.getConnection(), "DELETE FROM waypoint_shares WHERE expires IS NOT NULL AND datetime(expires) <= datetime(?);", objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void upgradeDatabase() {
        ResultSet resultSet;
        void query$iv;
        void $this$selectFirst$iv;
        Connection $this$upgradeDatabase_u24lambda_u2414 = this.getConnection();
        boolean bl = false;
        Connection connection = $this$upgradeDatabase_u24lambda_u2414;
        Object object = "SELECT schemaVersion FROM database_meta WHERE id = ?;";
        Object[] objectArray = new Object[]{0};
        Object[] values$iv = objectArray;
        boolean $i$f$selectFirst = false;
        PreparedStatement preparedStatement = $this$selectFirst$iv.prepareStatement((String)query$iv);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(query)");
        AutoCloseable autoCloseable = ExtensionsKt.setValues(preparedStatement, Arrays.copyOf(values$iv, values$iv.length)).executeQuery();
        Throwable throwable = null;
        try {
            Integer n;
            ResultSet it$iv = (ResultSet)autoCloseable;
            boolean bl2 = false;
            if (it$iv.next()) {
                Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                ResultSet $this$upgradeDatabase_u24lambda_u2414_u24lambda_u2412 = it$iv;
                boolean bl3 = false;
                n = $this$upgradeDatabase_u24lambda_u2414_u24lambda_u2412.getInt("schemaVersion");
            } else {
                n = null;
            }
            it$iv = n;
            resultSet = it$iv;
        }
        catch (Throwable it$iv) {
            throwable = it$iv;
            throw it$iv;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        if (resultSet == null) {
            throw new IllegalStateException("Could not retrieve schema version of database");
        }
        int currentSchemaVersion = (Integer)((Object)resultSet);
        if (currentSchemaVersion > this.schemaVersion) {
            throw new IllegalStateException("The database uses a schema that is newer than the plugin is made for (Database: " + currentSchemaVersion + ", Plugin: " + this.schemaVersion + ")");
        }
        if (currentSchemaVersion != this.schemaVersion) {
            this.getPlugin().getLogger().log(Level.INFO, "Current database schema version: " + currentSchemaVersion + ". Required database schema version: " + this.schemaVersion);
        }
        Map $this$forEach$iv = this.databaseUpgrades;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl4 = false;
            int upgradesTo = ((Number)entry.getKey()).intValue();
            Function1 upgrade = (Function1)entry.getValue();
            if (currentSchemaVersion >= upgradesTo) continue;
            try {
                upgrade.invoke((Object)$this$upgradeDatabase_u24lambda_u2414);
                Object[] objectArray2 = new Object[]{upgradesTo, 0};
                ExtensionsKt.update($this$upgradeDatabase_u24lambda_u2414, "UPDATE database_meta SET schemaVersion = ? WHERE id = ?;", objectArray2);
            }
            catch (Exception e) {
                throw new Exception("Could not perform database upgrade to version " + upgradesTo, e);
            }
        }
    }

    @Override
    public void close() {
        this.sqliteHelper.close();
    }

    private static final WaypointsAPIImpl api_delegate$lambda$0(SQLiteManager this$0) {
        return new WaypointsAPIImpl(this$0);
    }

    private static final Unit databaseUpgrades$lambda$11$lambda$2(Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<this>");
        ExtensionsKt.update(connection, "ALTER TABLE player_data ADD COLUMN lastSelectedWaypoint TEXT REFERENCES waypoints (id) ON DELETE SET NULL;", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit databaseUpgrades$lambda$11$lambda$3(Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<this>");
        ExtensionsKt.update(connection, "ALTER TABLE player_data ADD COLUMN canBeTracked BOOLEAN NOT NULL DEFAULT 0;", new Object[0]);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit databaseUpgrades$lambda$11$lambda$5(Connection connection) {
        void query$iv;
        void $this$select$iv;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<this>");
        Connection connection2 = connection;
        String string = "SELECT playerId, type, cooldownUntil FROM player_cooldown;";
        Object[] values$iv = new Object[]{};
        boolean $i$f$select = false;
        PreparedStatement preparedStatement = $this$select$iv.prepareStatement((String)query$iv);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(query)");
        AutoCloseable autoCloseable = ExtensionsKt.setValues(preparedStatement, Arrays.copyOf(values$iv, values$iv.length)).executeQuery();
        Throwable throwable = null;
        try {
            ResultSet it$iv = (ResultSet)autoCloseable;
            boolean bl = false;
            List result$iv = new ArrayList();
            while (it$iv.next()) {
                void $this$databaseUpgrades_u24lambda_u2411_u24lambda_u245_u24lambda_u244;
                Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                ResultSet resultSet = it$iv;
                List list = result$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{$this$databaseUpgrades_u24lambda_u2411_u24lambda_u245_u24lambda_u244.getString("playerId"), $this$databaseUpgrades_u24lambda_u2411_u24lambda_u245_u24lambda_u244.getString("type"), $this$databaseUpgrades_u24lambda_u2411_u24lambda_u245_u24lambda_u244.getString("cooldownUntil")};
                list.add(ExtensionsKt.update(connection, "INSERT INTO player_data_typed(playerId, type, cooldownUntil) VALUES (?, ?, ?);", objectArray));
            }
            List list = result$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        ExtensionsKt.update(connection, "DROP TABLE player_cooldown;", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit databaseUpgrades$lambda$11$lambda$6(Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<this>");
        ExtensionsKt.update(connection, "ALTER TABLE waypoint_meta ADD COLUMN visited BOOLEAN NOT NULL DEFAULT 0;", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit databaseUpgrades$lambda$11$lambda$8(Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CLEAR", (Object)"GLASS"), TuplesKt.to((Object)"LIGHT_GRAY", (Object)"LIGHT_GRAY_STAINED_GLASS"), TuplesKt.to((Object)"GRAY", (Object)"GRAY_STAINED_GLASS"), TuplesKt.to((Object)"PINK", (Object)"PINK_STAINED_GLASS"), TuplesKt.to((Object)"LIME", (Object)"LIME_STAINED_GLASS"), TuplesKt.to((Object)"YELLOW", (Object)"YELLOW_STAINED_GLASS"), TuplesKt.to((Object)"LIGHT_BLUE", (Object)"LIGHT_BLUE_STAINED_GLASS"), TuplesKt.to((Object)"MAGENTA", (Object)"MAGENTA_STAINED_GLASS"), TuplesKt.to((Object)"ORANGE", (Object)"ORANGE_STAINED_GLASS"), TuplesKt.to((Object)"WHITE", (Object)"WHITE_STAINED_GLASS"), TuplesKt.to((Object)"BLACK", (Object)"BLACK_STAINED_GLASS"), TuplesKt.to((Object)"RED", (Object)"RED_STAINED_GLASS"), TuplesKt.to((Object)"GREEN", (Object)"GREEN_STAINED_GLASS"), TuplesKt.to((Object)"BROWN", (Object)"BROWN_STAINED_GLASS"), TuplesKt.to((Object)"BLUE", (Object)"BLUE_STAINED_GLASS"), TuplesKt.to((Object)"CYAN", (Object)"CYAN_STAINED_GLASS"), TuplesKt.to((Object)"PURPLE", (Object)"PURPLE_STAINED_GLASS")};
        Map $this$forEach$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String old = (String)entry.getKey();
            String string = (String)entry.getValue();
            Object[] objectArray = new Object[]{string, old};
            ExtensionsKt.update(connection, "UPDATE waypoints SET beaconColor = ? WHERE beaconColor = ?;", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit databaseUpgrades$lambda$11$lambda$9(Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<this>");
        ExtensionsKt.update(connection, "ALTER TABLE player_data ADD COLUMN enabledPointers TEXT;", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit databaseUpgrades$lambda$11$lambda$10(Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<this>");
        ExtensionsKt.update(connection, "ALTER TABLE player_data ADD COLUMN canReceiveTemporaryWaypoints BOOLEAN NOT NULL DEFAULT 0;", new Object[0]);
        ExtensionsKt.update(connection, "UPDATE player_data SET canReceiveTemporaryWaypoints = 1;", new Object[0]);
        return Unit.INSTANCE;
    }
}

