/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.api.sqlite;

import de.md5lukas.waypoints.api.SQLiteManager;
import de.md5lukas.waypoints.api.Statistics;
import de.md5lukas.waypoints.api.Type;
import de.md5lukas.waypoints.api.sqlite.jdbc.ExtensionsKt;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lde/md5lukas/waypoints/api/sqlite/StatisticsImpl;", "Lde/md5lukas/waypoints/api/Statistics;", "dm", "Lde/md5lukas/waypoints/api/SQLiteManager;", "<init>", "(Lde/md5lukas/waypoints/api/SQLiteManager;)V", "totalWaypoints", "", "getTotalWaypoints", "()I", "privateWaypoints", "getPrivateWaypoints", "deathWaypoints", "getDeathWaypoints", "publicWaypoints", "getPublicWaypoints", "permissionWaypoints", "getPermissionWaypoints", "totalFolders", "getTotalFolders", "privateFolders", "getPrivateFolders", "publicFolders", "getPublicFolders", "permissionFolders", "getPermissionFolders", "getWaypointCount", "type", "Lde/md5lukas/waypoints/api/Type;", "getFolderCount", "databaseSize", "", "getDatabaseSize", "()J", "api-sqlite"})
@SourceDebugExtension(value={"SMAP\nStatisticsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsImpl.kt\nde/md5lukas/waypoints/api/sqlite/StatisticsImpl\n+ 2 Extensions.kt\nde/md5lukas/jdbc/ExtensionsKt\n*L\n1#1,50:1\n12#2,7:51\n12#2,7:58\n12#2,7:65\n12#2,7:72\n*S KotlinDebug\n*F\n+ 1 StatisticsImpl.kt\nde/md5lukas/waypoints/api/sqlite/StatisticsImpl\n*L\n11#1:51,7\n26#1:58,7\n38#1:65,7\n43#1:72,7\n*E\n"})
public final class StatisticsImpl
implements Statistics {
    @NotNull
    private final SQLiteManager dm;

    public StatisticsImpl(@NotNull SQLiteManager dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        this.dm = dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public int getTotalWaypoints() {
        Integer n;
        void query$iv;
        void $this$selectFirst$iv;
        Connection connection = this.dm.getConnection();
        String string = "SELECT COUNT(*) FROM waypoints;";
        Object[] values$iv = new Object[]{};
        boolean $i$f$selectFirst = false;
        PreparedStatement preparedStatement = $this$selectFirst$iv.prepareStatement((String)query$iv);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(query)");
        AutoCloseable autoCloseable = ExtensionsKt.setValues(preparedStatement, Arrays.copyOf(values$iv, values$iv.length)).executeQuery();
        Throwable throwable = null;
        try {
            Integer n2;
            ResultSet it$iv = (ResultSet)autoCloseable;
            boolean bl = false;
            if (it$iv.next()) {
                Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                ResultSet $this$_get_totalWaypoints__u24lambda_u240 = it$iv;
                boolean bl2 = false;
                n2 = $this$_get_totalWaypoints__u24lambda_u240.getInt(1);
            } else {
                n2 = null;
            }
            Integer n3 = n2;
            n = n3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return n != null ? n : 0;
    }

    @Override
    public int getPrivateWaypoints() {
        return this.getWaypointCount(Type.PRIVATE);
    }

    @Override
    public int getDeathWaypoints() {
        return this.getWaypointCount(Type.DEATH);
    }

    @Override
    public int getPublicWaypoints() {
        return this.getWaypointCount(Type.PUBLIC);
    }

    @Override
    public int getPermissionWaypoints() {
        return this.getWaypointCount(Type.PERMISSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public int getTotalFolders() {
        Integer n;
        void query$iv;
        void $this$selectFirst$iv;
        Connection connection = this.dm.getConnection();
        String string = "SELECT COUNT(*) FROM folders;";
        Object[] values$iv = new Object[]{};
        boolean $i$f$selectFirst = false;
        PreparedStatement preparedStatement = $this$selectFirst$iv.prepareStatement((String)query$iv);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(query)");
        AutoCloseable autoCloseable = ExtensionsKt.setValues(preparedStatement, Arrays.copyOf(values$iv, values$iv.length)).executeQuery();
        Throwable throwable = null;
        try {
            Integer n2;
            ResultSet it$iv = (ResultSet)autoCloseable;
            boolean bl = false;
            if (it$iv.next()) {
                Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                ResultSet $this$_get_totalFolders__u24lambda_u241 = it$iv;
                boolean bl2 = false;
                n2 = $this$_get_totalFolders__u24lambda_u241.getInt(1);
            } else {
                n2 = null;
            }
            Integer n3 = n2;
            n = n3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return n != null ? n : 0;
    }

    @Override
    public int getPrivateFolders() {
        return this.getFolderCount(Type.PRIVATE);
    }

    @Override
    public int getPublicFolders() {
        return this.getFolderCount(Type.PUBLIC);
    }

    @Override
    public int getPermissionFolders() {
        return this.getFolderCount(Type.PERMISSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int getWaypointCount(Type type) {
        Integer n;
        void query$iv;
        void $this$selectFirst$iv;
        Connection connection = this.dm.getConnection();
        String string = "SELECT COUNT(*) FROM waypoints WHERE type = ?;";
        Object[] objectArray = new Object[]{type.name()};
        Object[] values$iv = objectArray;
        boolean $i$f$selectFirst = false;
        PreparedStatement preparedStatement = $this$selectFirst$iv.prepareStatement((String)query$iv);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(query)");
        AutoCloseable autoCloseable = ExtensionsKt.setValues(preparedStatement, Arrays.copyOf(values$iv, values$iv.length)).executeQuery();
        Throwable throwable = null;
        try {
            Integer n2;
            ResultSet it$iv = (ResultSet)autoCloseable;
            boolean bl = false;
            if (it$iv.next()) {
                Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                ResultSet $this$getWaypointCount_u24lambda_u242 = it$iv;
                boolean bl2 = false;
                n2 = $this$getWaypointCount_u24lambda_u242.getInt(1);
            } else {
                n2 = null;
            }
            Integer n3 = n2;
            n = n3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return n != null ? n : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int getFolderCount(Type type) {
        Integer n;
        void query$iv;
        void $this$selectFirst$iv;
        Connection connection = this.dm.getConnection();
        String string = "SELECT COUNT(*) FROM folders WHERE type = ?;";
        Object[] objectArray = new Object[]{type.name()};
        Object[] values$iv = objectArray;
        boolean $i$f$selectFirst = false;
        PreparedStatement preparedStatement = $this$selectFirst$iv.prepareStatement((String)query$iv);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(query)");
        AutoCloseable autoCloseable = ExtensionsKt.setValues(preparedStatement, Arrays.copyOf(values$iv, values$iv.length)).executeQuery();
        Throwable throwable = null;
        try {
            Integer n2;
            ResultSet it$iv = (ResultSet)autoCloseable;
            boolean bl = false;
            if (it$iv.next()) {
                Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                ResultSet $this$getFolderCount_u24lambda_u243 = it$iv;
                boolean bl2 = false;
                n2 = $this$getFolderCount_u24lambda_u243.getInt(1);
            } else {
                n2 = null;
            }
            Integer n3 = n2;
            n = n3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return n != null ? n : 0;
    }

    @Override
    public long getDatabaseSize() {
        File file = this.dm.getFile();
        return file != null ? file.length() : 0L;
    }
}

