/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.api.sqlite.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e*\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/md5lukas/waypoints/api/sqlite/jdbc/SQLiteHelper;", "", "()V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "path", "", "(Ljava/lang/String;)V", "connection", "Ljava/sql/Connection;", "getConnection$delegate", "(Lde/md5lukas/jdbc/SQLiteHelper;)Ljava/lang/Object;", "getConnection", "()Ljava/sql/Connection;", "connectionLazy", "Lkotlin/Lazy;", "isClosed", "", "()Z", "close", "", "sqlite-kotlin-helper"})
public class SQLiteHelper {
    @NotNull
    private final String path;
    @NotNull
    private final Lazy<Connection> connectionLazy;

    private SQLiteHelper(String path) {
        this.path = path;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("There is no SQLite driver present");
        }
        this.connectionLazy = LazyKt.lazy((Function0)((Function0)new Function0<Connection>(this){
            final /* synthetic */ SQLiteHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Connection invoke() {
                return DriverManager.getConnection("jdbc:sqlite:" + SQLiteHelper.access$getPath$p(this.this$0));
            }
        }));
    }

    public SQLiteHelper() {
        this(":memory:");
    }

    public SQLiteHelper(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        this(string);
    }

    @NotNull
    public final Connection getConnection() {
        Lazy<Connection> lazy = this.connectionLazy;
        return (Connection)lazy.getValue();
    }

    private static Object getConnection$delegate(SQLiteHelper sQLiteHelper) {
        return sQLiteHelper.connectionLazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (!this.connectionLazy.isInitialized() && !this.getConnection().isClosed()) {
            Connection connection = this.getConnection();
            synchronized (connection) {
                boolean bl = false;
                this.getConnection().close();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final boolean isClosed() {
        return !this.connectionLazy.isInitialized() || this.getConnection().isClosed();
    }

    public static final /* synthetic */ String access$getPath$p(SQLiteHelper $this) {
        return $this.path;
    }
}

