/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.config.database;

import de.md5lukas.waypoints.api.base.DatabaseConfiguration;
import de.md5lukas.waypoints.libs.konfig.Configurable;
import de.md5lukas.waypoints.libs.konfig.TypeAdapter;
import de.md5lukas.waypoints.libs.konfig.UseAdapter;
import java.time.Period;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Configurable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0016@RX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lde/md5lukas/waypoints/config/database/DatabaseConfigurationImpl;", "Lde/md5lukas/waypoints/api/base/DatabaseConfiguration;", "<init>", "()V", "value", "Ljava/time/Period;", "deathWaypointRetentionPeriod", "getDeathWaypointRetentionPeriod$annotations", "getDeathWaypointRetentionPeriod", "()Ljava/time/Period;", "PeriodAdapter", "waypoints"})
public final class DatabaseConfigurationImpl
implements DatabaseConfiguration {
    @NotNull
    private Period deathWaypointRetentionPeriod;

    public DatabaseConfigurationImpl() {
        Period period = Period.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)period, (String)"ZERO");
        this.deathWaypointRetentionPeriod = period;
    }

    @Override
    @NotNull
    public Period getDeathWaypointRetentionPeriod() {
        return this.deathWaypointRetentionPeriod;
    }

    @UseAdapter(adapter=PeriodAdapter.class)
    public static /* synthetic */ void getDeathWaypointRetentionPeriod$annotations() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lde/md5lukas/waypoints/config/database/DatabaseConfigurationImpl$PeriodAdapter;", "Lde/md5lukas/waypoints/libs/konfig/TypeAdapter;", "Ljava/time/Period;", "<init>", "()V", "get", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "path", "", "waypoints"})
    private static final class PeriodAdapter
    implements TypeAdapter<Period> {
        @Override
        @Nullable
        public Period get(@NotNull ConfigurationSection section, @NotNull String path) {
            Period period;
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Period it = period = Period.of(section.getInt(path + ".years"), section.getInt(path + ".months"), section.getInt(path + ".days"));
            boolean bl = false;
            if (it.isNegative()) {
                throw new IllegalArgumentException("The value for the death waypoint retention period must not be negative");
            }
            return period;
        }
    }
}

