/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.config.general;

import de.md5lukas.waypoints.api.Type;
import de.md5lukas.waypoints.config.general.TeleportPaymentType;
import de.md5lukas.waypoints.libs.konfig.ConfigPath;
import de.md5lukas.waypoints.libs.konfig.Configurable;
import de.md5lukas.waypoints.libs.konfig.TypeAdapter;
import de.md5lukas.waypoints.libs.konfig.UseAdapter;
import de.md5lukas.waypoints.util.Expression;
import de.md5lukas.waypoints.util.MathParser;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Configurable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\n0\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR&\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b \u0010\u0019R&\u0010\"\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020!8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010\u0003\u001a\u0004\b$\u0010%R&\u0010'\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020&8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010\u0003\u001a\u0004\b)\u0010*R$\u0010+\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b,\u0010\u0011\u00a8\u0006."}, d2={"Lde/md5lukas/waypoints/config/general/TypedTeleportConfiguration;", "", "<init>", "()V", "value", "Ljava/time/Duration;", "cooldown", "getCooldown", "()Ljava/time/Duration;", "", "Lde/md5lukas/waypoints/api/Type;", "alsoApplyCooldownTo", "getAlsoApplyCooldownTo", "()Ljava/util/List;", "", "mustVisit", "getMustVisit", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "Lde/md5lukas/waypoints/config/general/TeleportPaymentType;", "paymentType", "getPaymentType", "()Lde/md5lukas/waypoints/config/general/TeleportPaymentType;", "perCategory", "getPerCategory", "()Z", "", "maxCost", "getMaxCost", "()J", "differentWorldAllow", "getDifferentWorldAllow$annotations", "getDifferentWorldAllow", "", "differentWorldDistance", "getDifferentWorldDistance$annotations", "getDifferentWorldDistance", "()D", "Lde/md5lukas/waypoints/util/Expression;", "formula", "getFormula$annotations", "getFormula", "()Lde/md5lukas/waypoints/util/Expression;", "onlyLastWaypoint", "getOnlyLastWaypoint", "MathAdapter", "waypoints"})
public final class TypedTeleportConfiguration {
    @NotNull
    private Duration cooldown;
    @NotNull
    private List<? extends Type> alsoApplyCooldownTo;
    @Nullable
    private Boolean mustVisit;
    @NotNull
    private TeleportPaymentType paymentType;
    private boolean perCategory;
    private long maxCost;
    private boolean differentWorldAllow;
    private double differentWorldDistance;
    @NotNull
    private Expression formula;
    @Nullable
    private Boolean onlyLastWaypoint;

    public TypedTeleportConfiguration() {
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        this.cooldown = duration;
        this.alsoApplyCooldownTo = CollectionsKt.emptyList();
        this.mustVisit = false;
        this.paymentType = TeleportPaymentType.XP;
        this.maxCost = 1L;
        this.differentWorldAllow = true;
        this.formula = MathParser.Companion.parse("1", new String[0]);
        this.onlyLastWaypoint = false;
    }

    @NotNull
    public final Duration getCooldown() {
        return this.cooldown;
    }

    @NotNull
    public final List<Type> getAlsoApplyCooldownTo() {
        return this.alsoApplyCooldownTo;
    }

    @Nullable
    public final Boolean getMustVisit() {
        return this.mustVisit;
    }

    @NotNull
    public final TeleportPaymentType getPaymentType() {
        return this.paymentType;
    }

    public final boolean getPerCategory() {
        return this.perCategory;
    }

    public final long getMaxCost() {
        return this.maxCost;
    }

    public final boolean getDifferentWorldAllow() {
        return this.differentWorldAllow;
    }

    @ConfigPath(path="differentWorld.allow")
    public static /* synthetic */ void getDifferentWorldAllow$annotations() {
    }

    public final double getDifferentWorldDistance() {
        return this.differentWorldDistance;
    }

    @ConfigPath(path="differentWorld.distance")
    public static /* synthetic */ void getDifferentWorldDistance$annotations() {
    }

    @NotNull
    public final Expression getFormula() {
        return this.formula;
    }

    @UseAdapter(adapter=MathAdapter.class)
    public static /* synthetic */ void getFormula$annotations() {
    }

    @Nullable
    public final Boolean getOnlyLastWaypoint() {
        return this.onlyLastWaypoint;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lde/md5lukas/waypoints/config/general/TypedTeleportConfiguration$MathAdapter;", "Lde/md5lukas/waypoints/libs/konfig/TypeAdapter;", "Lde/md5lukas/waypoints/util/Expression;", "<init>", "()V", "get", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "path", "", "waypoints"})
    @SourceDebugExtension(value={"SMAP\nTeleportConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeleportConfiguration.kt\nde/md5lukas/waypoints/config/general/TypedTeleportConfiguration$MathAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
    private static final class MathAdapter
    implements TypeAdapter<Expression> {
        @Override
        @Nullable
        public Expression get(@NotNull ConfigurationSection section, @NotNull String path) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = section.getString(path);
            if (string != null) {
                String it = string;
                boolean bl = false;
                String[] stringArray = new String[]{"n", "distance"};
                expression = MathParser.Companion.parse(it, stringArray);
            } else {
                expression = null;
            }
            return expression;
        }
    }
}

