/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.config.inventory;

import de.md5lukas.waypoints.api.Icon;
import de.md5lukas.waypoints.api.base.IconKt;
import de.md5lukas.waypoints.libs.commons.paper.ConfigKt;
import de.md5lukas.waypoints.libs.konfig.Configurable;
import de.md5lukas.waypoints.libs.konfig.ExportConfigurationSection;
import de.md5lukas.waypoints.libs.konfig.SkipConfig;
import de.md5lukas.waypoints.util.SpigotHelperKt;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Configurable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R*\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00058B@BX\u0083\u000e\u00a2\u0006\u0012\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/md5lukas/waypoints/config/inventory/InventoryConfiguration;", "", "<init>", "()V", "_rootConfig", "Lorg/bukkit/configuration/ConfigurationSection;", "get_rootConfig$annotations", "value", "rootConfig", "getRootConfig$annotations", "getRootConfig", "()Lorg/bukkit/configuration/ConfigurationSection;", "setRootConfig", "(Lorg/bukkit/configuration/ConfigurationSection;)V", "itemCache", "Ljava/util/HashMap;", "", "Lorg/bukkit/inventory/ItemStack;", "Lkotlin/collections/HashMap;", "headPrefix", "createNewStack", "plugin", "Lorg/bukkit/plugin/Plugin;", "path", "waypoints"})
@SourceDebugExtension(value={"SMAP\nInventoryConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventoryConfiguration.kt\nde/md5lukas/waypoints/config/inventory/InventoryConfiguration\n+ 2 Items.kt\nde/md5lukas/commons/paper/ItemsKt\n*L\n1#1,66:1\n31#2,2:67\n*S KotlinDebug\n*F\n+ 1 InventoryConfiguration.kt\nde/md5lukas/waypoints/config/inventory/InventoryConfiguration\n*L\n52#1:67,2\n*E\n"})
public final class InventoryConfiguration {
    @Nullable
    private ConfigurationSection _rootConfig;
    @NotNull
    private final HashMap<String, ItemStack> itemCache = new HashMap();
    @NotNull
    private final String headPrefix;

    public InventoryConfiguration() {
        this.headPrefix = "PLAYER_HEAD:";
    }

    @SkipConfig
    private static /* synthetic */ void get_rootConfig$annotations() {
    }

    private final ConfigurationSection getRootConfig() {
        ConfigurationSection configurationSection = this._rootConfig;
        Intrinsics.checkNotNull((Object)configurationSection);
        return configurationSection;
    }

    private final void setRootConfig(ConfigurationSection value) {
        this._rootConfig = value;
        this.itemCache.clear();
    }

    @ExportConfigurationSection(root=true)
    private static /* synthetic */ void getRootConfig$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemStack createNewStack(@NotNull Plugin plugin, @NotNull String path) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ItemStack cached = this.itemCache.get(path);
        if (cached != null) {
            ItemStack itemStack2 = cached.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
            return itemStack2;
        }
        String materialString = ConfigKt.getStringNotNull(this.getRootConfig(), path);
        if (StringsKt.startsWith$default((String)materialString, (String)this.headPrefix, (boolean)false, (int)2, null)) {
            try {
                String string = materialString.substring(this.headPrefix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                var6_5 = SpigotHelperKt.createCustomPlayerHead(plugin, string);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Invalid player head format at " + path, t);
            }
            itemStack = var6_5;
        } else {
            try {
                ItemStack itemStack3;
                Icon icon = IconKt.parseIcon(materialString);
                boolean bl = false;
                ItemStack stack = itemStack3 = new ItemStack(icon.getMaterial());
                boolean bl2 = false;
                Integer n = icon.getCustomModelData();
                if (n != null) {
                    void $this$editMeta$iv;
                    int customModelData = ((Number)n).intValue();
                    boolean bl3 = false;
                    ItemStack itemStack4 = stack;
                    Function1 block$iv = arg_0 -> InventoryConfiguration.createNewStack$lambda$3$lambda$2$lambda$1$lambda$0(customModelData, arg_0);
                    boolean $i$f$editMeta = false;
                    Function1 function1 = block$iv;
                    $this$editMeta$iv.editMeta(ItemMeta.class, new Consumer(function1){
                        private final /* synthetic */ Function1 function;
                        {
                            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                            this.function = function;
                        }

                        public final /* synthetic */ void accept(Object p0) {
                            this.function.invoke(p0);
                        }
                    });
                }
                var6_5 = itemStack3;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("The material " + materialString + " at " + path + " is not valid", t);
            }
            itemStack = var6_5;
        }
        ItemStack stack = itemStack;
        ((Map)this.itemCache).put(path, stack);
        ItemStack itemStack5 = stack.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"clone(...)");
        return itemStack5;
    }

    private static final Unit createNewStack$lambda$3$lambda$2$lambda$1$lambda$0(int $customModelData, ItemMeta $this$editMeta) {
        Intrinsics.checkNotNullParameter((Object)$this$editMeta, (String)"$this$editMeta");
        $this$editMeta.setCustomModelData(Integer.valueOf($customModelData));
        return Unit.INSTANCE;
    }
}

