/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.config.pointers;

import de.md5lukas.waypoints.api.Type;
import de.md5lukas.waypoints.config.pointers.RepeatingPointerConfigurationImpl;
import de.md5lukas.waypoints.libs.commons.paper.ConfigKt;
import de.md5lukas.waypoints.libs.konfig.ConfigPath;
import de.md5lukas.waypoints.libs.konfig.Configurable;
import de.md5lukas.waypoints.libs.konfig.TypeAdapter;
import de.md5lukas.waypoints.libs.konfig.UseAdapter;
import de.md5lukas.waypoints.pointers.BeaconColor;
import de.md5lukas.waypoints.pointers.PlayerTrackable;
import de.md5lukas.waypoints.pointers.TemporaryWaypointTrackable;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.WaypointTrackable;
import de.md5lukas.waypoints.pointers.config.BeaconConfiguration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Configurable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001aR,\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0016@RX\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0004\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR,\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0016@RX\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u0004\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0011@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00160\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u0004R\u0018\u0010\u001e\u001a\u00020\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001f\u0010\u0004R\u0018\u0010 \u001a\u00020\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b!\u0010\u0004\u00a8\u0006$"}, d2={"Lde/md5lukas/waypoints/config/pointers/BeaconConfigurationImpl;", "Lde/md5lukas/waypoints/config/pointers/RepeatingPointerConfigurationImpl;", "Lde/md5lukas/waypoints/pointers/config/BeaconConfiguration;", "<init>", "()V", "value", "", "minDistanceSquared", "getMinDistanceSquared$annotations", "getMinDistanceSquared", "()J", "setMinDistanceSquared", "(J)V", "maxDistanceSquared", "getMaxDistanceSquared$annotations", "getMaxDistanceSquared", "setMaxDistanceSquared", "Lorg/bukkit/block/data/BlockData;", "baseBlock", "getBaseBlock", "()Lorg/bukkit/block/data/BlockData;", "getDefaultColor", "Lde/md5lukas/waypoints/pointers/BeaconColor;", "trackable", "Lde/md5lukas/waypoints/pointers/Trackable;", "type", "Lde/md5lukas/waypoints/api/Type;", "defaultColor", "", "getDefaultColor$annotations", "playerTrackableColor", "getPlayerTrackableColor$annotations", "temporaryTrackableColor", "getTemporaryTrackableColor$annotations", "AutoViewDistance", "BeaconColorDefaults", "waypoints"})
public final class BeaconConfigurationImpl
extends RepeatingPointerConfigurationImpl
implements BeaconConfiguration {
    private long minDistanceSquared;
    private long maxDistanceSquared;
    @NotNull
    private BlockData baseBlock;
    @NotNull
    private Map<Type, ? extends BeaconColor> defaultColor;
    @NotNull
    private BeaconColor playerTrackableColor;
    @NotNull
    private BeaconColor temporaryTrackableColor;

    public BeaconConfigurationImpl() {
        BlockData blockData = Material.IRON_BLOCK.createBlockData();
        Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"createBlockData(...)");
        this.baseBlock = blockData;
        this.defaultColor = MapsKt.emptyMap();
        this.playerTrackableColor = BeaconColor.CLEAR;
        this.temporaryTrackableColor = BeaconColor.CLEAR;
    }

    @Override
    public long getMinDistanceSquared() {
        return this.minDistanceSquared;
    }

    private void setMinDistanceSquared(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("The minDistance must be greater than zero (" + value + ")");
        }
        this.minDistanceSquared = value * value;
    }

    @ConfigPath(path="minDistance")
    public static /* synthetic */ void getMinDistanceSquared$annotations() {
    }

    @Override
    public long getMaxDistanceSquared() {
        return this.maxDistanceSquared;
    }

    private void setMaxDistanceSquared(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("The maxDistance must be greater than zero (" + value + ")");
        }
        this.maxDistanceSquared = value * value;
    }

    @ConfigPath(path="maxDistance")
    @UseAdapter(adapter=AutoViewDistance.class)
    public static /* synthetic */ void getMaxDistanceSquared$annotations() {
    }

    @Override
    @NotNull
    public BlockData getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @Nullable
    public BeaconColor getDefaultColor(@NotNull Trackable trackable) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        Trackable trackable2 = trackable;
        return trackable2 instanceof WaypointTrackable ? this.defaultColor.get((Object)((WaypointTrackable)trackable).getWaypoint().getType()) : (trackable2 instanceof PlayerTrackable ? this.playerTrackableColor : (trackable2 instanceof TemporaryWaypointTrackable ? this.temporaryTrackableColor : null));
    }

    @Nullable
    public final BeaconColor getDefaultColor(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.defaultColor.get((Object)type);
    }

    @UseAdapter(adapter=BeaconColorDefaults.class)
    private static /* synthetic */ void getDefaultColor$annotations() {
    }

    @ConfigPath(path="defaultColor.player")
    private static /* synthetic */ void getPlayerTrackableColor$annotations() {
    }

    @ConfigPath(path="defaultColor.temporary")
    private static /* synthetic */ void getTemporaryTrackableColor$annotations() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lde/md5lukas/waypoints/config/pointers/BeaconConfigurationImpl$AutoViewDistance;", "Lde/md5lukas/waypoints/libs/konfig/TypeAdapter;", "", "<init>", "()V", "get", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "path", "", "(Lorg/bukkit/configuration/ConfigurationSection;Ljava/lang/String;)Ljava/lang/Long;", "waypoints"})
    private static final class AutoViewDistance
    implements TypeAdapter<Long> {
        @Override
        @NotNull
        public Long get(@NotNull ConfigurationSection section, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return section.isLong(path) ? section.getLong("maxDistance") : (long)Bukkit.getViewDistance() * (long)16;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lde/md5lukas/waypoints/config/pointers/BeaconConfigurationImpl$BeaconColorDefaults;", "Lde/md5lukas/waypoints/libs/konfig/TypeAdapter;", "", "Lde/md5lukas/waypoints/api/Type;", "Lde/md5lukas/waypoints/pointers/BeaconColor;", "<init>", "()V", "get", "", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "path", "", "waypoints"})
    @SourceDebugExtension(value={"SMAP\nBeaconConfigurationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeaconConfigurationImpl.kt\nde/md5lukas/waypoints/config/pointers/BeaconConfigurationImpl$BeaconColorDefaults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1869#2,2:77\n*S KotlinDebug\n*F\n+ 1 BeaconConfigurationImpl.kt\nde/md5lukas/waypoints/config/pointers/BeaconConfigurationImpl$BeaconColorDefaults\n*L\n70#1:77,2\n*E\n"})
    private static final class BeaconColorDefaults
    implements TypeAdapter<Map<Type, ? extends BeaconColor>> {
        @Override
        @NotNull
        public Map<Type, BeaconColor> get(@NotNull ConfigurationSection section, @NotNull String path) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Map map2 = map = (Map)new LinkedHashMap();
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)Type.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Type it = (Type)((Object)element$iv);
                boolean bl2 = false;
                String string = it.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                map2.put(it, BeaconColor.valueOf(ConfigKt.getStringNotNull(section, path + "." + string)));
            }
            return map;
        }
    }
}

